/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.broad.igv.Globals;
import org.broad.igv.feature.SequenceManager;
import org.broad.igv.ui.IGV;

public class AltSequenceGenerator {
    public static void main(String[] args) throws IOException {
        IGV.getInstance().getGenomeManager().loadGenomeByID("hg18");
        Globals.setHeadless(true);
        AltSequenceGenerator.dumpSequence();
    }

    public static void dumpSequence() throws IOException {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter("kcnn3_trf_1.fa")));
        String genome = "hg18";
        String chr = "chr1";
        int repeatStart = 153108941;
        int repeatEnd = 153108977;
        int preEnd = repeatStart;
        int preStart = preEnd - 1000;
        int postStart = repeatEnd;
        int postEnd = postStart + 1000;
        StringBuffer seqStringBuffer = new StringBuffer();
        String preSeq = new String(SequenceManager.readSequence(genome, chr, preStart, preEnd));
        String repeatString = new String(SequenceManager.readSequence(genome, chr, repeatStart, repeatEnd));
        String postSeq = new String(SequenceManager.readSequence(genome, chr, postStart, postEnd));
        seqStringBuffer.append(preSeq);
        seqStringBuffer.append(repeatString);
        seqStringBuffer.append(postSeq);
        pw.println(">kcnn3_trf_1_m0");
        AltSequenceGenerator.printFasta(pw, seqStringBuffer.toString());
        for (int i2 = 1; i2 < 5; ++i2) {
            pw.println(">kcnn3_trf_1_m" + i2);
            seqStringBuffer = new StringBuffer();
            String modRepeat = repeatString.substring(i2 * 3);
            seqStringBuffer.append(preSeq);
            seqStringBuffer.append(modRepeat);
            seqStringBuffer.append(postSeq);
            String seqString = seqStringBuffer.toString();
            AltSequenceGenerator.printFasta(pw, seqString);
        }
        String modRepeat = repeatString;
        String trf = repeatString.substring(0, 3);
        for (int i3 = 1; i3 < 10; ++i3) {
            pw.println(">kcnn3_trf_1_p" + i3);
            seqStringBuffer = new StringBuffer();
            modRepeat = modRepeat + trf;
            seqStringBuffer.append(preSeq);
            seqStringBuffer.append(modRepeat);
            seqStringBuffer.append(postSeq);
            String seqString = seqStringBuffer.toString();
            AltSequenceGenerator.printFasta(pw, seqString);
        }
        pw.close();
    }

    private static void printFasta(PrintWriter pw, String seqString) {
        int len = seqString.length();
        int lineLength = 80;
        for (int start = 0; start < len; start += lineLength) {
            int end = Math.min(len, start + lineLength);
            pw.println(seqString.substring(start, end));
        }
    }
}

