/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.util.CloseableIterator;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.reader.AlignmentQueryReader;
import org.broad.igv.sam.reader.FeatureIndex;
import org.broad.igv.sam.reader.SamQueryReaderFactory;
import org.broad.igv.util.ResourceLocator;
import org.broad.tribble.readers.AsciiLineReader;

public class SAMReaderTest {
    public static void main(String[] args) throws IOException {
        SAMReaderTest.testQueryBam();
    }

    public static void testQuerySamFile(File f2) {
    }

    public static boolean isPutatitveXLocation(SAMRecord alignment) {
        return alignment.getMappingQuality() > 0 && alignment.getReadPairedFlag() && alignment.getReadPairedFlag() && !alignment.getReadUnmappedFlag() && !alignment.getReferenceName().equals(alignment.getMateReferenceName());
    }

    public static boolean isPutatitveRerrangement(SAMRecord alignment) {
        return alignment.getMappingQuality() > 0 && alignment.getReadPairedFlag() && alignment.getReadPairedFlag() && !alignment.getReadUnmappedFlag() && (!alignment.getReferenceName().equals(alignment.getMateReferenceName()) || Math.abs(alignment.getInferredInsertSize()) > 10000);
    }

    public static void extractRearrangments(File f2, File outputFile, boolean xOnly, int nLimit) {
        SAMFileReader.setDefaultValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        SAMFileReader reader = new SAMFileReader(f2);
        SAMFileHeader header = reader.getFileHeader();
        SAMFileWriter newWriter = new SAMFileWriterFactory().makeBAMWriter(header, true, outputFile);
        SAMRecordIterator iter = reader.iterator();
        for (int count = 0; iter.hasNext() && (nLimit < 0 || count < nLimit); ++count) {
            SAMRecord record = (SAMRecord)iter.next();
            if (!SAMReaderTest.isPutatitveXLocation(record) && (xOnly || !SAMReaderTest.isPutatitveRerrangement(record))) continue;
            newWriter.addAlignment(record);
        }
        newWriter.close();
    }

    public static void testReadRecords(File f2, int nRecords) {
        int n2;
        SAMFileReader.setDefaultValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        SAMFileReader reader = new SAMFileReader(f2);
        SAMRecordIterator iter = reader.iterator();
        long t0 = System.currentTimeMillis();
        for (n2 = 0; iter.hasNext() && n2 <= nRecords; ++n2) {
            SAMRecord record = (SAMRecord)iter.next();
            record.getAlignmentStart();
            String baseSeq = record.getReadString();
            byte[] bases = record.getReadBases();
            int start = record.getAlignmentStart();
            int end = record.getAlignmentEnd();
            byte[] qualites = record.getBaseQualities();
            System.out.println(record.getReferenceName());
        }
        System.out.println("Read " + n2 + " records in " + (System.currentTimeMillis() - t0) + " ms");
    }

    public static void readIndex(File f2) {
        FeatureIndex idx = new FeatureIndex(f2);
        System.out.println(idx.getTileDef("chr21", 0).getStartPosition());
    }

    private static void testQueryBam() throws FileNotFoundException, IOException {
        String path = "http://www.broadinstitute.org/igvdata/1KG/DCC_merged/freeze5/NA12878.pilot2.SLX.bam";
        String chr = "1";
        int start = 50542554;
        int end = 50542722;
        AlignmentQueryReader reader = SamQueryReaderFactory.getReader(new ResourceLocator(path));
        CloseableIterator<Alignment> iter = reader.query("chr1", 50542554, 50542722, true);
        while (iter.hasNext()) {
            Alignment record = (Alignment)iter.next();
            System.out.println(record.getAlignmentStart() + " => " + record.getAlignmentEnd());
        }
    }

    private static void jumpToChromosome(File f2, String chr, int tile) throws FileNotFoundException, IOException {
        File idxFile = new File(f2.getAbsolutePath() + ".index");
        FeatureIndex featureIndex = null;
        if (!idxFile.exists()) {
            System.out.println("IDX file does not exist");
            return;
        }
        featureIndex = new FeatureIndex(idxFile);
        FeatureIndex.TileDef seekPos = featureIndex.getTileDef(chr, tile);
        FileInputStream is = new FileInputStream(f2);
        is.getChannel().position(seekPos.getStartPosition());
        SAMFileReader reader = new SAMFileReader(is);
        SAMRecordIterator iter = reader.iterator();
        try {
            long t0 = System.currentTimeMillis();
            while (iter.hasNext()) {
                SAMRecord record = (SAMRecord)iter.next();
                System.out.println(record.getAlignmentStart());
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        is.close();
    }

    private static void testReadSpeed(File f2) throws FileNotFoundException, IOException {
        BufferedReader br = new BufferedReader(new FileReader(f2), 512000);
        long t0 = System.currentTimeMillis();
        while (br.readLine() != null) {
        }
        long dt = System.currentTimeMillis() - t0;
        System.out.println("BR = " + dt);
        br.close();
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(f2)));
        t0 = System.currentTimeMillis();
        while (dis.readLine() != null) {
        }
        dt = System.currentTimeMillis() - t0;
        System.out.println("DIS = " + dt);
        dis.close();
        FileInputStream is = new FileInputStream(f2);
        BufferedInputStream bis = new BufferedInputStream(is);
        t0 = System.currentTimeMillis();
        AsciiLineReader utils = new AsciiLineReader(bis);
        String nextLine = "";
        while ((nextLine = utils.readLine()) != null) {
        }
        dt = System.currentTimeMillis() - t0;
        System.out.println("AsciiLineReader = " + dt);
        ((InputStream)bis).close();
    }
}

