/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.expression;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.BEDFileParser;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.feature.ProbeToLocusMap;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.tribble.Feature;
import org.broad.tribble.readers.AsciiLineReader;

public class GeneToLocusHelper {
    static String LOCUS_START_DELIMITER = "|@";
    static String LOCUS_END_DELIMITER = "|";
    Map<String, IGVFeature> probeLocusMap;

    public GeneToLocusHelper(String probeResource, Genome genome) throws IOException {
        if (probeResource != null && probeResource.trim().length() > 0) {
            BEDFileParser parser = new BEDFileParser(genome);
            ResourceLocator rl = new ResourceLocator(probeResource);
            AsciiLineReader reader = ParsingUtils.openAsciiReader(rl);
            List<Feature> features = parser.loadFeatures(reader);
            reader.close();
            this.probeLocusMap = new HashMap<String, IGVFeature>(features.size() * 2);
            for (Feature f2 : features) {
                this.probeLocusMap.put(((IGVFeature)f2).getName(), (IGVFeature)f2);
            }
        }
    }

    public List<Locus> getLoci(String probeId, String description) {
        String[] locusStrings;
        if (description != null && description.length() > 3 && (locusStrings = this.getExplicitLocusStrings(description)) != null) {
            ArrayList<Locus> loci = new ArrayList<Locus>(locusStrings.length);
            for (String ls : locusStrings) {
                Locus locus = this.getLocus(ls = ls.trim());
                if (locus == null || !locus.isValid()) continue;
                loci.add(locus);
            }
            return loci;
        }
        Locus locus = this.getLocus(probeId);
        if (locus != null && locus.isValid()) {
            return Arrays.asList(locus);
        }
        String[] genes = ProbeToLocusMap.getInstance().getLociForProbe(probeId);
        if (genes != null) {
            ArrayList<Locus> loci = new ArrayList<Locus>(genes.length);
            for (String g2 : genes) {
                locus = this.getLocus(g2);
                if (locus == null) continue;
                loci.add(locus);
            }
            return loci;
        }
        return null;
    }

    private String[] getExplicitLocusStrings(String description) {
        int startIndex = description.indexOf(LOCUS_START_DELIMITER);
        if (startIndex < 0) {
            return null;
        }
        int endIndex = description.indexOf(LOCUS_END_DELIMITER, (startIndex += 2) + 1);
        if (endIndex < 0) {
            endIndex = description.length();
        }
        if (endIndex > startIndex + 3) {
            String locusString = description.substring(startIndex, endIndex);
            if (locusString.contains(",")) {
                return locusString.split(",");
            }
            return new String[]{locusString};
        }
        return null;
    }

    Locus getLocus(String geneOrLocusString) {
        Locus locus = new Locus(geneOrLocusString);
        if (locus.isValid()) {
            return locus;
        }
        if (this.probeLocusMap != null) {
            Feature f2 = this.probeLocusMap.get(geneOrLocusString);
            if (f2 == null) {
                return null;
            }
            return new Locus(f2.getChr(), f2.getStart(), f2.getEnd());
        }
        NamedFeature gene = FeatureDB.getFeature(geneOrLocusString);
        if (gene != null) {
            return new Locus(gene.getChr(), gene.getStart(), gene.getEnd());
        }
        return null;
    }
}

