/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.random;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Collection;
import org.apache.commons.math.random.JDKRandomGenerator;
import org.apache.commons.math.random.RandomData;
import org.apache.commons.math.random.RandomGenerator;

public class RandomDataImpl
implements RandomData,
Serializable {
    private static final long serialVersionUID = -626730818244969716L;
    private RandomGenerator rand = null;
    private SecureRandom secRand = null;

    public RandomDataImpl() {
    }

    public RandomDataImpl(RandomGenerator rand) {
        this.rand = rand;
    }

    public String nextHexString(int len) {
        if (len <= 0) {
            throw new IllegalArgumentException("length must be positive");
        }
        RandomGenerator ran = this.getRan();
        StringBuffer outBuffer = new StringBuffer();
        byte[] randomBytes = new byte[len / 2 + 1];
        ran.nextBytes(randomBytes);
        int i2 = 0;
        while (i2 < randomBytes.length) {
            Integer c2 = new Integer(randomBytes[i2]);
            String hex = Integer.toHexString(c2 + 128);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            outBuffer.append(hex);
            ++i2;
        }
        return outBuffer.toString().substring(0, len);
    }

    public int nextInt(int lower, int upper) {
        if (lower >= upper) {
            throw new IllegalArgumentException("upper bound must be > lower bound");
        }
        RandomGenerator rand = this.getRan();
        return lower + (int)(rand.nextDouble() * (double)(upper - lower + 1));
    }

    public long nextLong(long lower, long upper) {
        if (lower >= upper) {
            throw new IllegalArgumentException("upper bound must be > lower bound");
        }
        RandomGenerator rand = this.getRan();
        return lower + (long)(rand.nextDouble() * (double)(upper - lower + 1L));
    }

    public String nextSecureHexString(int len) {
        if (len <= 0) {
            throw new IllegalArgumentException("length must be positive");
        }
        SecureRandom secRan = this.getSecRan();
        MessageDigest alg = null;
        try {
            alg = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
        alg.reset();
        int numIter = len / 40 + 1;
        StringBuffer outBuffer = new StringBuffer();
        int iter = 1;
        while (iter < numIter + 1) {
            byte[] randomBytes = new byte[40];
            secRan.nextBytes(randomBytes);
            alg.update(randomBytes);
            byte[] hash = alg.digest();
            int i2 = 0;
            while (i2 < hash.length) {
                Integer c2 = new Integer(hash[i2]);
                String hex = Integer.toHexString(c2 + 128);
                if (hex.length() == 1) {
                    hex = "0" + hex;
                }
                outBuffer.append(hex);
                ++i2;
            }
            ++iter;
        }
        return outBuffer.toString().substring(0, len);
    }

    public int nextSecureInt(int lower, int upper) {
        if (lower >= upper) {
            throw new IllegalArgumentException("lower bound must be < upper bound");
        }
        SecureRandom sec = this.getSecRan();
        return lower + (int)(sec.nextDouble() * (double)(upper - lower + 1));
    }

    public long nextSecureLong(long lower, long upper) {
        if (lower >= upper) {
            throw new IllegalArgumentException("lower bound must be < upper bound");
        }
        SecureRandom sec = this.getSecRan();
        return lower + (long)(sec.nextDouble() * (double)(upper - lower + 1L));
    }

    public long nextPoisson(double mean) {
        if (mean <= 0.0) {
            throw new IllegalArgumentException("Poisson mean must be > 0");
        }
        double p2 = Math.exp(-mean);
        long n2 = 0L;
        double r = 1.0;
        double rnd = 1.0;
        RandomGenerator rand = this.getRan();
        while ((double)n2 < 1000.0 * mean) {
            rnd = rand.nextDouble();
            if ((r *= rnd) >= p2) {
                ++n2;
                continue;
            }
            return n2;
        }
        return n2;
    }

    public double nextGaussian(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("Gaussian std dev must be > 0");
        }
        RandomGenerator rand = this.getRan();
        return sigma * rand.nextGaussian() + mu;
    }

    public double nextExponential(double mean) {
        if (mean < 0.0) {
            throw new IllegalArgumentException("Exponential mean must be >= 0");
        }
        RandomGenerator rand = this.getRan();
        double unif = rand.nextDouble();
        while (unif == 0.0) {
            unif = rand.nextDouble();
        }
        return -mean * Math.log(unif);
    }

    public double nextUniform(double lower, double upper) {
        if (lower >= upper) {
            throw new IllegalArgumentException("lower bound must be <= upper bound");
        }
        RandomGenerator rand = this.getRan();
        double u = rand.nextDouble();
        while (u <= 0.0) {
            u = rand.nextDouble();
        }
        return lower + u * (upper - lower);
    }

    private RandomGenerator getRan() {
        if (this.rand == null) {
            this.rand = new JDKRandomGenerator();
            this.rand.setSeed(System.currentTimeMillis());
        }
        return this.rand;
    }

    private SecureRandom getSecRan() {
        if (this.secRand == null) {
            this.secRand = new SecureRandom();
            this.secRand.setSeed(System.currentTimeMillis());
        }
        return this.secRand;
    }

    public void reSeed(long seed) {
        if (this.rand == null) {
            this.rand = new JDKRandomGenerator();
        }
        this.rand.setSeed(seed);
    }

    public void reSeedSecure() {
        if (this.secRand == null) {
            this.secRand = new SecureRandom();
        }
        this.secRand.setSeed(System.currentTimeMillis());
    }

    public void reSeedSecure(long seed) {
        if (this.secRand == null) {
            this.secRand = new SecureRandom();
        }
        this.secRand.setSeed(seed);
    }

    public void reSeed() {
        if (this.rand == null) {
            this.rand = new JDKRandomGenerator();
        }
        this.rand.setSeed(System.currentTimeMillis());
    }

    public void setSecureAlgorithm(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.secRand = SecureRandom.getInstance(algorithm, provider);
    }

    public int[] nextPermutation(int n2, int k2) {
        if (k2 > n2) {
            throw new IllegalArgumentException("permutation k exceeds n");
        }
        if (k2 == 0) {
            throw new IllegalArgumentException("permutation k must be > 0");
        }
        int[] index = this.getNatural(n2);
        this.shuffle(index, n2 - k2);
        int[] result = new int[k2];
        int i2 = 0;
        while (i2 < k2) {
            result[i2] = index[n2 - i2 - 1];
            ++i2;
        }
        return result;
    }

    public Object[] nextSample(Collection c2, int k2) {
        int len = c2.size();
        if (k2 > len) {
            throw new IllegalArgumentException("sample size exceeds collection size");
        }
        if (k2 == 0) {
            throw new IllegalArgumentException("sample size must be > 0");
        }
        Object[] objects = c2.toArray();
        int[] index = this.nextPermutation(len, k2);
        Object[] result = new Object[k2];
        int i2 = 0;
        while (i2 < k2) {
            result[i2] = objects[index[i2]];
            ++i2;
        }
        return result;
    }

    private void shuffle(int[] list, int end) {
        int target = 0;
        int i2 = list.length - 1;
        while (i2 >= end) {
            target = i2 == 0 ? 0 : this.nextInt(0, i2);
            int temp = list[target];
            list[target] = list[i2];
            list[i2] = temp;
            --i2;
        }
    }

    private int[] getNatural(int n2) {
        int[] natural = new int[n2];
        int i2 = 0;
        while (i2 < n2) {
            natural[i2] = i2;
            ++i2;
        }
        return natural;
    }
}

