/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class IntBigArrays {
    public static final long ONEOVERPHI = 106039L;
    public static final int[][] EMPTY_BIG_ARRAY = new int[0][];
    public static final Hash.Strategy HASH_STRATEGY = new BigArrayHashStrategy();
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;

    private IntBigArrays() {
    }

    public static int get(int[][] array, long index) {
        return array[BigArrays.segment(index)][BigArrays.displacement(index)];
    }

    public static void set(int[][] array, long index, int value) {
        array[BigArrays.segment((long)index)][BigArrays.displacement((long)index)] = value;
    }

    public static void swap(int[][] array, long first, long second) {
        int t = array[BigArrays.segment(first)][BigArrays.displacement(first)];
        array[BigArrays.segment((long)first)][BigArrays.displacement((long)first)] = array[BigArrays.segment(second)][BigArrays.displacement(second)];
        array[BigArrays.segment((long)second)][BigArrays.displacement((long)second)] = t;
    }

    public static void add(int[][] array, long index, int incr) {
        int[] nArray = array[BigArrays.segment(index)];
        int n2 = BigArrays.displacement(index);
        nArray[n2] = nArray[n2] + incr;
    }

    public static void mul(int[][] array, long index, int factor) {
        int[] nArray = array[BigArrays.segment(index)];
        int n2 = BigArrays.displacement(index);
        nArray[n2] = nArray[n2] * factor;
    }

    public static void incr(int[][] array, long index) {
        int[] nArray = array[BigArrays.segment(index)];
        int n2 = BigArrays.displacement(index);
        nArray[n2] = nArray[n2] + 1;
    }

    public static void decr(int[][] array, long index) {
        int[] nArray = array[BigArrays.segment(index)];
        int n2 = BigArrays.displacement(index);
        nArray[n2] = nArray[n2] - 1;
    }

    public static long length(int[][] array) {
        int length = array.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array[length - 1].length;
    }

    public static void copy(int[][] srcArray, long srcPos, int[][] destArray, long destPos, long length) {
        if (destPos <= srcPos) {
            int srcSegment = BigArrays.segment(srcPos);
            int destSegment = BigArrays.segment(destPos);
            int srcDispl = BigArrays.displacement(srcPos);
            int destDispl = BigArrays.displacement(destPos);
            while (length > 0L) {
                int l2 = (int)Math.min(length, (long)Math.min(srcArray[srcSegment].length - srcDispl, destArray[destSegment].length - destDispl));
                System.arraycopy(srcArray[srcSegment], srcDispl, destArray[destSegment], destDispl, l2);
                if ((srcDispl += l2) == 0x8000000) {
                    srcDispl = 0;
                    ++srcSegment;
                }
                if ((destDispl += l2) == 0x8000000) {
                    destDispl = 0;
                    ++destSegment;
                }
                length -= (long)l2;
            }
        } else {
            int srcSegment = BigArrays.segment(srcPos + length);
            int destSegment = BigArrays.segment(destPos + length);
            int srcDispl = BigArrays.displacement(srcPos + length);
            int destDispl = BigArrays.displacement(destPos + length);
            while (length > 0L) {
                if (srcDispl == 0) {
                    srcDispl = 0x8000000;
                    --srcSegment;
                }
                if (destDispl == 0) {
                    destDispl = 0x8000000;
                    --destSegment;
                }
                int l3 = (int)Math.min(length, (long)Math.min(srcDispl, destDispl));
                System.arraycopy(srcArray[srcSegment], srcDispl - l3, destArray[destSegment], destDispl - l3, l3);
                srcDispl -= l3;
                destDispl -= l3;
                length -= (long)l3;
            }
        }
    }

    public static void copyFromBig(int[][] srcArray, long srcPos, int[] destArray, int destPos, int length) {
        int srcSegment = BigArrays.segment(srcPos);
        int srcDispl = BigArrays.displacement(srcPos);
        while (length > 0) {
            int l2 = Math.min(srcArray[srcSegment].length - srcDispl, length);
            System.arraycopy(srcArray[srcSegment], srcDispl, destArray, destPos, l2);
            if ((srcDispl += l2) == 0x8000000) {
                srcDispl = 0;
                ++srcSegment;
            }
            destPos += l2;
            length -= l2;
        }
    }

    public static void copyToBig(int[] srcArray, int srcPos, int[][] destArray, long destPos, long length) {
        int destSegment = BigArrays.segment(destPos);
        int destDispl = BigArrays.displacement(destPos);
        while (length > 0L) {
            int l2 = (int)Math.min((long)(destArray[destSegment].length - destDispl), length);
            System.arraycopy(srcArray, srcPos, destArray[destSegment], destDispl, l2);
            if ((destDispl += l2) == 0x8000000) {
                destDispl = 0;
                ++destSegment;
            }
            srcPos += l2;
            length -= (long)l2;
        }
    }

    public static int[][] newBigArray(long length) {
        if (length == 0L) {
            return EMPTY_BIG_ARRAY;
        }
        int baseLength = (int)((length + 0x7FFFFFFL) / 0x8000000L);
        int[][] base = new int[baseLength][];
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i2 = 0; i2 < baseLength - 1; ++i2) {
                base[i2] = new int[0x8000000];
            }
            base[baseLength - 1] = new int[residual];
        } else {
            for (int i3 = 0; i3 < baseLength; ++i3) {
                base[i3] = new int[0x8000000];
            }
        }
        return base;
    }

    public static int[][] wrap(int[] array) {
        if (array.length == 0) {
            return EMPTY_BIG_ARRAY;
        }
        if (array.length <= 0x8000000) {
            return new int[][]{array};
        }
        int[][] bigArray = IntBigArrays.newBigArray(array.length);
        for (int i2 = 0; i2 < bigArray.length; ++i2) {
            System.arraycopy(array, (int)BigArrays.start(i2), bigArray[i2], 0, bigArray[i2].length);
        }
        return bigArray;
    }

    public static int[][] ensureCapacity(int[][] array, long length) {
        return IntBigArrays.ensureCapacity(array, length, IntBigArrays.length(array));
    }

    public static int[][] ensureCapacity(int[][] array, long length, long preserve) {
        long oldLength = IntBigArrays.length(array);
        if (length > oldLength) {
            int valid = array.length - (array.length == 0 || array.length > 0 && array[array.length - 1].length == 0x8000000 ? 0 : 1);
            int baseLength = (int)((length + 0x7FFFFFFL) / 0x8000000L);
            int[][] base = (int[][])Arrays.copyOf(array, baseLength);
            int residual = (int)(length & 0x7FFFFFFL);
            if (residual != 0) {
                for (int i2 = valid; i2 < baseLength - 1; ++i2) {
                    base[i2] = new int[0x8000000];
                }
                base[baseLength - 1] = new int[residual];
            } else {
                for (int i3 = valid; i3 < baseLength; ++i3) {
                    base[i3] = new int[0x8000000];
                }
            }
            if (preserve - (long)valid * 0x8000000L > 0L) {
                IntBigArrays.copy(array, (long)valid * 0x8000000L, base, (long)valid * 0x8000000L, preserve - (long)valid * 0x8000000L);
            }
            return base;
        }
        return array;
    }

    public static int[][] grow(int[][] array, long length) {
        long oldLength = IntBigArrays.length(array);
        return length > oldLength ? IntBigArrays.grow(array, length, oldLength) : array;
    }

    public static int[][] grow(int[][] array, long length, long preserve) {
        long oldLength = IntBigArrays.length(array);
        return length > oldLength ? IntBigArrays.ensureCapacity(array, Math.max(106039L * oldLength >>> 16, length), preserve) : array;
    }

    public static int[][] trim(int[][] array, long length) {
        long oldLength = IntBigArrays.length(array);
        if (length >= oldLength) {
            return array;
        }
        int baseLength = (int)((length + 0x7FFFFFFL) / 0x8000000L);
        int[][] base = (int[][])Arrays.copyOf(array, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = IntArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    public static int[][] setLength(int[][] array, long length) {
        long oldLength = IntBigArrays.length(array);
        if (length == oldLength) {
            return array;
        }
        if (length < oldLength) {
            return IntBigArrays.trim(array, length);
        }
        return IntBigArrays.ensureCapacity(array, length);
    }

    public static int[][] copy(int[][] array, long offset, long length) {
        IntBigArrays.ensureOffsetLength(array, offset, length);
        int[][] a2 = IntBigArrays.newBigArray(length);
        IntBigArrays.copy(array, offset, a2, 0L, length);
        return a2;
    }

    public static int[][] copy(int[][] array) {
        int[][] base = (int[][])array.clone();
        int i2 = base.length;
        while (i2-- != 0) {
            base[i2] = (int[])array[i2].clone();
        }
        return base;
    }

    public static void fill(int[][] array, int value) {
        int i2 = array.length;
        while (i2-- != 0) {
            IntArrays.fill(array[i2], value);
        }
    }

    public static void fill(int[][] array, long from, long to, int value) {
        long length = IntBigArrays.length(array);
        BigArrays.ensureFromTo(length, from, to);
        int fromSegment = BigArrays.segment(from);
        int toSegment = BigArrays.segment(to);
        int fromDispl = BigArrays.displacement(from);
        int toDispl = BigArrays.displacement(to);
        if (fromSegment == toSegment) {
            IntArrays.fill(array[fromSegment], fromDispl, toDispl, value);
            return;
        }
        if (toDispl != 0) {
            IntArrays.fill(array[toSegment], 0, toDispl, value);
        }
        while (--toSegment > fromSegment) {
            IntArrays.fill(array[toSegment], value);
        }
        IntArrays.fill(array[fromSegment], fromDispl, 0x8000000, value);
    }

    public static boolean equals(int[][] a1, int[][] a2) {
        if (IntBigArrays.length(a1) != IntBigArrays.length(a2)) {
            return false;
        }
        int i2 = a1.length;
        while (i2-- != 0) {
            int[] t = a1[i2];
            int[] u = a2[i2];
            int j2 = t.length;
            while (j2-- != 0) {
                if (t[j2] == u[j2]) continue;
                return false;
            }
        }
        return true;
    }

    public static String toString(int[][] a2) {
        if (a2 == null) {
            return "null";
        }
        long last = IntBigArrays.length(a2) - 1L;
        if (last == -1L) {
            return "[]";
        }
        StringBuilder b2 = new StringBuilder();
        b2.append('[');
        long i2 = 0L;
        while (true) {
            b2.append(String.valueOf(IntBigArrays.get(a2, i2)));
            if (i2 == last) {
                return b2.append(']').toString();
            }
            b2.append(", ");
            ++i2;
        }
    }

    public static void ensureFromTo(int[][] a2, long from, long to) {
        BigArrays.ensureFromTo(IntBigArrays.length(a2), from, to);
    }

    public static void ensureOffsetLength(int[][] a2, long offset, long length) {
        BigArrays.ensureOffsetLength(IntBigArrays.length(a2), offset, length);
    }

    private static void vecSwap(int[][] x, long a2, long b2, long n2) {
        int i2 = 0;
        while ((long)i2 < n2) {
            IntBigArrays.swap(x, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static long med3(int[][] x, long a2, long b2, long c2, IntComparator comp) {
        int ab = comp.compare(IntBigArrays.get(x, a2), IntBigArrays.get(x, b2));
        int ac = comp.compare(IntBigArrays.get(x, a2), IntBigArrays.get(x, c2));
        int bc = comp.compare(IntBigArrays.get(x, b2), IntBigArrays.get(x, c2));
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    public static void quickSort(int[][] x, long from, long to, IntComparator comp) {
        long c2;
        long a2;
        long len = to - from;
        if (len < 7L) {
            for (long i2 = from; i2 < to; ++i2) {
                for (long j2 = i2; j2 > from && comp.compare(IntBigArrays.get(x, j2 - 1L), IntBigArrays.get(x, j2)) > 0; --j2) {
                    IntBigArrays.swap(x, j2, j2 - 1L);
                }
            }
            return;
        }
        long m2 = from + len / 2L;
        if (len > 7L) {
            long l2 = from;
            long n2 = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l2 = IntBigArrays.med3(x, l2, l2 + s, l2 + 2L * s, comp);
                m2 = IntBigArrays.med3(x, m2 - s, m2, m2 + s, comp);
                n2 = IntBigArrays.med3(x, n2 - 2L * s, n2 - s, n2, comp);
            }
            m2 = IntBigArrays.med3(x, l2, m2, n2, comp);
        }
        int v = IntBigArrays.get(x, m2);
        long b2 = a2 = from;
        long d2 = c2 = to - 1L;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = comp.compare(IntBigArrays.get(x, b2), v)) <= 0) {
                if (comparison == 0) {
                    IntBigArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = comp.compare(IntBigArrays.get(x, c2), v)) >= 0) {
                if (comparison == 0) {
                    IntBigArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            IntBigArrays.swap(x, b2++, c2--);
        }
        long n3 = to;
        long s = Math.min(a2 - from, b2 - a2);
        IntBigArrays.vecSwap(x, from, b2 - s, s);
        s = Math.min(d2 - c2, n3 - d2 - 1L);
        IntBigArrays.vecSwap(x, b2, n3 - s, s);
        s = b2 - a2;
        if (s > 1L) {
            IntBigArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d2 - c2) > 1L) {
            IntBigArrays.quickSort(x, n3 - s, n3, comp);
        }
    }

    private static long med3(int[][] x, long a2, long b2, long c2) {
        int bc;
        int ac;
        int ab;
        int n2 = IntBigArrays.get(x, a2) < IntBigArrays.get(x, b2) ? -1 : (ab = IntBigArrays.get(x, a2) == IntBigArrays.get(x, b2) ? 0 : 1);
        int n3 = IntBigArrays.get(x, a2) < IntBigArrays.get(x, c2) ? -1 : (ac = IntBigArrays.get(x, a2) == IntBigArrays.get(x, c2) ? 0 : 1);
        int n4 = IntBigArrays.get(x, b2) < IntBigArrays.get(x, c2) ? -1 : (bc = IntBigArrays.get(x, b2) == IntBigArrays.get(x, c2) ? 0 : 1);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    public static void quickSort(int[][] x, IntComparator comp) {
        IntBigArrays.quickSort(x, 0L, IntBigArrays.length(x), comp);
    }

    public static void quickSort(int[][] x, long from, long to) {
        long c2;
        long a2;
        long len = to - from;
        if (len < 7L) {
            for (long i2 = from; i2 < to; ++i2) {
                for (long j2 = i2; j2 > from && (IntBigArrays.get(x, j2 - 1L) < IntBigArrays.get(x, j2) ? -1 : (IntBigArrays.get(x, j2 - 1L) == IntBigArrays.get(x, j2) ? 0 : 1)) > 0; --j2) {
                    IntBigArrays.swap(x, j2, j2 - 1L);
                }
            }
            return;
        }
        long m2 = from + len / 2L;
        if (len > 7L) {
            long l2 = from;
            long n2 = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l2 = IntBigArrays.med3(x, l2, l2 + s, l2 + 2L * s);
                m2 = IntBigArrays.med3(x, m2 - s, m2, m2 + s);
                n2 = IntBigArrays.med3(x, n2 - 2L * s, n2 - s, n2);
            }
            m2 = IntBigArrays.med3(x, l2, m2, n2);
        }
        int v = IntBigArrays.get(x, m2);
        long b2 = a2 = from;
        long d2 = c2 = to - 1L;
        while (true) {
            int comparison;
            if (b2 <= c2 && (IntBigArrays.get(x, b2) < v ? -1 : (comparison = IntBigArrays.get(x, b2) == v ? 0 : 1)) <= 0) {
                if (comparison == 0) {
                    IntBigArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (IntBigArrays.get(x, c2) < v ? -1 : (comparison = IntBigArrays.get(x, c2) == v ? 0 : 1)) >= 0) {
                if (comparison == 0) {
                    IntBigArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            IntBigArrays.swap(x, b2++, c2--);
        }
        long n3 = to;
        long s = Math.min(a2 - from, b2 - a2);
        IntBigArrays.vecSwap(x, from, b2 - s, s);
        s = Math.min(d2 - c2, n3 - d2 - 1L);
        IntBigArrays.vecSwap(x, b2, n3 - s, s);
        s = b2 - a2;
        if (s > 1L) {
            IntBigArrays.quickSort(x, from, from + s);
        }
        if ((s = d2 - c2) > 1L) {
            IntBigArrays.quickSort(x, n3 - s, n3);
        }
    }

    public static void quickSort(int[][] x) {
        IntBigArrays.quickSort(x, 0L, IntBigArrays.length(x));
    }

    public static long binarySearch(int[][] a2, long from, long to, int key) {
        while (from <= to) {
            long mid = from + to >>> 1;
            int midVal = IntBigArrays.get(a2, mid);
            if (midVal < key) {
                from = mid + 1L;
                continue;
            }
            if (midVal > key) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from + 1L);
    }

    public static long binarySearch(int[][] a2, int key) {
        return IntBigArrays.binarySearch(a2, 0L, IntBigArrays.length(a2), key);
    }

    public static long binarySearch(int[][] a2, long from, long to, int key, IntComparator c2) {
        while (from <= to) {
            long mid = from + to >>> 1;
            int midVal = IntBigArrays.get(a2, mid);
            int cmp = c2.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from + 1L);
    }

    public static long binarySearch(int[][] a2, int key, IntComparator c2) {
        return IntBigArrays.binarySearch(a2, 0L, IntBigArrays.length(a2), key, c2);
    }

    public static int[][] shuffle(int[][] a2, long from, long to, Random random) {
        long i2 = to - from;
        while (i2-- != 0L) {
            long p2 = (random.nextLong() & Long.MAX_VALUE) % (i2 + 1L);
            int t = IntBigArrays.get(a2, from + i2);
            IntBigArrays.set(a2, from + i2, IntBigArrays.get(a2, from + p2));
            IntBigArrays.set(a2, from + p2, t);
        }
        return a2;
    }

    public static int[][] shuffle(int[][] a2, Random random) {
        long i2 = IntBigArrays.length(a2);
        while (i2-- != 0L) {
            long p2 = (random.nextLong() & Long.MAX_VALUE) % (i2 + 1L);
            int t = IntBigArrays.get(a2, i2);
            IntBigArrays.set(a2, i2, IntBigArrays.get(a2, p2));
            IntBigArrays.set(a2, p2, t);
        }
        return a2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BigArrayHashStrategy
    implements Hash.Strategy<int[][]>,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        private BigArrayHashStrategy() {
        }

        @Override
        public int hashCode(int[][] o2) {
            return Arrays.deepHashCode((Object[])o2);
        }

        @Override
        public boolean equals(int[][] a2, int[][] b2) {
            return IntBigArrays.equals(a2, b2);
        }
    }
}

