/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil;

import it.unimi.dsi.fastutil.Swapper;
import it.unimi.dsi.fastutil.ints.IntComparator;

public class Arrays {
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;

    private Arrays() {
    }

    public static void ensureFromTo(int arrayLength, int from, int to) {
        if (from < 0) {
            throw new ArrayIndexOutOfBoundsException("Start index (" + from + ") is negative");
        }
        if (from > to) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        if (to > arrayLength) {
            throw new ArrayIndexOutOfBoundsException("End index (" + to + ") is greater than array length (" + arrayLength + ")");
        }
    }

    public static void ensureOffsetLength(int arrayLength, int offset, int length) {
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length (" + length + ") is negative");
        }
        if (offset + length > arrayLength) {
            throw new ArrayIndexOutOfBoundsException("Last index (" + (offset + length) + ") is greater than array length (" + arrayLength + ")");
        }
    }

    private static void inPlaceMerge(int from, int mid, int to, IntComparator comp, Swapper swapper) {
        int secondCut;
        int firstCut;
        if (from >= mid || mid >= to) {
            return;
        }
        if (to - from == 2) {
            if (comp.compare(mid, from) < 0) {
                swapper.swap(from, mid);
            }
            return;
        }
        if (mid - from > to - mid) {
            firstCut = from + (mid - from) / 2;
            secondCut = Arrays.lowerBound(mid, to, firstCut, comp);
        } else {
            secondCut = mid + (to - mid) / 2;
            firstCut = Arrays.upperBound(from, mid, secondCut, comp);
        }
        int first2 = firstCut;
        int middle2 = mid;
        int last2 = secondCut;
        if (middle2 != first2 && middle2 != last2) {
            int first1 = first2;
            int last1 = middle2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
            first1 = middle2;
            last1 = last2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
            first1 = first2;
            last1 = last2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
        }
        mid = firstCut + (secondCut - mid);
        Arrays.inPlaceMerge(from, firstCut, mid, comp, swapper);
        Arrays.inPlaceMerge(mid, secondCut, to, comp, swapper);
    }

    private static int lowerBound(int from, int to, int pos, IntComparator comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(middle, pos) < 0) {
                from = middle + 1;
                len -= half + 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    private static int upperBound(int from, int mid, int pos, IntComparator comp) {
        int len = mid - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(pos, middle) < 0) {
                len = half;
                continue;
            }
            from = middle + 1;
            len -= half + 1;
        }
        return from;
    }

    private static int med3(int a2, int b2, int c2, IntComparator comp) {
        int ab = comp.compare(a2, b2);
        int ac = comp.compare(a2, c2);
        int bc = comp.compare(b2, c2);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    public static void mergeSort(int from, int to, IntComparator c2, Swapper swapper) {
        int length = to - from;
        if (length < 7) {
            for (int i2 = from; i2 < to; ++i2) {
                for (int j2 = i2; j2 > from && c2.compare(j2 - 1, j2) > 0; --j2) {
                    swapper.swap(j2, j2 - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        Arrays.mergeSort(from, mid, c2, swapper);
        Arrays.mergeSort(mid, to, c2, swapper);
        if (c2.compare(mid - 1, mid) <= 0) {
            return;
        }
        Arrays.inPlaceMerge(from, mid, to, c2, swapper);
    }

    public static void quickSort(int from, int to, IntComparator comp, Swapper swapper) {
        int c2;
        int a2;
        int len = to - from;
        if (len < 7) {
            for (int i2 = from; i2 < to; ++i2) {
                for (int j2 = i2; j2 > from && comp.compare(j2 - 1, j2) > 0; --j2) {
                    swapper.swap(j2, j2 - 1);
                }
            }
            return;
        }
        int m2 = from + len / 2;
        if (len > 7) {
            int l2 = from;
            int n2 = to - 1;
            if (len > 40) {
                int s = len / 8;
                l2 = Arrays.med3(l2, l2 + s, l2 + 2 * s, comp);
                m2 = Arrays.med3(m2 - s, m2, m2 + s, comp);
                n2 = Arrays.med3(n2 - 2 * s, n2 - s, n2, comp);
            }
            m2 = Arrays.med3(l2, m2, n2, comp);
        }
        int b2 = a2 = from;
        int d2 = c2 = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = comp.compare(b2, m2)) <= 0) {
                if (comparison == 0) {
                    if (a2 == m2) {
                        m2 = b2;
                    } else if (b2 == m2) {
                        m2 = a2;
                    }
                    swapper.swap(a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = comp.compare(c2, m2)) >= 0) {
                if (comparison == 0) {
                    if (c2 == m2) {
                        m2 = d2;
                    } else if (d2 == m2) {
                        m2 = c2;
                    }
                    swapper.swap(c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            if (b2 == m2) {
                m2 = d2;
            } else if (c2 == m2) {
                m2 = c2;
            }
            swapper.swap(b2++, c2--);
        }
        int n3 = to;
        int s = Math.min(a2 - from, b2 - a2);
        Arrays.vecSwap(swapper, from, b2 - s, s);
        s = Math.min(d2 - c2, n3 - d2 - 1);
        Arrays.vecSwap(swapper, b2, n3 - s, s);
        s = b2 - a2;
        if (s > 1) {
            Arrays.quickSort(from, from + s, comp, swapper);
        }
        if ((s = d2 - c2) > 1) {
            Arrays.quickSort(n3 - s, n3, comp, swapper);
        }
    }

    private static void vecSwap(Swapper swapper, int from, int l2, int s) {
        int i2 = 0;
        while (i2 < s) {
            swapper.swap(from, l2);
            ++i2;
            ++from;
            ++l2;
        }
    }
}

