/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.ObjectConverterManager;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArrayConverter
implements ObjectConverter {
    private String _separator;
    private int _size;
    private Class<?> _elementClass;
    private Class<?>[] _elementClasses;

    public ArrayConverter(String string, int n2, Class<?> clazz) {
        this._separator = string;
        this._size = n2;
        this._elementClass = clazz;
    }

    public ArrayConverter(String string, int n2, Class<?>[] classArray) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("separator cannot be empty.");
        }
        if (classArray == null) {
            throw new IllegalArgumentException("elementClasses cannot be null.");
        }
        if (n2 != classArray.length) {
            throw new IllegalArgumentException("size must be equal to the length of elementClasses.");
        }
        this._separator = string;
        this._size = n2;
        this._elementClasses = classArray;
    }

    public String arrayToString(Object[] objectArray, ConverterContext converterContext) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            stringBuffer.append(this.toString(i2, object, converterContext));
            if (i2 == objectArray.length - 1) continue;
            stringBuffer.append(this._separator);
        }
        return new String(stringBuffer);
    }

    protected String toString(int n2, Object object, ConverterContext converterContext) {
        return this._elementClass != null ? ObjectConverterManager.toString(object, this._elementClass, converterContext) : ObjectConverterManager.toString(object, this._elementClasses[n2], converterContext);
    }

    public Object[] arrayFromString(String string, ConverterContext converterContext) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, this._separator.trim());
        Object[] objectArray = new Object[this._size != -1 ? this._size : stringTokenizer.countTokens()];
        for (int i2 = 0; i2 < objectArray.length && stringTokenizer.hasMoreTokens(); ++i2) {
            String string2 = stringTokenizer.nextToken().trim();
            objectArray[i2] = this.fromString(i2, string2, converterContext);
        }
        return objectArray;
    }

    protected Object fromString(int n2, String string, ConverterContext converterContext) {
        return this._elementClass != null ? ObjectConverterManager.fromString(string, this._elementClass, converterContext) : ObjectConverterManager.fromString(string, this._elementClasses[n2], converterContext);
    }

    public Class<?> getElementClass() {
        return this._elementClass;
    }
}

