/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import org.apache.log4j.Logger;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.FontManager;

public class UIConstants {
    private static Logger log = Logger.getLogger(UIConstants.class);
    public static final int groupGap = 10;
    public static final String APPLICATION_NAME = "IGV";
    public static final String APPLICATION_LONG_NAME = "Integrative Genomics Viewer";
    public static final Dimension preferredSize = new Dimension(1000, 750);
    public static TrackType overlayTrackType = TrackType.MUTATION;
    private static int doubleClickInterval = -1;
    public static final String CLICK_ITEM_TO_EDIT_TOOLTIP = "Click this item bring up its editor";
    public static final String JUMP_TO_WHOLE_GENOME_VIEW_TOOLTIP = "Jump to whole genome view";
    public static final String JUMP_TO_LOCUS_TOOLTIP = "Jump to Gene or Locus";
    public static final String SELECT_CHROMOSOME_TOOLTIP = "Select a chromosome to view";
    public static final String ZOOM_TOOL_TOOLTIP = "Click + to zoom in - Click - to zoom out";
    public static final String LOAD_TRACKS_TOOLTIP = "Load data, features or sample information";
    public static final String LOAD_SERVER_DATA_TOOLTIP = "Load data, features or sample information from a server";
    public static final String LOAD_ATTRIBUTES_TOOLTIP = "Load track attributes";
    public static final String SAVE_IMAGE_TOOLTIP = "Capture and save an image";
    public static final String NEW_SESSION_TOOLTIP = "Create a new session";
    public static final String SAVE_SESSION_TOOLTIP = "Save the current session";
    public static final String SAVE_SESSION_AS_TOOLTIP = "Save the current session to the specified file";
    public static final String RESTORE_SESSION_TOOLTIP = "Reload the named session";
    public static final String EXIT_TOOLTIP = "Exit the application";
    public static final String EXPORT_REGION_TOOLTIP = "Allows currently selected regions to be exported to a file";
    public static final String IMPORT_REGION_TOOLTIP = "Allows previously exported regions to be reloaded";
    public static final String CLEAR_REGION_TOOLTIP = "Clear all regions of interest";
    public static final String CHANGE_GENOME_TOOLTIP = "Switch the current genome";
    public static final String IMPORT_GENOME_TOOLTIP = "Define a user-defined genome";
    public static final String LOAD_GENOME_TOOLTIP = "Load a previously created \".genome\" file";
    public static final String REMOVE_USER_DEFINE_GENOME_TOOLTIP = "Removes user-defined genomes from the drop-down list";
    public static final String CLEAR_GENOME_CACHE_TOOLTIP = "Clears locally cached versions of IGV hosted genomes";
    public static final String PREFERENCE_TOOLTIP = "Set user specific preferences";
    public static final String SHOW_ATTRIBUTE_DISPLAY_TOOLTIP = "Show or hide the attribute display";
    public static final String ENABLE_REGIONS_OF_INTEREST_TOOLTIP = "Enable the \"Region of Interest\" tool";
    public static final String REFRESH_TOOLTIP = "Refresh the application's display";
    public static final String SHOW_HEATMAP_LEGEND_TOOLTIP = "IGVPanel or edit color legends and scales";
    public static final String SELECT_DISPLAYABLE_ATTRIBUTES_TOOLTIP = "Customize attribute display to show only checked attributes";
    public static final String USE_IMAGE_CACHING_TOOLTIP = "Use image caching to improve display performance";
    public static final String DIRECT_DRAW_DISABLED_TOOLTIP = "Checked this item to prevent the use of direct draw when rendering images - Uncheck it to use the default system behavior";
    public static final String SORT_TRACKS_TOOLTIP = "Sort tracks by attribute value";
    public static final String GROUP_TRACKS_TOOLTIP = "Group tracks";
    public static final String FILTER_TRACKS_TOOLTIP = "Filter tracks by attribute value";
    public static final String RESET_DEFAULT_TRACK_HEIGHT_TOOLTIP = "Reset all track to the default track height";
    public static final String SET_DEFAULT_TRACK_HEIGHT_TOOLTIP = "Set the height for all tracks";
    public static final String FIT_DATA_TO_WINDOW_TOOLTIP = "Resizes all track heights in order to make all tracks visible in their display with no vertical scrolling";
    public static final String HELP_TOOLTIP = "Open web help page";
    public static final String TUTORIAL_TOOLTIP = "Open tutorial web page";
    public static final String ABOUT_TOOLTIP = "Display application information";
    public static final String MACRO_SNAPSHOTS = "Macro Snapshots";
    public static final String RESET_FACTORY_TOOLTIP = "Restores all user preferences to their default settings.";
    public static final String NAVIGATE_REGION_TOOLTIP = "Navigate regions";
    public static Font boldFont = FontManager.getFont(1, 12);
    public static final String OVERWRITE_SESSION_MESSAGE = "<html>Opening a session will unload all current data. <br>Are you sure you wish to continue?";
    public static final String NEW_SESSION_MESSAGE = "<html>Creating a new session will unload all current data. <br>Are you sure you wish to continue?";
    public static final String DEFAULT_SERVER_GENOME_ARCHIVE_LIST = "http://igv.broadinstitute.org/genomes/genomes.txt";
    public static final String CANNOT_ACCESS_SERVER_GENOME_LIST = "The Genome server is currently inaccessible.";
    public static final String INVALID_SERVER_GENOME_LIST_HEADER = "Genomes cannot be retrieved from the server. The server-side genome list is invalid!";
    public static final String SESSION_FOLDER = "/igv_sessions";
    public static final int NUMBER_OF_RECENT_SESSIONS_TO_LIST = 3;
    public static final String DEFAULT_SESSION_FILE = "igv_session.xml";
    public static final String SERVER_BASE_URL = "http://www.broadinstitute.org/";
    public static final String IGV_LOG_SERVER_URL = "http://www.broadinstitute.org/igv/LogServlet";
    public static final Color LIGHT_YELLOW = new Color(255, 244, 201);
    public static final Color ZOOMED_OUT_COLOR = new Color(238, 239, 240);
    public static final Color TRACK_BORDER_GRAY = new Color(200, 200, 210);
    public static Color NO_DATA_COLOR = new Color(200, 200, 200, 150);
    public static final String IMPORT_GENOME_LIST_MENU_ITEM = "Import Genome...";
    public static final String LOAD_GENOME_LIST_MENU_ITEM = "Load Genome...";
    public static final String REMOVE_GENOME_LIST_MENU_ITEM = "Remove Imported Genomes...";
    public static final String GENOME_LIST_SEPARATOR = "--SEPARATOR--";

    public static int getDoubleClickInterval() {
        if (doubleClickInterval < 0) {
            try {
                Number obj = (Number)Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
                doubleClickInterval = obj.intValue();
            }
            catch (Exception e2) {
                log.info("Error retrieving doubleClickInterval", e2);
                doubleClickInterval = 500;
            }
        }
        return doubleClickInterval;
    }
}

