/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.special;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.special.Gamma;
import org.apache.commons.math.util.ContinuedFraction;

public class Beta
implements Serializable {
    private static final double DEFAULT_EPSILON = 1.0E-8;

    private Beta() {
    }

    public static double regularizedBeta(double x, double a2, double b2) throws MathException {
        return Beta.regularizedBeta(x, a2, b2, 1.0E-8, Integer.MAX_VALUE);
    }

    public static double regularizedBeta(double x, double a2, double b2, double epsilon) throws MathException {
        return Beta.regularizedBeta(x, a2, b2, epsilon, Integer.MAX_VALUE);
    }

    public static double regularizedBeta(double x, double a2, double b2, int maxIterations) throws MathException {
        return Beta.regularizedBeta(x, a2, b2, 1.0E-8, maxIterations);
    }

    public static double regularizedBeta(double x, final double a2, final double b2, double epsilon, int maxIterations) throws MathException {
        double ret;
        if (Double.isNaN(x) || Double.isNaN(a2) || Double.isNaN(b2) || x < 0.0 || x > 1.0 || a2 <= 0.0 || b2 <= 0.0) {
            ret = Double.NaN;
        } else if (x > (a2 + 1.0) / (a2 + b2 + 2.0)) {
            ret = 1.0 - Beta.regularizedBeta(1.0 - x, b2, a2, epsilon, maxIterations);
        } else {
            ContinuedFraction fraction = new ContinuedFraction(){

                protected double getB(int n2, double x) {
                    double ret;
                    if (n2 % 2 == 0) {
                        double m2 = (double)n2 / 2.0;
                        ret = m2 * (b2 - m2) * x / ((a2 + 2.0 * m2 - 1.0) * (a2 + 2.0 * m2));
                    } else {
                        double m2 = ((double)n2 - 1.0) / 2.0;
                        ret = -((a2 + m2) * (a2 + b2 + m2) * x) / ((a2 + 2.0 * m2) * (a2 + 2.0 * m2 + 1.0));
                    }
                    return ret;
                }

                protected double getA(int n2, double x) {
                    return 1.0;
                }
            };
            ret = Math.exp(a2 * Math.log(x) + b2 * Math.log(1.0 - x) - Math.log(a2) - Beta.logBeta(a2, b2, epsilon, maxIterations)) * 1.0 / fraction.evaluate(x, epsilon, maxIterations);
        }
        return ret;
    }

    public static double logBeta(double a2, double b2) {
        return Beta.logBeta(a2, b2, 1.0E-8, Integer.MAX_VALUE);
    }

    public static double logBeta(double a2, double b2, double epsilon, int maxIterations) {
        double ret = Double.isNaN(a2) || Double.isNaN(b2) || a2 <= 0.0 || b2 <= 0.0 ? Double.NaN : Gamma.logGamma(a2) + Gamma.logGamma(b2) - Gamma.logGamma(a2 + b2);
        return ret;
    }
}

