/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.DifferentiableUnivariateRealFunction;
import org.apache.commons.math.analysis.PolynomialFunction;
import org.apache.commons.math.analysis.UnivariateRealFunction;

public class PolynomialSplineFunction
implements DifferentiableUnivariateRealFunction,
Serializable {
    private static final long serialVersionUID = 7011031166416885789L;
    private double[] knots;
    private PolynomialFunction[] polynomials = null;
    private int n = 0;

    public PolynomialSplineFunction(double[] knots, PolynomialFunction[] polynomials) {
        if (knots.length < 2) {
            throw new IllegalArgumentException("Not enough knot values -- spline partition must have at least 2 points.");
        }
        if (knots.length - 1 != polynomials.length) {
            throw new IllegalArgumentException("Number of polynomial interpolants must match the number of segments.");
        }
        if (!PolynomialSplineFunction.isStrictlyIncreasing(knots)) {
            throw new IllegalArgumentException("Knot values must be strictly increasing.");
        }
        this.n = knots.length - 1;
        this.knots = new double[this.n + 1];
        System.arraycopy(knots, 0, this.knots, 0, this.n + 1);
        this.polynomials = new PolynomialFunction[this.n];
        System.arraycopy(polynomials, 0, this.polynomials, 0, this.n);
    }

    public double value(double v) throws FunctionEvaluationException {
        if (v < this.knots[0] || v > this.knots[this.n]) {
            throw new FunctionEvaluationException(v, "Argument outside domain");
        }
        int i2 = Arrays.binarySearch(this.knots, v);
        if (i2 < 0) {
            i2 = -i2 - 2;
        }
        if (i2 >= this.polynomials.length) {
            --i2;
        }
        return this.polynomials[i2].value(v - this.knots[i2]);
    }

    public UnivariateRealFunction derivative() {
        return this.polynomialSplineDerivative();
    }

    public PolynomialSplineFunction polynomialSplineDerivative() {
        PolynomialFunction[] derivativePolynomials = new PolynomialFunction[this.n];
        int i2 = 0;
        while (i2 < this.n) {
            derivativePolynomials[i2] = this.polynomials[i2].polynomialDerivative();
            ++i2;
        }
        return new PolynomialSplineFunction(this.knots, derivativePolynomials);
    }

    public int getN() {
        return this.n;
    }

    public PolynomialFunction[] getPolynomials() {
        PolynomialFunction[] p2 = new PolynomialFunction[this.n];
        System.arraycopy(this.polynomials, 0, p2, 0, this.n);
        return p2;
    }

    public double[] getKnots() {
        double[] out = new double[this.n + 1];
        System.arraycopy(this.knots, 0, out, 0, this.n + 1);
        return out;
    }

    private static boolean isStrictlyIncreasing(double[] x) {
        int i2 = 1;
        while (i2 < x.length) {
            if (x[i2 - 1] >= x[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }
}

