/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.DifferentiableUnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealSolverImpl;
import org.apache.commons.math.analysis.UnivariateRealSolverUtils;

public class NewtonSolver
extends UnivariateRealSolverImpl {
    private static final long serialVersionUID = 2606474895443431607L;
    private transient UnivariateRealFunction derivative;

    public NewtonSolver(DifferentiableUnivariateRealFunction f2) {
        super(f2, 100, 1.0E-6);
        this.derivative = f2.derivative();
    }

    public double solve(double min, double max) throws ConvergenceException, FunctionEvaluationException {
        return this.solve(min, max, UnivariateRealSolverUtils.midpoint(min, max));
    }

    public double solve(double min, double max, double startValue) throws ConvergenceException, FunctionEvaluationException {
        this.clearResult();
        this.verifySequence(min, startValue, max);
        double x0 = startValue;
        int i2 = 0;
        while (i2 < this.maximalIterationCount) {
            double x1 = x0 - this.f.value(x0) / this.derivative.value(x0);
            if (Math.abs(x1 - x0) <= this.absoluteAccuracy) {
                this.setResult(x1, i2);
                return x1;
            }
            x0 = x1;
            ++i2;
        }
        throw new ConvergenceException("Maximum number of iterations exceeded " + i2);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.derivative = ((DifferentiableUnivariateRealFunction)this.f).derivative();
    }
}

