/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortComparator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class ShortBigArrays {
    public static final long ONEOVERPHI = 106039L;
    public static final short[][] EMPTY_BIG_ARRAY = new short[0][];
    public static final Hash.Strategy HASH_STRATEGY = new BigArrayHashStrategy();
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;

    private ShortBigArrays() {
    }

    public static short get(short[][] array, long index) {
        return array[BigArrays.segment(index)][BigArrays.displacement(index)];
    }

    public static void set(short[][] array, long index, short value) {
        array[BigArrays.segment((long)index)][BigArrays.displacement((long)index)] = value;
    }

    public static void swap(short[][] array, long first, long second) {
        short t = array[BigArrays.segment(first)][BigArrays.displacement(first)];
        array[BigArrays.segment((long)first)][BigArrays.displacement((long)first)] = array[BigArrays.segment(second)][BigArrays.displacement(second)];
        array[BigArrays.segment((long)second)][BigArrays.displacement((long)second)] = t;
    }

    public static void add(short[][] array, long index, short incr) {
        short[] sArray = array[BigArrays.segment(index)];
        int n2 = BigArrays.displacement(index);
        sArray[n2] = (short)(sArray[n2] + incr);
    }

    public static void mul(short[][] array, long index, short factor) {
        short[] sArray = array[BigArrays.segment(index)];
        int n2 = BigArrays.displacement(index);
        sArray[n2] = (short)(sArray[n2] * factor);
    }

    public static void incr(short[][] array, long index) {
        short[] sArray = array[BigArrays.segment(index)];
        int n2 = BigArrays.displacement(index);
        sArray[n2] = (short)(sArray[n2] + 1);
    }

    public static void decr(short[][] array, long index) {
        short[] sArray = array[BigArrays.segment(index)];
        int n2 = BigArrays.displacement(index);
        sArray[n2] = (short)(sArray[n2] - 1);
    }

    public static long length(short[][] array) {
        int length = array.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array[length - 1].length;
    }

    public static void copy(short[][] srcArray, long srcPos, short[][] destArray, long destPos, long length) {
        if (destPos <= srcPos) {
            int srcSegment = BigArrays.segment(srcPos);
            int destSegment = BigArrays.segment(destPos);
            int srcDispl = BigArrays.displacement(srcPos);
            int destDispl = BigArrays.displacement(destPos);
            while (length > 0L) {
                int l2 = (int)Math.min(length, (long)Math.min(srcArray[srcSegment].length - srcDispl, destArray[destSegment].length - destDispl));
                System.arraycopy(srcArray[srcSegment], srcDispl, destArray[destSegment], destDispl, l2);
                if ((srcDispl += l2) == 0x8000000) {
                    srcDispl = 0;
                    ++srcSegment;
                }
                if ((destDispl += l2) == 0x8000000) {
                    destDispl = 0;
                    ++destSegment;
                }
                length -= (long)l2;
            }
        } else {
            int srcSegment = BigArrays.segment(srcPos + length);
            int destSegment = BigArrays.segment(destPos + length);
            int srcDispl = BigArrays.displacement(srcPos + length);
            int destDispl = BigArrays.displacement(destPos + length);
            while (length > 0L) {
                if (srcDispl == 0) {
                    srcDispl = 0x8000000;
                    --srcSegment;
                }
                if (destDispl == 0) {
                    destDispl = 0x8000000;
                    --destSegment;
                }
                int l3 = (int)Math.min(length, (long)Math.min(srcDispl, destDispl));
                System.arraycopy(srcArray[srcSegment], srcDispl - l3, destArray[destSegment], destDispl - l3, l3);
                srcDispl -= l3;
                destDispl -= l3;
                length -= (long)l3;
            }
        }
    }

    public static void copyFromBig(short[][] srcArray, long srcPos, short[] destArray, int destPos, int length) {
        int srcSegment = BigArrays.segment(srcPos);
        int srcDispl = BigArrays.displacement(srcPos);
        while (length > 0) {
            int l2 = Math.min(srcArray[srcSegment].length - srcDispl, length);
            System.arraycopy(srcArray[srcSegment], srcDispl, destArray, destPos, l2);
            if ((srcDispl += l2) == 0x8000000) {
                srcDispl = 0;
                ++srcSegment;
            }
            destPos += l2;
            length -= l2;
        }
    }

    public static void copyToBig(short[] srcArray, int srcPos, short[][] destArray, long destPos, long length) {
        int destSegment = BigArrays.segment(destPos);
        int destDispl = BigArrays.displacement(destPos);
        while (length > 0L) {
            int l2 = (int)Math.min((long)(destArray[destSegment].length - destDispl), length);
            System.arraycopy(srcArray, srcPos, destArray[destSegment], destDispl, l2);
            if ((destDispl += l2) == 0x8000000) {
                destDispl = 0;
                ++destSegment;
            }
            srcPos += l2;
            length -= (long)l2;
        }
    }

    public static short[][] newBigArray(long length) {
        if (length == 0L) {
            return EMPTY_BIG_ARRAY;
        }
        int baseLength = (int)((length + 0x7FFFFFFL) / 0x8000000L);
        short[][] base = new short[baseLength][];
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i2 = 0; i2 < baseLength - 1; ++i2) {
                base[i2] = new short[0x8000000];
            }
            base[baseLength - 1] = new short[residual];
        } else {
            for (int i3 = 0; i3 < baseLength; ++i3) {
                base[i3] = new short[0x8000000];
            }
        }
        return base;
    }

    public static short[][] wrap(short[] array) {
        if (array.length == 0) {
            return EMPTY_BIG_ARRAY;
        }
        if (array.length <= 0x8000000) {
            return new short[][]{array};
        }
        short[][] bigArray = ShortBigArrays.newBigArray(array.length);
        for (int i2 = 0; i2 < bigArray.length; ++i2) {
            System.arraycopy(array, (int)BigArrays.start(i2), bigArray[i2], 0, bigArray[i2].length);
        }
        return bigArray;
    }

    public static short[][] ensureCapacity(short[][] array, long length) {
        return ShortBigArrays.ensureCapacity(array, length, ShortBigArrays.length(array));
    }

    public static short[][] ensureCapacity(short[][] array, long length, long preserve) {
        long oldLength = ShortBigArrays.length(array);
        if (length > oldLength) {
            int valid = array.length - (array.length == 0 || array.length > 0 && array[array.length - 1].length == 0x8000000 ? 0 : 1);
            int baseLength = (int)((length + 0x7FFFFFFL) / 0x8000000L);
            short[][] base = (short[][])Arrays.copyOf(array, baseLength);
            int residual = (int)(length & 0x7FFFFFFL);
            if (residual != 0) {
                for (int i2 = valid; i2 < baseLength - 1; ++i2) {
                    base[i2] = new short[0x8000000];
                }
                base[baseLength - 1] = new short[residual];
            } else {
                for (int i3 = valid; i3 < baseLength; ++i3) {
                    base[i3] = new short[0x8000000];
                }
            }
            if (preserve - (long)valid * 0x8000000L > 0L) {
                ShortBigArrays.copy(array, (long)valid * 0x8000000L, base, (long)valid * 0x8000000L, preserve - (long)valid * 0x8000000L);
            }
            return base;
        }
        return array;
    }

    public static short[][] grow(short[][] array, long length) {
        long oldLength = ShortBigArrays.length(array);
        return length > oldLength ? ShortBigArrays.grow(array, length, oldLength) : array;
    }

    public static short[][] grow(short[][] array, long length, long preserve) {
        long oldLength = ShortBigArrays.length(array);
        return length > oldLength ? ShortBigArrays.ensureCapacity(array, Math.max(106039L * oldLength >>> 16, length), preserve) : array;
    }

    public static short[][] trim(short[][] array, long length) {
        long oldLength = ShortBigArrays.length(array);
        if (length >= oldLength) {
            return array;
        }
        int baseLength = (int)((length + 0x7FFFFFFL) / 0x8000000L);
        short[][] base = (short[][])Arrays.copyOf(array, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = ShortArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    public static short[][] setLength(short[][] array, long length) {
        long oldLength = ShortBigArrays.length(array);
        if (length == oldLength) {
            return array;
        }
        if (length < oldLength) {
            return ShortBigArrays.trim(array, length);
        }
        return ShortBigArrays.ensureCapacity(array, length);
    }

    public static short[][] copy(short[][] array, long offset, long length) {
        ShortBigArrays.ensureOffsetLength(array, offset, length);
        short[][] a2 = ShortBigArrays.newBigArray(length);
        ShortBigArrays.copy(array, offset, a2, 0L, length);
        return a2;
    }

    public static short[][] copy(short[][] array) {
        short[][] base = (short[][])array.clone();
        int i2 = base.length;
        while (i2-- != 0) {
            base[i2] = (short[])array[i2].clone();
        }
        return base;
    }

    public static void fill(short[][] array, short value) {
        int i2 = array.length;
        while (i2-- != 0) {
            ShortArrays.fill(array[i2], value);
        }
    }

    public static void fill(short[][] array, long from, long to, short value) {
        long length = ShortBigArrays.length(array);
        BigArrays.ensureFromTo(length, from, to);
        int fromSegment = BigArrays.segment(from);
        int toSegment = BigArrays.segment(to);
        int fromDispl = BigArrays.displacement(from);
        int toDispl = BigArrays.displacement(to);
        if (fromSegment == toSegment) {
            ShortArrays.fill(array[fromSegment], fromDispl, toDispl, value);
            return;
        }
        if (toDispl != 0) {
            ShortArrays.fill(array[toSegment], 0, toDispl, value);
        }
        while (--toSegment > fromSegment) {
            ShortArrays.fill(array[toSegment], value);
        }
        ShortArrays.fill(array[fromSegment], fromDispl, 0x8000000, value);
    }

    public static boolean equals(short[][] a1, short[][] a2) {
        if (ShortBigArrays.length(a1) != ShortBigArrays.length(a2)) {
            return false;
        }
        int i2 = a1.length;
        while (i2-- != 0) {
            short[] t = a1[i2];
            short[] u = a2[i2];
            int j2 = t.length;
            while (j2-- != 0) {
                if (t[j2] == u[j2]) continue;
                return false;
            }
        }
        return true;
    }

    public static String toString(short[][] a2) {
        if (a2 == null) {
            return "null";
        }
        long last = ShortBigArrays.length(a2) - 1L;
        if (last == -1L) {
            return "[]";
        }
        StringBuilder b2 = new StringBuilder();
        b2.append('[');
        long i2 = 0L;
        while (true) {
            b2.append(String.valueOf(ShortBigArrays.get(a2, i2)));
            if (i2 == last) {
                return b2.append(']').toString();
            }
            b2.append(", ");
            ++i2;
        }
    }

    public static void ensureFromTo(short[][] a2, long from, long to) {
        BigArrays.ensureFromTo(ShortBigArrays.length(a2), from, to);
    }

    public static void ensureOffsetLength(short[][] a2, long offset, long length) {
        BigArrays.ensureOffsetLength(ShortBigArrays.length(a2), offset, length);
    }

    private static void vecSwap(short[][] x, long a2, long b2, long n2) {
        int i2 = 0;
        while ((long)i2 < n2) {
            ShortBigArrays.swap(x, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static long med3(short[][] x, long a2, long b2, long c2, ShortComparator comp) {
        int ab = comp.compare(ShortBigArrays.get(x, a2), ShortBigArrays.get(x, b2));
        int ac = comp.compare(ShortBigArrays.get(x, a2), ShortBigArrays.get(x, c2));
        int bc = comp.compare(ShortBigArrays.get(x, b2), ShortBigArrays.get(x, c2));
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    public static void quickSort(short[][] x, long from, long to, ShortComparator comp) {
        long c2;
        long a2;
        long len = to - from;
        if (len < 7L) {
            for (long i2 = from; i2 < to; ++i2) {
                for (long j2 = i2; j2 > from && comp.compare(ShortBigArrays.get(x, j2 - 1L), ShortBigArrays.get(x, j2)) > 0; --j2) {
                    ShortBigArrays.swap(x, j2, j2 - 1L);
                }
            }
            return;
        }
        long m2 = from + len / 2L;
        if (len > 7L) {
            long l2 = from;
            long n2 = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l2 = ShortBigArrays.med3(x, l2, l2 + s, l2 + 2L * s, comp);
                m2 = ShortBigArrays.med3(x, m2 - s, m2, m2 + s, comp);
                n2 = ShortBigArrays.med3(x, n2 - 2L * s, n2 - s, n2, comp);
            }
            m2 = ShortBigArrays.med3(x, l2, m2, n2, comp);
        }
        short v = ShortBigArrays.get(x, m2);
        long b2 = a2 = from;
        long d2 = c2 = to - 1L;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = comp.compare(ShortBigArrays.get(x, b2), v)) <= 0) {
                if (comparison == 0) {
                    ShortBigArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = comp.compare(ShortBigArrays.get(x, c2), v)) >= 0) {
                if (comparison == 0) {
                    ShortBigArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            ShortBigArrays.swap(x, b2++, c2--);
        }
        long n3 = to;
        long s = Math.min(a2 - from, b2 - a2);
        ShortBigArrays.vecSwap(x, from, b2 - s, s);
        s = Math.min(d2 - c2, n3 - d2 - 1L);
        ShortBigArrays.vecSwap(x, b2, n3 - s, s);
        s = b2 - a2;
        if (s > 1L) {
            ShortBigArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d2 - c2) > 1L) {
            ShortBigArrays.quickSort(x, n3 - s, n3, comp);
        }
    }

    private static long med3(short[][] x, long a2, long b2, long c2) {
        int bc;
        int ac;
        int ab;
        int n2 = ShortBigArrays.get(x, a2) < ShortBigArrays.get(x, b2) ? -1 : (ab = ShortBigArrays.get(x, a2) == ShortBigArrays.get(x, b2) ? 0 : 1);
        int n3 = ShortBigArrays.get(x, a2) < ShortBigArrays.get(x, c2) ? -1 : (ac = ShortBigArrays.get(x, a2) == ShortBigArrays.get(x, c2) ? 0 : 1);
        int n4 = ShortBigArrays.get(x, b2) < ShortBigArrays.get(x, c2) ? -1 : (bc = ShortBigArrays.get(x, b2) == ShortBigArrays.get(x, c2) ? 0 : 1);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    public static void quickSort(short[][] x, ShortComparator comp) {
        ShortBigArrays.quickSort(x, 0L, ShortBigArrays.length(x), comp);
    }

    public static void quickSort(short[][] x, long from, long to) {
        long c2;
        long a2;
        long len = to - from;
        if (len < 7L) {
            for (long i2 = from; i2 < to; ++i2) {
                for (long j2 = i2; j2 > from && (ShortBigArrays.get(x, j2 - 1L) < ShortBigArrays.get(x, j2) ? -1 : (ShortBigArrays.get(x, j2 - 1L) == ShortBigArrays.get(x, j2) ? 0 : 1)) > 0; --j2) {
                    ShortBigArrays.swap(x, j2, j2 - 1L);
                }
            }
            return;
        }
        long m2 = from + len / 2L;
        if (len > 7L) {
            long l2 = from;
            long n2 = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l2 = ShortBigArrays.med3(x, l2, l2 + s, l2 + 2L * s);
                m2 = ShortBigArrays.med3(x, m2 - s, m2, m2 + s);
                n2 = ShortBigArrays.med3(x, n2 - 2L * s, n2 - s, n2);
            }
            m2 = ShortBigArrays.med3(x, l2, m2, n2);
        }
        short v = ShortBigArrays.get(x, m2);
        long b2 = a2 = from;
        long d2 = c2 = to - 1L;
        while (true) {
            int comparison;
            if (b2 <= c2 && (ShortBigArrays.get(x, b2) < v ? -1 : (comparison = ShortBigArrays.get(x, b2) == v ? 0 : 1)) <= 0) {
                if (comparison == 0) {
                    ShortBigArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (ShortBigArrays.get(x, c2) < v ? -1 : (comparison = ShortBigArrays.get(x, c2) == v ? 0 : 1)) >= 0) {
                if (comparison == 0) {
                    ShortBigArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            ShortBigArrays.swap(x, b2++, c2--);
        }
        long n3 = to;
        long s = Math.min(a2 - from, b2 - a2);
        ShortBigArrays.vecSwap(x, from, b2 - s, s);
        s = Math.min(d2 - c2, n3 - d2 - 1L);
        ShortBigArrays.vecSwap(x, b2, n3 - s, s);
        s = b2 - a2;
        if (s > 1L) {
            ShortBigArrays.quickSort(x, from, from + s);
        }
        if ((s = d2 - c2) > 1L) {
            ShortBigArrays.quickSort(x, n3 - s, n3);
        }
    }

    public static void quickSort(short[][] x) {
        ShortBigArrays.quickSort(x, 0L, ShortBigArrays.length(x));
    }

    public static long binarySearch(short[][] a2, long from, long to, short key) {
        while (from <= to) {
            long mid = from + to >>> 1;
            short midVal = ShortBigArrays.get(a2, mid);
            if (midVal < key) {
                from = mid + 1L;
                continue;
            }
            if (midVal > key) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from + 1L);
    }

    public static long binarySearch(short[][] a2, short key) {
        return ShortBigArrays.binarySearch(a2, 0L, ShortBigArrays.length(a2), key);
    }

    public static long binarySearch(short[][] a2, long from, long to, short key, ShortComparator c2) {
        while (from <= to) {
            long mid = from + to >>> 1;
            short midVal = ShortBigArrays.get(a2, mid);
            int cmp = c2.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from + 1L);
    }

    public static long binarySearch(short[][] a2, short key, ShortComparator c2) {
        return ShortBigArrays.binarySearch(a2, 0L, ShortBigArrays.length(a2), key, c2);
    }

    public static short[][] shuffle(short[][] a2, long from, long to, Random random) {
        long i2 = to - from;
        while (i2-- != 0L) {
            long p2 = (random.nextLong() & Long.MAX_VALUE) % (i2 + 1L);
            short t = ShortBigArrays.get(a2, from + i2);
            ShortBigArrays.set(a2, from + i2, ShortBigArrays.get(a2, from + p2));
            ShortBigArrays.set(a2, from + p2, t);
        }
        return a2;
    }

    public static short[][] shuffle(short[][] a2, Random random) {
        long i2 = ShortBigArrays.length(a2);
        while (i2-- != 0L) {
            long p2 = (random.nextLong() & Long.MAX_VALUE) % (i2 + 1L);
            short t = ShortBigArrays.get(a2, i2);
            ShortBigArrays.set(a2, i2, ShortBigArrays.get(a2, p2));
            ShortBigArrays.set(a2, p2, t);
        }
        return a2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BigArrayHashStrategy
    implements Hash.Strategy<short[][]>,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        private BigArrayHashStrategy() {
        }

        @Override
        public int hashCode(short[][] o2) {
            return Arrays.deepHashCode((Object[])o2);
        }

        @Override
        public boolean equals(short[][] a2, short[][] b2) {
            return ShortBigArrays.equals(a2, b2);
        }
    }
}

