/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class DelayUndoManager
extends UndoManager {
    private int _delay = 500;
    private CompoundEdit _cache;
    private static Logger LOGGER = Logger.getLogger(DelayUndoManager.class.getName());
    protected Timer _timer;

    public DelayUndoManager() {
    }

    public DelayUndoManager(int n2) {
        this._delay = n2;
    }

    public boolean isCacheEmpty() {
        return this._cache == null;
    }

    public synchronized void commitCache() {
        if (this._cache != null) {
            this._cache.end();
            this.addEditWithoutCaching();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.info("Commit cache: " + this._cache);
            }
            this._cache = null;
        }
    }

    public void addEditWithoutCaching() {
        DelayUndoManager.super.addEdit(this._cache);
    }

    public synchronized void discardCache() {
        this._cache = null;
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
    }

    public synchronized boolean addEdit(UndoableEdit undoableEdit) {
        if (this._cache == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.info("Create cache: " + undoableEdit);
            }
            this._cache = new CompoundEdit();
            boolean bl = this._cache.addEdit(undoableEdit);
            if (bl) {
                this._timer = new Timer(this._delay, new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        DelayUndoManager.this.commitCache();
                    }
                });
                this._timer.setRepeats(false);
                this._timer.start();
            }
            return bl;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.info("Add to cache: " + undoableEdit);
        }
        if (this._timer != null) {
            this._timer.restart();
        }
        return this._cache.addEdit(undoableEdit);
    }

    public synchronized boolean canUndo() {
        this.commitCache();
        return super.canUndo();
    }

    public synchronized boolean canRedo() {
        this.commitCache();
        return super.canRedo();
    }

    public synchronized void undo() throws CannotUndoException {
        this.commitCache();
        super.undo();
    }

    public synchronized void redo() throws CannotRedoException {
        this.commitCache();
        super.redo();
    }

    public synchronized void discardAllEdits() {
        super.discardAllEdits();
        this.discardCache();
    }
}

