/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArrayList<K>
extends AbstractObjectList<K>
implements RandomAccess,
Cloneable,
Serializable {
    public static final long serialVersionUID = -7046029254386353131L;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected static final long ONEOVERPHI = 106039L;
    protected final boolean wrapped;
    protected transient K[] a;
    protected int size;
    private static final boolean ASSERTS = false;

    protected ObjectArrayList(K[] a2, boolean dummy) {
        this.a = a2;
        this.wrapped = true;
    }

    public ObjectArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = new Object[capacity];
        this.wrapped = false;
    }

    public ObjectArrayList() {
        this(16);
    }

    public ObjectArrayList(Collection<? extends K> c2) {
        this(c2.size());
        this.size = ObjectIterators.unwrap(c2.iterator(), this.a);
    }

    public ObjectArrayList(ObjectCollection<? extends K> c2) {
        this(c2.size());
        this.size = ObjectIterators.unwrap(c2.iterator(), this.a);
    }

    public ObjectArrayList(ObjectList<? extends K> l2) {
        this(l2.size());
        this.size = l2.size();
        l2.getElements(0, this.a, 0, this.size);
    }

    public ObjectArrayList(K[] a2) {
        this(a2, 0, a2.length);
    }

    public ObjectArrayList(K[] a2, int offset, int length) {
        this(length);
        System.arraycopy(a2, offset, this.a, 0, length);
        this.size = length;
    }

    public ObjectArrayList(Iterator<? extends K> i2) {
        this();
        while (i2.hasNext()) {
            this.add(i2.next());
        }
    }

    public ObjectArrayList(ObjectIterator<? extends K> i2) {
        this();
        while (i2.hasNext()) {
            this.add((K)i2.next());
        }
    }

    public K[] elements() {
        return this.a;
    }

    public static <K> ObjectArrayList<K> wrap(K[] a2, int length) {
        if (length > a2.length) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + a2.length + ")");
        }
        ObjectArrayList<K> l2 = new ObjectArrayList<K>(a2, false);
        l2.size = length;
        return l2;
    }

    public static <K> ObjectArrayList<K> wrap(K[] a2) {
        return ObjectArrayList.wrap(a2, a2.length);
    }

    public void ensureCapacity(int capacity) {
        if (this.wrapped) {
            this.a = ObjectArrays.ensureCapacity(this.a, capacity, this.size);
        } else if (capacity > this.a.length) {
            Object[] t = new Object[capacity];
            System.arraycopy(this.a, 0, t, 0, this.size);
            this.a = t;
        }
    }

    private void grow(int capacity) {
        if (this.wrapped) {
            this.a = ObjectArrays.grow(this.a, capacity, this.size);
        } else if (capacity > this.a.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)this.a.length >>> 16, (long)capacity), Integer.MAX_VALUE);
            Object[] t = new Object[newLength];
            System.arraycopy(this.a, 0, t, 0, this.size);
            this.a = t;
        }
    }

    @Override
    public void add(int index, K k2) {
        this.ensureIndex(index);
        this.grow(this.size + 1);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + 1, this.size - index);
        }
        this.a[index] = k2;
        ++this.size;
    }

    @Override
    public boolean add(K k2) {
        this.grow(this.size + 1);
        this.a[this.size++] = k2;
        return true;
    }

    @Override
    public K get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return this.a[index];
    }

    @Override
    public int indexOf(Object k2) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!(k2 == null ? this.a[i2] == null : k2.equals(this.a[i2]))) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object k2) {
        int i2 = this.size;
        while (i2-- != 0) {
            if (!(k2 == null ? this.a[i2] == null : k2.equals(this.a[i2]))) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public K remove(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        K old = this.a[index];
        --this.size;
        if (index != this.size) {
            System.arraycopy(this.a, index + 1, this.a, index, this.size - index);
        }
        this.a[this.size] = null;
        return old;
    }

    public boolean rem(Object k2) {
        int index = this.indexOf(k2);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public boolean remove(Object o2) {
        return this.rem(o2);
    }

    @Override
    public K set(int index, K k2) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        K old = this.a[index];
        this.a[index] = k2;
        return old;
    }

    @Override
    public void clear() {
        ObjectArrays.fill(this.a, 0, this.size, null);
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void size(int size) {
        if (size > this.a.length) {
            this.ensureCapacity(size);
        }
        if (size > this.size) {
            ObjectArrays.fill(this.a, this.size, size, null);
        } else {
            ObjectArrays.fill(this.a, size, this.size, null);
        }
        this.size = size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public void trim() {
        this.trim(0);
    }

    public void trim(int n2) {
        if (n2 >= this.a.length || this.size == this.a.length) {
            return;
        }
        Object[] t = new Object[Math.max(n2, this.size)];
        System.arraycopy(this.a, 0, t, 0, this.size);
        this.a = t;
    }

    @Override
    public void getElements(int from, Object[] a2, int offset, int length) {
        ObjectArrays.ensureOffsetLength(a2, offset, length);
        System.arraycopy(this.a, from, a2, offset, length);
    }

    @Override
    public void removeElements(int from, int to) {
        Arrays.ensureFromTo(this.size, from, to);
        System.arraycopy(this.a, to, this.a, from, this.size - to);
        this.size -= to - from;
        int i2 = to - from;
        while (i2-- != 0) {
            this.a[this.size + i2] = null;
        }
    }

    @Override
    public void addElements(int index, K[] a2, int offset, int length) {
        this.ensureIndex(index);
        ObjectArrays.ensureOffsetLength(a2, offset, length);
        this.grow(this.size + length);
        System.arraycopy(this.a, index, this.a, index + length, this.size - index);
        System.arraycopy(a2, offset, this.a, index, length);
        this.size += length;
    }

    @Override
    public ObjectListIterator<K> listIterator(final int index) {
        this.ensureIndex(index);
        return new AbstractObjectListIterator<K>(){
            int pos;
            int last;
            {
                this.pos = index;
                this.last = -1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < ObjectArrayList.this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0;
            }

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return ObjectArrayList.this.a[this.last];
            }

            @Override
            public K previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return ObjectArrayList.this.a[this.pos];
            }

            @Override
            public int nextIndex() {
                return this.pos;
            }

            @Override
            public int previousIndex() {
                return this.pos - 1;
            }

            @Override
            public void add(K k2) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                ObjectArrayList.this.add(this.pos++, k2);
                this.last = -1;
            }

            @Override
            public void set(K k2) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                ObjectArrayList.this.set(this.last, k2);
            }

            @Override
            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                ObjectArrayList.this.remove(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    public ObjectArrayList<K> clone() {
        ObjectArrayList<K> c2 = new ObjectArrayList<K>(this.size);
        System.arraycopy(this.a, 0, c2.a, 0, this.size);
        c2.size = this.size;
        return c2;
    }

    private boolean valEquals(K a2, K b2) {
        return a2 == null ? b2 == null : a2.equals(b2);
    }

    public boolean equals(ObjectArrayList<K> l2) {
        if (l2 == this) {
            return true;
        }
        int s = this.size();
        if (s != l2.size()) {
            return false;
        }
        K[] a1 = this.a;
        K[] a2 = l2.a;
        while (s-- != 0) {
            if (this.valEquals(a1[s], a2[s])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(ObjectArrayList<? extends K> l2) {
        int i2;
        int s1 = this.size();
        int s2 = l2.size();
        K[] a1 = this.a;
        K[] a2 = l2.a;
        for (i2 = 0; i2 < s1 && i2 < s2; ++i2) {
            K e1 = a1[i2];
            K e2 = a2[i2];
            int r = ((Comparable)e1).compareTo(e2);
            if (r == 0) continue;
            return r;
        }
        return i2 < s2 ? -1 : (i2 < s1 ? 1 : 0);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (int i2 = 0; i2 < this.size; ++i2) {
            s.writeObject(this.a[i2]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.a = new Object[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.a[i2] = s.readObject();
        }
    }
}

