/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.multiplealignment;

import edu.mit.broad.prodinfo.genomicplot.ParseException;
import edu.mit.broad.prodinfo.multiplealignment.MAFAlignment;
import edu.mit.broad.prodinfo.multiplealignment.MultipleAlignment;
import edu.mit.broad.prodinfo.multiplealignment.MultipleAlignmentIO;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class MAFIO
implements MultipleAlignmentIO {
    RandomAccessFile fileHandle;
    MAFAlignment alignment;
    String alignmentFile;

    public MAFIO(String alignmentFile, boolean keepFileHandle) throws IOException, ParseException {
        this.alignment = this.createUnloadedAlignment(alignmentFile);
        this.alignmentFile = alignmentFile;
        if (keepFileHandle) {
            this.fileHandle = new RandomAccessFile(alignmentFile, "r");
        }
    }

    public MAFIO() {
    }

    @Override
    public String getPreferredFileExtension() {
        return ".maf";
    }

    public void destroyFileHandle() throws IOException {
        if (this.fileHandle != null) {
            this.fileHandle.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MAFAlignment load(List<String> sequencesToLoad, int start, int end) throws IOException, ParseException {
        boolean closeFile = false;
        if (this.fileHandle == null) {
            closeFile = true;
            this.fileHandle = new RandomAccessFile(this.alignmentFile, "r");
        }
        try {
            this.alignment.load(this.fileHandle, start, end, sequencesToLoad);
        }
        finally {
            if (closeFile) {
                this.fileHandle.close();
                this.fileHandle = null;
            }
        }
        return this.alignment;
    }

    public MAFAlignment createUnloadedAlignment(String fileName) throws IOException, ParseException {
        MAFAlignment aln = new MAFAlignment();
        String idxFileName = fileName + ".index";
        File idxFile = new File(idxFileName);
        if (!idxFile.exists()) {
            aln.createIndex(fileName);
            aln.writeIndex(idxFileName);
        } else {
            aln = new MAFAlignment(idxFileName);
        }
        return aln;
    }

    @Override
    public MAFAlignment load(String fileName) throws IOException, ParseException {
        return this.load(fileName, (List)new ArrayList());
    }

    @Override
    public MAFAlignment load(String fileName, List<String> sequencesToLoad) throws IOException, ParseException {
        MAFAlignment aln = new MAFAlignment();
        String idxFileName = fileName + ".index";
        File idxFile = new File(idxFileName);
        if (!idxFile.exists()) {
            aln.createIndex(fileName);
            aln.writeIndex(idxFileName);
        } else {
            aln = new MAFAlignment(idxFileName);
        }
        RandomAccessFile raf = new RandomAccessFile(fileName, "r");
        aln.load(raf, sequencesToLoad);
        raf.close();
        return aln;
    }

    @Override
    public MultipleAlignment load(InputStream in) throws IOException, ParseException {
        return this.load(in, new ArrayList<String>());
    }

    public MAFAlignment load(String fileName, List<String> sequencesToLoad, int start, int end) throws IOException, ParseException {
        MAFAlignment aln = new MAFAlignment();
        String idxFileName = fileName + ".index";
        File idxFile = new File(idxFileName);
        if (!idxFile.exists()) {
            System.out.print("Index file not exists, creating and writing it: " + idxFileName);
            aln.createIndex(fileName);
            aln.writeIndex(idxFileName);
            System.out.println("   Done writing index");
        } else {
            aln = new MAFAlignment(idxFileName);
        }
        RandomAccessFile raf = new RandomAccessFile(fileName, "r");
        aln.load(raf, start, end, sequencesToLoad);
        raf.close();
        return aln;
    }

    @Override
    public MultipleAlignment load(InputStream in, List<String> sequencesToLoad) throws IOException, ParseException {
        MAFAlignment aln = new MAFAlignment();
        MAFAlignment.MAFHeader header = aln.getHeader();
        Stack<MAFAlignment.MAFMultipleAlignmentBlock> blocks = new Stack<MAFAlignment.MAFMultipleAlignmentBlock>();
        ArrayList<String> seqIds = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        String[] lineInfo = null;
        String line = br.readLine();
        if (line == null || !line.startsWith("##maf ")) {
            throw new ParseException("First line in the file " + line + " was either null or did not start with \"##maf \" as specified");
        }
        header.setVariablesFromRawData(line.substring(6).split("\\s"));
        line = br.readLine();
        if (line == null || !line.startsWith("# ")) {
            throw new ParseException("Second line in the file " + line + " was either null or did not start with \"# \" as specified");
        }
        header.setRunParameters(line.substring(2));
        while ((line = br.readLine()) != null) {
            MAFAlignment.MAFMultipleAlignmentBlock ma;
            if (line.startsWith("#") || line.trim().length() == 0) continue;
            if (line.startsWith("a ")) {
                ma = new MAFAlignment.MAFMultipleAlignmentBlock();
                blocks.push(ma);
                lineInfo = line.substring(2).split("\\s");
                ma.setAlignmentInfoFromRawData(lineInfo);
                continue;
            }
            if (line.startsWith("s ")) {
                ma = blocks.peek();
                lineInfo = line.substring(2).split("\\s+");
                MultipleAlignment.AlignedSequence alnSeq = ma.addSequenceFromRawData(lineInfo);
                if (sequencesToLoad != null && sequencesToLoad.size() > 0 && !sequencesToLoad.contains(alnSeq.getId())) continue;
                if (aln.getReferenceId() == null) {
                    System.err.println("Ref is " + ma.getReferenceId());
                    aln.setReferenceId(alnSeq.getId());
                }
                if (ma.getReferenceId() != null) {
                    ma.setReferenceId(aln.getReferenceId());
                }
                if (seqIds.contains(alnSeq.getId())) continue;
                seqIds.add(alnSeq.getId());
                continue;
            }
            if (line.startsWith("i ") || line.startsWith("e ")) {
                System.err.println("Information blocks (i/e) are not yet supported");
                continue;
            }
            throw new ParseException("Invalid alignment line <" + line + ">");
        }
        aln.setBlocks(blocks);
        aln.setAlignedSequences(seqIds);
        return aln.toMultipleAlignment();
    }

    @Override
    public void write(BufferedWriter bw, MultipleAlignment ma) throws IOException {
    }

    @Override
    public void write(BufferedWriter bw, MultipleAlignment ma, List<String> sequenceOrder) throws IOException {
    }
}

