/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.variant.vcf;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.broad.igv.variant.Allele;
import org.broad.igv.variant.Genotype;
import org.broad.igv.variant.Variant;
import org.broad.igv.variant.vcf.VCFAllele;
import org.broad.igv.variant.vcf.VCFGenotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class VCFVariant
implements Variant {
    VariantContext variantContext;
    Set<Allele> alternateAlleles;
    private ZygosityCount zygosityCount;

    public VCFVariant(VariantContext variantContext) {
        this.variantContext = variantContext;
        this.init();
    }

    private void init() {
        this.zygosityCount = new ZygosityCount();
        for (String sample : this.getSampleNames()) {
            Genotype genotype = this.getGenotype(sample);
            this.zygosityCount.incrementCount(genotype);
        }
    }

    @Override
    public String getID() {
        return this.variantContext.getAttributeAsString("ID");
    }

    @Override
    public boolean isFiltered() {
        return this.variantContext.isFiltered();
    }

    @Override
    public String getAttributeAsString(String key) {
        return this.variantContext.getAttributeAsString(key);
    }

    @Override
    public String getReference() {
        return this.variantContext.getReference().toString();
    }

    @Override
    public Set<Allele> getAlternateAlleles() {
        if (this.alternateAlleles == null) {
            Set<org.broadinstitute.sting.utils.variantcontext.Allele> tmp = this.variantContext.getAlternateAlleles();
            this.alternateAlleles = new HashSet<Allele>(tmp.size());
            for (org.broadinstitute.sting.utils.variantcontext.Allele a2 : tmp) {
                this.alternateAlleles.add(new VCFAllele(a2.getBases()));
            }
        }
        return this.alternateAlleles;
    }

    @Override
    public double getPhredScaledQual() {
        return this.variantContext.getPhredScaledQual();
    }

    @Override
    public String getType() {
        return this.variantContext.getType().toString();
    }

    @Override
    public double getAlleleFreq() {
        double alleleFreq = Double.parseDouble(this.variantContext.getAttributeAsString("AF", "-1"));
        if (alleleFreq < 0.0) {
            alleleFreq = Double.parseDouble(this.variantContext.getAttributeAsString("GMAF", "-1"));
        }
        return alleleFreq;
    }

    @Override
    public double getAlleleFraction() {
        int total = this.getHomVarCount() + this.getHetCount() + this.getHomRefCount();
        return total == 0 ? -1.0 : ((double)this.getHomVarCount() + (double)this.getHetCount() / 2.0) / (double)total;
    }

    @Override
    public Collection<String> getSampleNames() {
        return this.variantContext.getSampleNames();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.variantContext.getAttributes();
    }

    @Override
    public Genotype getGenotype(String sample) {
        return new VCFGenotype(this.variantContext.getGenotype(sample));
    }

    @Override
    public Collection<String> getFilters() {
        return this.variantContext.getFilters();
    }

    @Override
    public int getHomVarCount() {
        return this.zygosityCount.getHomVar();
    }

    @Override
    public int getHetCount() {
        return this.zygosityCount.getHet();
    }

    @Override
    public int getHomRefCount() {
        return this.zygosityCount.getHomRef();
    }

    @Override
    public int getNoCallCount() {
        return this.zygosityCount.getNoCall();
    }

    @Override
    public String getChr() {
        return this.variantContext.getChr();
    }

    @Override
    public int getStart() {
        return this.variantContext.getStart();
    }

    @Override
    public int getEnd() {
        return this.variantContext.getEnd();
    }

    public static class ZygosityCount {
        private int homVar = 0;
        private int het = 0;
        private int homRef = 0;
        private int noCall = 0;

        public void incrementCount(Genotype genotype) {
            if (genotype != null) {
                if (genotype.isHomVar()) {
                    ++this.homVar;
                } else if (genotype.isHet()) {
                    ++this.het;
                } else if (genotype.isHomRef()) {
                    ++this.homRef;
                } else {
                    ++this.noCall;
                }
            }
        }

        public int getHomVar() {
            return this.homVar;
        }

        public int getHet() {
            return this.het;
        }

        public int getHomRef() {
            return this.homRef;
        }

        public int getNoCall() {
            return this.noCall;
        }
    }
}

