/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ResourceLocator;

public class LoadFromDatabaseAction
extends MenuAction {
    static Logger log = Logger.getLogger(LoadFromDatabaseAction.class);
    IGV mainFrame;

    public LoadFromDatabaseAction(String label, int mnemonic, IGV mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        this.setToolTipText("Load data, features or sample information from a server");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                String host = PreferenceManager.getInstance().get("DB_HOST");
                if (host == null || host.trim().length() == 0) {
                    MessageUtils.showMessage("Please set database configuration in user preferences (View > Preferences)");
                    return null;
                }
                PreferenceManager preferenceManager = PreferenceManager.getInstance();
                String db = preferenceManager.get("DB_NAME");
                String port = preferenceManager.get("DB_PORT");
                String url = "jdbc:mysql://" + host;
                if (!port.equals("-1")) {
                    url = url + ":" + port;
                }
                url = url + "/" + db;
                String table1 = "CNV";
                ResourceLocator loc1 = new ResourceLocator(url, table1);
                String query = "SELECT  cnv.Sample Sample, cnv.`Probe Median` Value, cnv.Chromosome chr,  cnv.Start start, cnv.Stop end, CONCAT('<br>Event: ', cnv.Event,'<br>% CNV Overlap = ', cnv.`% of CNV Overlap`) description  FROM CNV";
                loc1.setDescription(query);
                loc1.setType(".seg");
                LoadFromDatabaseAction.this.mainFrame.loadTracks(Arrays.asList(loc1));
                return null;
            }

            @Override
            protected void done() {
                LoadFromDatabaseAction.this.mainFrame.showLoadedTrackCount();
            }
        };
        worker.execute();
    }
}

