/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.FeatureRenderer;
import org.broad.igv.track.RenderContext;

public class BedRenderer
implements FeatureRenderer {
    @Override
    public void renderAlignments(List<Alignment> alignments, RenderContext context, Rectangle rect, AlignmentTrack.RenderOptions renderOptions, boolean leaveMargin, Map<String, Color> selectedReadNames) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        if (alignments != null && alignments.size() > 0) {
            for (Alignment alignment : alignments) {
                double pixelStart = ((double)alignment.getStart() - origin) / locScale;
                double pixelEnd = ((double)alignment.getEnd() - origin) / locScale;
                if (!(pixelEnd >= rect.getX()) || !(pixelStart <= rect.getMaxX())) continue;
                Graphics2D g2 = context.getGraphic2DForColor(Color.GRAY);
                int w = Math.max(1, (int)(pixelEnd - pixelStart));
                int h2 = (int)Math.max(1.0, rect.getHeight() - 2.0);
                int y = (int)(rect.getY() + (rect.getHeight() - (double)h2) / 2.0);
                g2.fillRect((int)pixelStart, y, w, h2);
            }
        }
    }
}

