/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.AbstractUnivariateStatistic;
import org.apache.commons.math.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math.util.MathUtils;

public abstract class AbstractStorelessUnivariateStatistic
extends AbstractUnivariateStatistic
implements StorelessUnivariateStatistic,
Serializable {
    private static final long serialVersionUID = -44915725420072521L;

    public double evaluate(double[] values) {
        if (values == null) {
            throw new IllegalArgumentException("input value array is null");
        }
        return this.evaluate(values, 0, values.length);
    }

    public double evaluate(double[] values, int begin, int length) {
        if (this.test(values, begin, length)) {
            this.clear();
            this.incrementAll(values, begin, length);
        }
        return this.getResult();
    }

    public abstract void clear();

    public abstract double getResult();

    public abstract void increment(double var1);

    public void incrementAll(double[] values) {
        if (values == null) {
            throw new IllegalArgumentException("input values array is null");
        }
        this.incrementAll(values, 0, values.length);
    }

    public void incrementAll(double[] values, int begin, int length) {
        if (this.test(values, begin, length)) {
            int k2 = begin + length;
            int i2 = begin;
            while (i2 < k2) {
                this.increment(values[i2]);
                ++i2;
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractStorelessUnivariateStatistic)) {
            return false;
        }
        AbstractStorelessUnivariateStatistic stat = (AbstractStorelessUnivariateStatistic)object;
        return MathUtils.equals(stat.getResult(), this.getResult()) && MathUtils.equals(stat.getN(), this.getN());
    }

    public int hashCode() {
        return 31 * (31 + MathUtils.hash(this.getResult())) + MathUtils.hash(this.getN());
    }

    public abstract long getN();
}

