/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Point;
import java.awt.image.Raster;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import org.apache.batik.ext.awt.image.rendered.LRUCache;
import org.apache.batik.ext.awt.image.rendered.TileGenerator;
import org.apache.batik.ext.awt.image.rendered.TileLRUMember;
import org.apache.batik.ext.awt.image.rendered.TileStore;
import org.apache.batik.util.CleanerThread;
import org.apache.batik.util.HaltingThread;

public class TileMap
implements TileStore {
    private static final boolean DEBUG = false;
    private static final boolean COUNT = false;
    private HashMap rasters = new HashMap();
    private TileGenerator source = null;
    private LRUCache cache = null;
    static int requests;
    static int misses;
    static /* synthetic */ Class class$org$apache$batik$ext$awt$image$rendered$TileMap;

    public TileMap(TileGenerator source, LRUCache cache) {
        this.cache = cache;
        this.source = source;
    }

    public void setTile(int x, int y, Raster ras) {
        TileMapLRUMember item;
        Point pt = new Point(x, y);
        if (ras == null) {
            Object o2 = this.rasters.remove(pt);
            if (o2 != null) {
                this.cache.remove((TileMapLRUMember)o2);
            }
            return;
        }
        Object o3 = this.rasters.get(pt);
        if (o3 == null) {
            item = new TileMapLRUMember(this, pt, ras);
            this.rasters.put(pt, item);
        } else {
            item = (TileMapLRUMember)o3;
            item.setRaster(ras);
        }
        this.cache.add(item);
    }

    public Raster getTileNoCompute(int x, int y) {
        Point pt = new Point(x, y);
        Object o2 = this.rasters.get(pt);
        if (o2 == null) {
            return null;
        }
        TileMapLRUMember item = (TileMapLRUMember)o2;
        Raster ret = item.retrieveRaster();
        if (ret != null) {
            this.cache.add(item);
        }
        return ret;
    }

    public Raster getTile(int x, int y) {
        Raster ras = null;
        Point pt = new Point(x, y);
        Object o2 = this.rasters.get(pt);
        TileMapLRUMember item = null;
        if (o2 != null) {
            item = (TileMapLRUMember)o2;
            ras = item.retrieveRaster();
        }
        if (ras == null) {
            ras = this.source.genTile(x, y);
            if (HaltingThread.hasBeenHalted()) {
                return ras;
            }
            if (item != null) {
                item.setRaster(ras);
            } else {
                item = new TileMapLRUMember(this, pt, ras);
                this.rasters.put(pt, item);
            }
        }
        this.cache.add(item);
        return ras;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class TileMapLRUMember
    extends TileLRUMember {
        public Point pt;
        public SoftReference parent;

        TileMapLRUMember(TileMap parent, Point pt, Raster ras) {
            super(ras);
            this.parent = new SoftReference<TileMap>(parent);
            this.pt = pt;
        }

        public void setRaster(Raster ras) {
            this.hRaster = ras;
            this.wRaster = new RasterSoftRef(ras);
        }

        class RasterSoftRef
        extends CleanerThread.SoftReferenceCleared {
            RasterSoftRef(Object o2) {
                super(o2);
            }

            public void cleared() {
                TileMap tm = (TileMap)TileMapLRUMember.this.parent.get();
                if (tm != null) {
                    tm.rasters.remove(TileMapLRUMember.this.pt);
                }
            }
        }
    }
}

