/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import net.sf.samtools.util.BinaryCodec;

public class StringUtil {
    private static final byte UPPER_CASE_OFFSET = -32;

    public static String join(String separator, String ... strings) {
        if (strings.length == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder(strings[0]);
        for (int i2 = 1; i2 < strings.length; ++i2) {
            ret.append(separator);
            ret.append(strings[i2]);
        }
        return ret.toString();
    }

    public static int split(String aString, String[] tokens, char delim) {
        String trailingString;
        int maxTokens = tokens.length;
        int nTokens = 0;
        int start = 0;
        int end = aString.indexOf(delim);
        if (end < 0) {
            tokens[nTokens++] = aString;
            return nTokens;
        }
        while (end > 0 && nTokens < maxTokens) {
            tokens[nTokens++] = aString.substring(start, end);
            start = end + 1;
            end = aString.indexOf(delim, start);
        }
        if (nTokens < maxTokens && (trailingString = aString.substring(start)).length() > 0) {
            tokens[nTokens++] = trailingString;
        }
        return nTokens;
    }

    public static int splitConcatenateExcessTokens(String aString, String[] tokens, char delim) {
        int maxTokens = tokens.length;
        int nTokens = 0;
        int start = 0;
        int end = aString.indexOf(delim);
        if (end < 0) {
            tokens[nTokens++] = aString;
            return nTokens;
        }
        while (end > 0 && nTokens < maxTokens - 1) {
            tokens[nTokens++] = aString.substring(start, end);
            start = end + 1;
            end = aString.indexOf(delim, start);
        }
        String trailingString = aString.substring(start);
        if (trailingString.length() > 0) {
            tokens[nTokens++] = trailingString;
        }
        return nTokens;
    }

    public static byte toLowerCase(byte b2) {
        if (b2 < 65 || b2 > 90) {
            return b2;
        }
        return (byte)(b2 - -32);
    }

    public static byte toUpperCase(byte b2) {
        if (b2 < 97 || b2 > 122) {
            return b2;
        }
        return (byte)(b2 + -32);
    }

    public static void toUpperCase(byte[] bytes) {
        int length = bytes.length;
        for (int i2 = 0; i2 < length; ++i2) {
            if (bytes[i2] < 97 || bytes[i2] > 122) continue;
            bytes[i2] = (byte)(bytes[i2] + -32);
        }
    }

    public static String assertCharactersNotInString(String illegalChars, char ... chars) {
        for (char illegalChar : illegalChars.toCharArray()) {
            for (char ch : chars) {
                if (illegalChar != ch) continue;
                throw new IllegalArgumentException("Supplied String contains illegal character '" + illegalChar + "'.");
            }
        }
        return illegalChars;
    }

    public static String wordWrap(String s, int maxLineLength) {
        String[] lines = s.split("\n");
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(StringUtil.wordWrapSingleLine(line, maxLineLength));
        }
        if (s.endsWith("\n")) {
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String wordWrapSingleLine(String s, int maxLineLength) {
        if (s.length() <= maxLineLength) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int startCopyFrom = 0;
        while (startCopyFrom < s.length()) {
            int i2;
            int lastSpaceIndex = startCopyFrom;
            for (i2 = startCopyFrom; i2 < s.length() && i2 - startCopyFrom < maxLineLength; ++i2) {
                if (!Character.isWhitespace(s.charAt(i2))) continue;
                lastSpaceIndex = i2;
            }
            if (i2 - startCopyFrom < maxLineLength) {
                lastSpaceIndex = i2;
            }
            while (lastSpaceIndex < s.length() && Character.isWhitespace(s.charAt(lastSpaceIndex))) {
                ++lastSpaceIndex;
            }
            if (sb.length() > 0) {
                sb.append("\n");
            }
            if (lastSpaceIndex == startCopyFrom) {
                lastSpaceIndex = i2;
            }
            sb.append(s.substring(startCopyFrom, lastSpaceIndex));
            startCopyFrom = lastSpaceIndex;
        }
        return sb.toString();
    }

    public static String bytesToString(byte[] data) {
        if (data == null) {
            return null;
        }
        return StringUtil.bytesToString(data, 0, data.length);
    }

    public static String bytesToString(byte[] buffer, int offset, int length) {
        return new String(buffer, 0, offset, length);
    }

    public static byte[] stringToBytes(String s) {
        byte[] byteBuffer = new byte[s.length()];
        s.getBytes(0, byteBuffer.length, byteBuffer, 0);
        return byteBuffer;
    }

    public static byte[] stringToBytes(String s, int offset, int length) {
        byte[] byteBuffer = new byte[length];
        s.getBytes(offset, offset + length, byteBuffer, 0);
        return byteBuffer;
    }

    public static String readNullTerminatedString(BinaryCodec binaryCodec) {
        StringBuilder ret = new StringBuilder();
        byte b2 = binaryCodec.readByte();
        while (b2 != 0) {
            ret.append((char)(b2 & 0xFF));
            b2 = binaryCodec.readByte();
        }
        return ret.toString();
    }

    public static void charsToBytes(char[] chars, int charOffset, int length, byte[] bytes, int byteOffset) {
        for (int i2 = 0; i2 < length; ++i2) {
            bytes[byteOffset + i2] = (byte)chars[charOffset + i2];
        }
    }

    public static byte charToByte(char c2) {
        return (byte)c2;
    }

    public static char byteToChar(byte b2) {
        return (char)(b2 & 0xFF);
    }

    public static String bytesToHexString(byte[] data) {
        char[] chars = new char[2 * data.length];
        for (int i2 = 0; i2 < data.length; ++i2) {
            byte b2 = data[i2];
            chars[2 * i2] = StringUtil.toHexDigit(b2 >> 4 & 0xF);
            chars[2 * i2 + 1] = StringUtil.toHexDigit(b2 & 0xF);
        }
        return new String(chars);
    }

    public static byte[] hexStringToBytes(String s) throws NumberFormatException {
        if (s.length() % 2 != 0) {
            throw new NumberFormatException("Hex representation of byte string does not have even number of hex chars: " + s);
        }
        byte[] ret = new byte[s.length() / 2];
        for (int i2 = 0; i2 < ret.length; ++i2) {
            ret[i2] = (byte)(StringUtil.fromHexDigit(s.charAt(i2 * 2)) << 4 | StringUtil.fromHexDigit(s.charAt(i2 * 2 + 1)));
        }
        return ret;
    }

    public static char toHexDigit(int value) {
        return (char)(value < 10 ? 48 + value : 65 + value - 10);
    }

    public static int fromHexDigit(char c2) throws NumberFormatException {
        int ret = Character.digit(c2, 16);
        if (ret == -1) {
            throw new NumberFormatException("Not a valid hex digit: " + c2);
        }
        return ret;
    }

    public static String reverseString(String s) {
        StringBuilder sb = new StringBuilder(s);
        sb.reverse();
        return sb.toString();
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i2 = 0; i2 < strLen; ++i2) {
            if (Character.isWhitespace(str.charAt(i2))) continue;
            return false;
        }
        return true;
    }
}

