/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import net.sf.samtools.util.SeekableStream;

public class SeekableBufferedStream
extends SeekableStream {
    public static final int DEFAULT_BUFFER_SIZE = 512000;
    private final int bufferSize;
    final SeekableStream wrappedStream;
    BufferedInputStream bufferedStream;
    long position;

    public SeekableBufferedStream(SeekableStream httpStream, int bufferSize) {
        this.bufferSize = bufferSize;
        this.wrappedStream = httpStream;
        this.position = 0L;
        this.bufferedStream = new BufferedInputStream(this.wrappedStream, bufferSize);
    }

    public SeekableBufferedStream(SeekableStream httpStream) {
        this(httpStream, 512000);
    }

    @Override
    public long length() {
        return this.wrappedStream.length();
    }

    @Override
    public void seek(long position) throws IOException {
        this.position = position;
        this.wrappedStream.seek(position);
        this.bufferedStream = new BufferedInputStream(this.wrappedStream, this.bufferSize);
    }

    @Override
    public int read() throws IOException {
        int b2 = this.bufferedStream.read();
        ++this.position;
        return b2;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int nBytesRead = this.bufferedStream.read(buffer, offset, length);
        if (nBytesRead > 0) {
            this.position += (long)nBytesRead;
        }
        return nBytesRead;
    }

    @Override
    public void close() throws IOException {
        this.wrappedStream.close();
    }

    @Override
    public boolean eof() throws IOException {
        return this.position >= this.wrappedStream.length();
    }

    @Override
    public String getSource() {
        return this.wrappedStream.getSource();
    }
}

