/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;

public class GenomeUtils {
    static String rootDir = "/Volumes/seq_transcriptome/public/IGV/PORTALS/Schizos/genomes/";

    public static void main(String[] args) throws IOException {
        File cytoFile = new File(rootDir + "/SJ4.tmp", "Sjaponicus4_cytoband.txt");
        File aliasFile = new File(rootDir + "/SJ4.tmp", "SJ4_alias.tab");
        File seqDir = new File("/Volumes/seq_transcriptome/public/IGV/seq/Sjaponicus4.genome_seq");
        GenomeUtils.renameContigs(aliasFile, cytoFile, seqDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameContigs(File aliasFile, File cytobandFile, File seqDir) throws IOException {
        BufferedReader aliasReader = null;
        BufferedReader cytoReader = null;
        PrintWriter cytoWriter = null;
        File tmpCytoFile = new File(cytobandFile.getAbsolutePath() + ".tmp");
        File backup = new File(cytobandFile.getAbsolutePath() + ".bak");
        GenomeUtils.copyFile(cytobandFile, backup);
        try {
            String[] tokens;
            String nextLine;
            aliasReader = new BufferedReader(new FileReader(aliasFile));
            cytoReader = new BufferedReader(new FileReader(cytobandFile));
            cytoWriter = new PrintWriter(new BufferedWriter(new FileWriter(tmpCytoFile)));
            HashMap<String, String> map = new HashMap<String, String>();
            while ((nextLine = aliasReader.readLine()) != null) {
                tokens = nextLine.split("\t");
                if (tokens.length > 1) {
                    map.put(tokens[0], tokens[1]);
                    continue;
                }
                System.out.println(nextLine);
            }
            while ((nextLine = cytoReader.readLine()) != null) {
                tokens = nextLine.split("\t");
                String newName = (String)map.get(tokens[0]);
                if (newName != null) {
                    String oldName = tokens[0];
                    tokens[0] = newName;
                    File seqFile = new File(seqDir, oldName + ".txt");
                    File newSeqfile = new File(seqDir, newName + ".txt");
                    GenomeUtils.copyFile(seqFile, newSeqfile);
                }
                cytoWriter.print(tokens[0]);
                for (int i2 = 1; i2 < tokens.length; ++i2) {
                    cytoWriter.print("\t" + tokens[i2]);
                }
                cytoWriter.println();
            }
        }
        finally {
            if (aliasReader != null) {
                aliasReader.close();
            }
            if (cytoReader != null) {
                cytoReader.close();
            }
            if (cytoWriter != null) {
                cytoWriter.close();
            }
        }
        GenomeUtils.copyFile(tmpCytoFile, cytobandFile);
    }

    private static void copyFile(File fromFile, File toFile) throws IOException {
        System.out.println("cp " + fromFile.getName() + " " + toFile.getName());
        Runtime.getRuntime().exec("cp " + fromFile.getAbsolutePath() + " " + toFile.getAbsolutePath());
    }
}

