/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import net.sf.samtools.util.CloseableIterator;
import org.broad.igv.Globals;
import org.broad.igv.hic.data.Chromosome;
import org.broad.igv.hic.tools.AlignmentsSorter;
import org.broad.igv.hic.tools.Preprocessor;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.reader.AlignmentQueryReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;

public class HiCTools {
    public static Chromosome[] chromosomes;
    public static Map<String, Integer> chromosomeOrdinals;
    public static final Chromosome[] dmelChromosomes;
    public static final Chromosome[] hg18Chromosomes;
    public static final Chromosome[] b37Chromosomes;

    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            System.out.println("Usage: hictools <command> <inputFile> <outputFile>");
        }
        Globals.setHeadless(true);
        if (args[0].equals("sort")) {
            AlignmentsSorter.sort(args[1], args[2], null);
        } else if (args[0].equals("pre") || args[0].equals("bamToPairs")) {
            String genomeId = args[3];
            chromosomes = genomeId.equals("hg18") ? hg18Chromosomes : (genomeId.equals("b37") ? b37Chromosomes : dmelChromosomes);
            if (args[0].equals("bamToPairs")) {
                HiCTools.filterBam(args[1], args[2]);
            } else {
                long genomeLength = 0L;
                for (Chromosome c2 : chromosomes) {
                    if (c2 == null) continue;
                    genomeLength += (long)c2.getSize();
                }
                HiCTools.chromosomes[0] = new Chromosome(0, "All", (int)(genomeLength / 1000L));
                chromosomeOrdinals = new Hashtable<String, Integer>();
                for (int i2 = 0; i2 < chromosomes.length; ++i2) {
                    chromosomeOrdinals.put(chromosomes[i2].getName(), i2);
                }
                String[] tokens = args[1].split(",");
                ArrayList<String> files = new ArrayList<String>(tokens.length);
                for (String f2 : tokens) {
                    files.add(f2);
                }
                new Preprocessor(new File(args[2])).preprocess(files, genomeId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void filterBam(String inputBam, String outputFile) throws IOException {
        CloseableIterator<Alignment> iter = null;
        AlignmentQueryReader reader = null;
        PrintWriter pw = null;
        HashSet<Chromosome> allChroms = new HashSet<Chromosome>(Arrays.asList(chromosomes));
        try {
            pw = new PrintWriter(new FileWriter(outputFile));
            reader = AlignmentReaderFactory.getReader(inputBam, false);
            iter = reader.iterator();
            while (iter.hasNext()) {
                Alignment alignment = (Alignment)iter.next();
                ReadMate mate = alignment.getMate();
                if (!alignment.isPaired() || !alignment.isMapped() || alignment.getMappingQuality() <= 10 || mate == null || !mate.isMapped() || !allChroms.contains(alignment.getChr()) || !allChroms.contains(mate.getChr()) || alignment.getChr().equals(mate.getChr()) && alignment.getInferredInsertSize() <= 1000 || alignment.getStart() >= mate.getStart()) continue;
                String strand = alignment.isNegativeStrand() ? "-" : "+";
                String mateStrand = mate.isNegativeStrand() ? "-" : "+";
                pw.println(alignment.getReadName() + "\t" + alignment.getChr() + "\t" + alignment.getStart() + "\t" + strand + "\t.\t" + mate.getChr() + "\t" + mate.getStart() + "\t" + mateStrand);
            }
        }
        finally {
            pw.close();
            iter.close();
            reader.close();
        }
    }

    static {
        dmelChromosomes = new Chromosome[]{null, new Chromosome(1, "2L", 22407834), new Chromosome(2, "2R", 20766785), new Chromosome(3, "3L", 23771897), new Chromosome(4, "3R", 27905053), new Chromosome(5, "4", 1281640), new Chromosome(6, "X", 22224390)};
        hg18Chromosomes = new Chromosome[]{null, new Chromosome(1, "1", 247249719), new Chromosome(2, "2", 242951149), new Chromosome(3, "3", 199501827), new Chromosome(4, "4", 191273063), new Chromosome(5, "5", 180857866), new Chromosome(6, "6", 170899992), new Chromosome(7, "7", 158821424), new Chromosome(8, "8", 146274826), new Chromosome(9, "9", 140273252), new Chromosome(10, "10", 135374737), new Chromosome(11, "11", 134452384), new Chromosome(12, "12", 132349534), new Chromosome(13, "13", 114142980), new Chromosome(14, "14", 106368585), new Chromosome(15, "15", 100338915), new Chromosome(16, "16", 88827254), new Chromosome(17, "17", 78774742), new Chromosome(18, "18", 76117153), new Chromosome(19, "19", 63811651), new Chromosome(20, "20", 62435964), new Chromosome(21, "21", 46944323), new Chromosome(22, "22", 49691432), new Chromosome(23, "23", 154913754), new Chromosome(24, "24", 57772954), new Chromosome(25, "0", 16571)};
        b37Chromosomes = new Chromosome[]{null, new Chromosome(1, "1", 249250621), new Chromosome(2, "2", 243199373), new Chromosome(3, "3", 198022430), new Chromosome(4, "4", 191154276), new Chromosome(5, "5", 180915260), new Chromosome(6, "6", 171115067), new Chromosome(7, "7", 159138663), new Chromosome(8, "8", 146364022), new Chromosome(9, "9", 141213431), new Chromosome(10, "10", 135534747), new Chromosome(11, "11", 135006516), new Chromosome(12, "12", 133851895), new Chromosome(13, "13", 115169878), new Chromosome(14, "14", 107349540), new Chromosome(15, "15", 102531392), new Chromosome(16, "16", 90354753), new Chromosome(17, "17", 81195210), new Chromosome(18, "18", 78077248), new Chromosome(19, "19", 59128983), new Chromosome(20, "20", 63025520), new Chromosome(21, "21", 48129895), new Chromosome(22, "22", 51304566), new Chromosome(23, "X", 155270560), new Chromosome(24, "Y", 59373566)};
    }
}

