/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.seg;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.data.CharArrayList;

public class SegmentedChromosomeData {
    private static Logger log = Logger.getLogger(SegmentedChromosomeData.class);
    private String[] sampleNames;
    Map<String, int[]> startLocations;
    Map<String, int[]> endLocations;
    Map<String, float[]> valueMap;

    public SegmentedChromosomeData() {
    }

    public SegmentedChromosomeData(String[] sampleNames, Map<String, int[]> startLocations, Map<String, int[]> endLocations, Map<String, float[]> valueMap) {
        this.sampleNames = sampleNames;
        this.startLocations = startLocations;
        this.endLocations = endLocations;
        this.valueMap = valueMap;
    }

    public void serialize(OutputStream stream) {
        try {
            DataOutputStream os = new DataOutputStream(new BufferedOutputStream(stream));
            for (String sample : this.getSampleNames()) {
                os.writeChars(sample);
                os.writeChar(9);
            }
            os.writeChar(10);
            for (String sample : this.getSampleNames()) {
                int i2;
                int[] starts = this.startLocations.get(sample);
                int[] ends = this.endLocations.get(sample);
                float[] values = this.valueMap.get(sample);
                int nPts = starts.length;
                assert (ends.length == nPts);
                assert (values.length == nPts);
                os.writeInt(nPts);
                for (i2 = 0; i2 < nPts; ++i2) {
                    os.writeInt(starts[i2]);
                }
                for (i2 = 0; i2 < nPts; ++i2) {
                    os.writeInt(ends[i2]);
                }
                for (i2 = 0; i2 < nPts; ++i2) {
                    os.writeFloat(values[i2]);
                }
            }
            os.flush();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public void deserialize(InputStream stream) {
        this.startLocations = new HashMap<String, int[]>();
        this.endLocations = new HashMap<String, int[]>();
        this.valueMap = new HashMap<String, float[]>();
        try {
            DataInputStream is = new DataInputStream(new BufferedInputStream(stream));
            ArrayList<String> tmp = new ArrayList<String>(100);
            char c2 = '\u0000';
            try {
                c2 = is.readChar();
            }
            catch (EOFException e2) {
                return;
            }
            while (c2 != '\n') {
                CharArrayList chars = new CharArrayList(10);
                while (c2 != '\t') {
                    chars.add(c2);
                    c2 = is.readChar();
                }
                String nm = new String(chars.toArray()).trim();
                tmp.add(nm);
                c2 = is.readChar();
            }
            for (String sample : this.sampleNames = tmp.toArray(new String[0])) {
                int nPts = is.readInt();
                int[] starts = new int[nPts];
                for (int i2 = 0; i2 < nPts; ++i2) {
                    starts[i2] = is.readInt();
                }
                int[] ends = new int[nPts];
                for (int i3 = 0; i3 < nPts; ++i3) {
                    ends[i3] = is.readInt();
                }
                float[] values = new float[nPts];
                for (int i4 = 0; i4 < nPts; ++i4) {
                    values[i4] = is.readFloat();
                }
                this.startLocations.put(sample, starts);
                this.endLocations.put(sample, ends);
                this.valueMap.put(sample, values);
            }
        }
        catch (IOException e3) {
            log.error("Error loading segmented data", e3);
        }
    }

    public String[] getSampleNames() {
        return this.sampleNames;
    }

    public int[] getStartLocations(String sampleName) {
        return this.startLocations.get(sampleName);
    }

    public int[] getEndLocations(String sampleName) {
        return this.endLocations.get(sampleName);
    }

    public float[] getValues(String sampleName) {
        return this.valueMap.get(sampleName);
    }
}

