/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.batch;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;
import java.nio.channels.ClosedByInterruptException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.batch.CommandExecutor;
import org.broad.igv.ui.IGV;

public class CommandListener
implements Runnable {
    private static Logger log = Logger.getLogger(CommandListener.class);
    private static CommandListener listener;
    private int port = -1;
    private ServerSocket serverSocket = null;
    private Socket clientSocket = null;
    private Thread listenerThread;
    boolean halt = false;

    public static synchronized void start(int port) {
        listener = new CommandListener(port);
        CommandListener.listener.listenerThread.start();
    }

    public static synchronized void halt() {
        if (listener != null) {
            CommandListener.listener.halt = true;
            CommandListener.listener.listenerThread.interrupt();
            listener.closeSockets();
            listener = null;
        }
    }

    private CommandListener(int port) {
        this.port = port;
        this.listenerThread = new Thread(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CommandExecutor cmdExe = new CommandExecutor();
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            this.serverSocket = new ServerSocket(this.port);
            log.info("Listening on port " + this.port);
            this.clientSocket = this.serverSocket.accept();
            out = new PrintWriter(this.clientSocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
            while (!this.halt) {
                String inputLine;
                while (!this.halt && (inputLine = in.readLine()) != null) {
                    String cmd = inputLine;
                    if (cmd.startsWith("GET")) {
                        String result = this.processGet(cmd, in, cmdExe);
                        this.sendHTTPResponse(out, result);
                        out.close();
                        in.close();
                        this.clientSocket.close();
                        this.clientSocket = this.serverSocket.accept();
                        out = new PrintWriter(this.clientSocket.getOutputStream(), true);
                        in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
                        continue;
                    }
                    try {
                        Globals.setBatch(true);
                        Globals.setSuppressMessages(true);
                        out.println(cmdExe.execute(inputLine));
                    }
                    finally {
                        Globals.setSuppressMessages(false);
                        Globals.setBatch(false);
                    }
                }
                this.closeSockets();
            }
        }
        catch (BindException e2) {
            log.error(e2);
        }
        catch (ClosedByInterruptException e3) {
        }
        catch (IOException e4) {
            if (!this.halt) {
                log.error("IO Error on port socket ", e4);
            }
        }
        catch (Exception e5) {
            e5.printStackTrace();
        }
        finally {
            Globals.setSuppressMessages(false);
            Globals.setBatch(false);
            this.closeSockets();
        }
    }

    private void closeSockets() {
        if (this.clientSocket != null) {
            try {
                this.clientSocket.close();
                this.clientSocket = null;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
                this.serverSocket = null;
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
    }

    private void sendHTTPResponse(PrintWriter out, String result) {
        out.println("HTTP/1.0 204 OK");
        out.println(" Server: IGV");
        out.println("Connection: close");
        out.println();
        out.println(result);
        out.println();
        out.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String processGet(String line, BufferedReader reader, CommandExecutor cmdExe) throws IOException {
        String nextLine = line;
        String result = "OK";
        String[] tokens = nextLine.split(" ");
        if (tokens.length < 2) {
            return "ERROR unexpected command line: " + line;
        }
        String[] parts = tokens[1].split("\\?");
        if (parts.length < 2) {
            return "ERROR unexpected command line: " + line;
        }
        String command = parts[0];
        Map<String, String> params = this.parseParameters(parts[1]);
        Frame mainFrame = IGV.getMainFrame();
        mainFrame.toFront();
        mainFrame.setAlwaysOnTop(true);
        mainFrame.setAlwaysOnTop(false);
        if (command.equals("/load")) {
            if (!params.containsKey("file")) return "ERROR Parameter \"file\" is required";
            String genomeID = params.get("genome");
            String mergeValue = params.get("merge");
            String locus = params.get("locus");
            if (genomeID != null) {
                IGV.getFirstInstance().selectGenomeFromList(genomeID);
            }
            boolean merge = mergeValue == null ? true : mergeValue.equalsIgnoreCase("true");
            result = cmdExe.execute("hget " + params.get("file") + " " + locus + " " + merge);
        } else {
            if (!command.equals("/reload") && !command.equals("/goto")) return "ERROR Unknown command: " + command;
            String locus = params.get("locus");
            IGV.getFirstInstance().goToLocus(locus);
        }
        while (nextLine != null && nextLine.length() > 0) {
            nextLine = reader.readLine();
        }
        return result;
    }

    private Map<String, String> parseParameters(String parameterString) {
        String[] kvPairs;
        HashMap<String, String> params = new HashMap<String, String>();
        for (String kvString : kvPairs = parameterString.split("&")) {
            String[] kv = kvString.split("=");
            if (kv.length == 1) {
                params.put(kv[0], null);
                continue;
            }
            String key = kv[0];
            String value = key.equals("locus") ? kv[1] : URLDecoder.decode(kv[1]);
            params.put(kv[0], value);
        }
        return params;
    }
}

