/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Map;

public class ColorScale {
    Map<Integer, Color> colorCache = new Hashtable<Integer, Color>();
    int minCount = 0;
    int maxCount = 200;
    Color background;

    public Color getColor(double score) {
        if (score < (double)this.minCount) {
            return this.background;
        }
        float alpha = (float)Math.max((double)0.05f, Math.min(1.0, score / (double)this.maxCount));
        float[] comps = this.background.getColorComponents(null);
        int idx = (int)(100.0f * alpha);
        Color c2 = this.colorCache.get(idx);
        if (c2 == null) {
            float rAlpha = Math.max(0.05f, Math.min(1.0f, 0.01f * (float)idx));
            float red = (1.0f - rAlpha) * comps[0] + rAlpha;
            float green = (1.0f - rAlpha) * comps[1];
            float blue = (1.0f - rAlpha) * comps[2];
            c2 = new Color(red, green, blue);
            this.colorCache.put(idx, c2);
        }
        return c2;
    }
}

