/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealSolver;
import org.apache.commons.math.analysis.UnivariateRealSolverFactory;

public class UnivariateRealSolverUtils {
    private static UnivariateRealSolverFactory factory = null;

    private UnivariateRealSolverUtils() {
    }

    public static double solve(UnivariateRealFunction f2, double x0, double x1) throws ConvergenceException, FunctionEvaluationException {
        UnivariateRealSolverUtils.setup(f2);
        return factory.newDefaultSolver(f2).solve(x0, x1);
    }

    public static double solve(UnivariateRealFunction f2, double x0, double x1, double absoluteAccuracy) throws ConvergenceException, FunctionEvaluationException {
        UnivariateRealSolverUtils.setup(f2);
        UnivariateRealSolver solver = factory.newDefaultSolver(f2);
        solver.setAbsoluteAccuracy(absoluteAccuracy);
        return solver.solve(x0, x1);
    }

    public static double[] bracket(UnivariateRealFunction function, double initial, double lowerBound, double upperBound) throws ConvergenceException, FunctionEvaluationException {
        return UnivariateRealSolverUtils.bracket(function, initial, lowerBound, upperBound, Integer.MAX_VALUE);
    }

    public static double[] bracket(UnivariateRealFunction function, double initial, double lowerBound, double upperBound, int maximumIterations) throws ConvergenceException, FunctionEvaluationException {
        double fb;
        double fa;
        if (function == null) {
            throw new IllegalArgumentException("function is null.");
        }
        if (maximumIterations <= 0) {
            throw new IllegalArgumentException("bad value for maximumIterations: " + maximumIterations);
        }
        if (initial < lowerBound || initial > upperBound || lowerBound >= upperBound) {
            throw new IllegalArgumentException("Invalid endpoint parameters:  lowerBound=" + lowerBound + " initial=" + initial + " upperBound=" + upperBound);
        }
        double a2 = initial;
        double b2 = initial;
        int numIterations = 0;
        do {
            a2 = Math.max(a2 - 1.0, lowerBound);
            b2 = Math.min(b2 + 1.0, upperBound);
        } while ((fa = function.value(a2)) * (fb = function.value(b2)) > 0.0 && ++numIterations < maximumIterations && (a2 > lowerBound || b2 < upperBound));
        if (fa * fb >= 0.0) {
            throw new ConvergenceException("Number of iterations= " + numIterations + " maximum iterations= " + maximumIterations + " initial= " + initial + " lowerBound=" + lowerBound + " upperBound=" + upperBound + " final a value=" + a2 + " final b value=" + b2 + " f(a)=" + fa + " f(b)=" + fb);
        }
        return new double[]{a2, b2};
    }

    public static double midpoint(double a2, double b2) {
        return (a2 + b2) * 0.5;
    }

    private static void setup(UnivariateRealFunction f2) {
        if (f2 == null) {
            throw new IllegalArgumentException("function can not be null.");
        }
        if (factory == null) {
            factory = UnivariateRealSolverFactory.newInstance();
        }
    }
}

