/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis;

import java.io.Serializable;
import org.apache.commons.math.analysis.DifferentiableUnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealFunction;

public class PolynomialFunction
implements DifferentiableUnivariateRealFunction,
Serializable {
    private static final long serialVersionUID = 3322454535052136809L;
    private double[] coefficients;

    public PolynomialFunction(double[] c2) {
        if (c2.length < 1) {
            throw new IllegalArgumentException("Polynomial coefficient array must have postive length.");
        }
        this.coefficients = new double[c2.length];
        System.arraycopy(c2, 0, this.coefficients, 0, c2.length);
    }

    public double value(double x) {
        return PolynomialFunction.evaluate(this.coefficients, x);
    }

    public int degree() {
        return this.coefficients.length - 1;
    }

    public double[] getCoefficients() {
        double[] out = new double[this.coefficients.length];
        System.arraycopy(this.coefficients, 0, out, 0, this.coefficients.length);
        return out;
    }

    protected static double evaluate(double[] coefficients, double argument) {
        int n2 = coefficients.length;
        if (n2 < 1) {
            throw new IllegalArgumentException("Coefficient array must have positive length for evaluation");
        }
        double result = coefficients[n2 - 1];
        int j2 = n2 - 2;
        while (j2 >= 0) {
            result = argument * result + coefficients[j2];
            --j2;
        }
        return result;
    }

    protected static double[] differentiate(double[] coefficients) {
        int n2 = coefficients.length;
        if (n2 < 1) {
            throw new IllegalArgumentException("Coefficient array must have positive length for differentiation");
        }
        if (n2 == 1) {
            return new double[]{0.0};
        }
        double[] result = new double[n2 - 1];
        int i2 = n2 - 1;
        while (i2 > 0) {
            result[i2 - 1] = (double)i2 * coefficients[i2];
            --i2;
        }
        return result;
    }

    public PolynomialFunction polynomialDerivative() {
        return new PolynomialFunction(PolynomialFunction.differentiate(this.coefficients));
    }

    public UnivariateRealFunction derivative() {
        return this.polynomialDerivative();
    }
}

