/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGGElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGTests;

public class SVGSwitchElementBridge
extends SVGGElementBridge {
    protected Element selectedChild;

    public String getLocalName() {
        return "switch";
    }

    public Bridge getInstance() {
        return new SVGSwitchElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext ctx, Element e2) {
        GraphicsNode refNode = null;
        GVTBuilder builder = ctx.getGVTBuilder();
        this.selectedChild = null;
        Node n2 = e2.getFirstChild();
        while (n2 != null) {
            if (n2.getNodeType() == 1) {
                Element ref = (Element)n2;
                if (n2 instanceof SVGTests && SVGUtilities.matchUserAgent(ref, ctx.getUserAgent())) {
                    this.selectedChild = ref;
                    refNode = builder.build(ctx, ref);
                    break;
                }
            }
            n2 = n2.getNextSibling();
        }
        if (refNode == null) {
            return null;
        }
        CompositeGraphicsNode group = (CompositeGraphicsNode)super.createGraphicsNode(ctx, e2);
        if (group == null) {
            return null;
        }
        group.add(refNode);
        return group;
    }

    public boolean isComposite() {
        return false;
    }

    public void dispose() {
        this.selectedChild = null;
        super.dispose();
    }

    protected void handleElementAdded(CompositeGraphicsNode gn, Node parent, Element childElt) {
        Node n2 = childElt.getPreviousSibling();
        while (n2 != null) {
            if (n2 == childElt) {
                return;
            }
            n2 = n2.getPreviousSibling();
        }
        if (childElt instanceof SVGTests && SVGUtilities.matchUserAgent(childElt, this.ctx.getUserAgent())) {
            if (this.selectedChild != null) {
                gn.remove(0);
                this.disposeTree(this.selectedChild);
            }
            this.selectedChild = childElt;
            GVTBuilder builder = this.ctx.getGVTBuilder();
            GraphicsNode refNode = builder.build(this.ctx, childElt);
            if (refNode != null) {
                gn.add(refNode);
            }
        }
    }

    protected void handleChildElementRemoved(Element e2) {
        CompositeGraphicsNode gn = (CompositeGraphicsNode)this.node;
        if (this.selectedChild == e2) {
            gn.remove(0);
            this.disposeTree(this.selectedChild);
            this.selectedChild = null;
            GraphicsNode refNode = null;
            GVTBuilder builder = this.ctx.getGVTBuilder();
            Node n2 = e2.getNextSibling();
            while (n2 != null) {
                if (n2.getNodeType() == 1) {
                    Element ref = (Element)n2;
                    if (n2 instanceof SVGTests && SVGUtilities.matchUserAgent(ref, this.ctx.getUserAgent())) {
                        refNode = builder.build(this.ctx, ref);
                        this.selectedChild = ref;
                        break;
                    }
                }
                n2 = n2.getNextSibling();
            }
            if (refNode != null) {
                gn.add(refNode);
            }
        }
    }
}

