/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.io;

import it.unimi.dsi.fastutil.io.MeasurableInputStream;
import it.unimi.dsi.fastutil.io.RepositionableStream;

public class FastByteArrayInputStream
extends MeasurableInputStream
implements RepositionableStream {
    public byte[] array;
    public int offset;
    public int length;
    private int position;
    private int mark;

    public FastByteArrayInputStream(byte[] array, int offset, int length) {
        this.array = array;
        this.offset = offset;
        this.length = length;
    }

    public FastByteArrayInputStream(byte[] array) {
        this(array, 0, array.length);
    }

    public boolean markSupported() {
        return true;
    }

    public void reset() {
        this.position = this.mark;
    }

    public void close() {
    }

    public void mark(int dummy) {
        this.mark = this.position;
    }

    public int available() {
        return this.length - this.position;
    }

    public long skip(long n2) {
        if (n2 <= (long)(this.length - this.position)) {
            this.position += (int)n2;
            return n2;
        }
        n2 = this.length - this.position;
        this.position = this.length;
        return n2;
    }

    public int read() {
        if (this.length == this.position) {
            return -1;
        }
        return this.array[this.offset + this.position++] & 0xFF;
    }

    public int read(byte[] b2, int offset, int length) {
        if (this.length == this.position) {
            return length == 0 ? 0 : -1;
        }
        int n2 = Math.min(length, this.length - this.position);
        System.arraycopy(this.array, this.offset + this.position, b2, offset, n2);
        this.position += n2;
        return n2;
    }

    public long position() {
        return this.position;
    }

    public void position(long newPosition) {
        this.position = (int)Math.min(newPosition, (long)this.length);
    }

    public long length() {
        return this.length;
    }
}

