/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.reads;

import com.google.protobuf.GeneratedMessage;
import edu.cornell.med.icb.goby.exception.GobyRuntimeException;
import edu.cornell.med.icb.goby.reads.MessageChunksReader;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.commons.io.IOUtils;

public class FastBufferedMessageChunksReader
extends MessageChunksReader {
    private final long end;
    private FastBufferedInputStream input;

    public FastBufferedMessageChunksReader(long start, long end, FastBufferedInputStream input) throws IOException {
        if (start < 0L) {
            throw new IllegalArgumentException("Start position (" + start + ") must not be less than zero");
        }
        if (end != Long.MAX_VALUE && end < 0L) {
            throw new IllegalArgumentException("End position (" + end + ") must not be less than zero");
        }
        if (start > end) {
            throw new IllegalArgumentException("Start position (" + start + ") must not be greater than the end position (" + end + ")");
        }
        if (end != Long.MAX_VALUE && start != end) {
            end += 12L;
        }
        this.end = end;
        this.input = input;
        this.reposition(start, end);
    }

    private void reposition(long start, long end) throws IOException {
        int b2;
        this.input.position(start);
        int contiguousZeroBytes = 0;
        long skipped = 0L;
        long position = 0L;
        while (position < end && (b2 = this.input.read()) != -1) {
            contiguousZeroBytes = b2 == 255 ? ++contiguousZeroBytes : 0;
            ++skipped;
            if (contiguousZeroBytes == 8) {
                this.in = new DataInputStream(this.input);
                long seekPosition = start + skipped - (long)contiguousZeroBytes;
                this.input.position(seekPosition);
                break;
            }
            position = start + skipped;
        }
    }

    public void seek(long position) throws IOException {
        this.reposition(position, Long.MAX_VALUE);
    }

    @Override
    public boolean hasNext(GeneratedMessage collection, int collectionSize) {
        if (collection == null || this.entryIndex >= collectionSize) {
            if (this.input != null) {
                try {
                    if (this.input.position() >= this.end) {
                        return false;
                    }
                }
                catch (IOException e2) {
                    throw new GobyRuntimeException(e2);
                }
            }
            return this.in != null && super.hasNext(collection, collectionSize);
        }
        this.uncompressStream = null;
        return this.entryIndex < collectionSize;
    }

    @Override
    public void close() {
        super.close();
        IOUtils.closeQuietly(this.input);
    }

    public long position() throws IOException {
        return this.input.position();
    }
}

