/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.basic.BasicBorders;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.gs.GSOpenSessionMenuAction;
import org.broad.igv.gs.GSSaveSessionMenuAction;
import org.broad.igv.gs.GSUtils;
import org.broad.igv.lists.GeneListManagerUI;
import org.broad.igv.lists.VariantListManager;
import org.broad.igv.tools.IgvToolsGui;
import org.broad.igv.ui.AboutDialog;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.ClearRegionsMenuAction;
import org.broad.igv.ui.action.ExportRegionsMenuAction;
import org.broad.igv.ui.action.ExportTrackNamesMenuAction;
import org.broad.igv.ui.action.FilterTracksMenuAction;
import org.broad.igv.ui.action.FitDataToWindowMenuAction;
import org.broad.igv.ui.action.GroupTracksMenuAction;
import org.broad.igv.ui.action.ImportRegionsMenuAction;
import org.broad.igv.ui.action.LoadFilesMenuAction;
import org.broad.igv.ui.action.LoadFromGSMenuAction;
import org.broad.igv.ui.action.LoadFromServerAction;
import org.broad.igv.ui.action.LoadFromURLMenuAction;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.action.NavigateRegionsMenuAction;
import org.broad.igv.ui.action.NewSessionMenuAction;
import org.broad.igv.ui.action.OpenSessionMenuAction;
import org.broad.igv.ui.action.RemoveUserDefinedGenomeMenuAction;
import org.broad.igv.ui.action.ResetPreferencesAction;
import org.broad.igv.ui.action.RunScriptMenuAction;
import org.broad.igv.ui.action.SaveSessionMenuAction;
import org.broad.igv.ui.action.SetTrackHeightMenuAction;
import org.broad.igv.ui.action.SortTracksMenuAction;
import org.broad.igv.ui.legend.LegendDialog;
import org.broad.igv.ui.panel.MainPanel;
import org.broad.igv.ui.panel.ReorderPanelsDialog;
import org.broad.igv.ui.util.HistoryMenu;
import org.broad.igv.ui.util.MenuAndToolbarUtils;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.BrowserLauncher;

public class IGVMenuBar
extends JMenuBar {
    private static Logger log = Logger.getLogger(IGVMenuBar.class);
    private JMenu extrasMenu;
    private RemoveUserDefinedGenomeMenuAction removeImportedGenomeAction;
    private FilterTracksMenuAction filterTracksAction;
    private JMenu viewMenu;

    public IGVMenuBar() {
        this.setBorder(new BasicBorders.MenuBarBorder(Color.GRAY, Color.GRAY));
        this.setBorderPainted(true);
        for (AbstractButton menu : this.createMenus()) {
            this.add(menu);
        }
    }

    private List<AbstractButton> createMenus() {
        ArrayList<AbstractButton> menus = new ArrayList<AbstractButton>();
        menus.add(this.createFileMenu());
        menus.add(this.createViewMenu());
        menus.add(this.createTracksMenu());
        menus.add(this.createGenomeSpaceMenu());
        this.extrasMenu = this.createExtrasMenu();
        menus.add(this.extrasMenu);
        menus.add(this.createHelpMenu());
        return menus;
    }

    public void enableExtrasMenu() {
        this.extrasMenu.setVisible(true);
    }

    private JMenu createFileMenu() {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuItems.add(new JSeparator());
        menuAction = new LoadFilesMenuAction("Load from File...", 76, IGV.getInstance());
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new LoadFromURLMenuAction("Load from URL...", 85, IGV.getInstance());
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new LoadFromServerAction("Load from Server...", 83, IGV.getInstance());
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new LoadFromURLMenuAction("Load from DAS...", 68, IGV.getInstance());
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new NewSessionMenuAction("New Session...", 78, IGV.getInstance());
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new OpenSessionMenuAction("Open Session...", 79, IGV.getInstance());
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new SaveSessionMenuAction("Save Session...", 86, IGV.getInstance());
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Load Genome...", null, 73){

            @Override
            public void actionPerformed(ActionEvent event) {
                SwingWorker worker = new SwingWorker(){

                    public Object doInBackground() {
                        ProgressMonitor monitor = new ProgressMonitor();
                        IGV.getInstance().doLoadGenome(monitor);
                        return null;
                    }
                };
                worker.execute();
            }
        };
        menuAction.setToolTipText("Load a previously created \".genome\" file");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Import Genome...", null, 68){

            @Override
            public void actionPerformed(ActionEvent event) {
                SwingWorker worker = new SwingWorker(){

                    public Object doInBackground() {
                        ProgressMonitor monitor = new ProgressMonitor();
                        IGV.getInstance().doDefineGenome(monitor);
                        return null;
                    }
                };
                worker.execute();
            }
        };
        menuAction.setToolTipText("Define a user-defined genome");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        boolean hasImportedGenomes = true;
        try {
            hasImportedGenomes = !IGV.getInstance().getGenomeManager().getUserDefinedGenomeArchiveList().isEmpty();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.removeImportedGenomeAction = new RemoveUserDefinedGenomeMenuAction("Remove Imported Genomes...", 82);
        this.removeImportedGenomeAction.setEnabled(hasImportedGenomes);
        menuItems.add(MenuAndToolbarUtils.createMenuItem(this.removeImportedGenomeAction));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Save Image ...", null, 65){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IGV.getInstance().saveImage(IGV.getInstance().getMainPanel());
            }
        };
        menuAction.setToolTipText("Capture and save an image");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new ExportRegionsMenuAction("Export Regions ...", 69, IGV.getInstance());
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new ImportRegionsMenuAction("Import Regions ...", 73, IGV.getInstance());
        menuAction.setToolTipText("Allows previously exported regions to be reloaded");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new ClearRegionsMenuAction("Clear Regions ...", IGV.getInstance());
        menuAction.setToolTipText("Allows previously exported regions to be reloaded");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new RunScriptMenuAction("Run Batch Script...", 88, IGV.getInstance());
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new SortTracksMenuAction("Run igvtools...", 84, IGV.getInstance()){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IgvToolsGui.launch(false, IGV.getInstance().getGenomeManager().getGenomeId());
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Exit", null, 88){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IGVMenuBar.this.doExitApplication();
            }
        };
        menuAction.setToolTipText("Exit the application");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        IGV.getInstance().getRecentSessionList().clear();
        String recentSessions = PreferenceManager.getInstance().getRecentSessions();
        if (recentSessions != null) {
            String[] sessions;
            for (String sessionPath : sessions = recentSessions.split(";")) {
                if (IGV.getInstance().getRecentSessionList().contains(sessionPath)) continue;
                IGV.getInstance().getRecentSessionList().add(sessionPath);
            }
        }
        if (!IGV.getInstance().getRecentSessionList().isEmpty()) {
            menuItems.add(new JSeparator());
            for (String session : IGV.getInstance().getRecentSessionList()) {
                OpenSessionMenuAction osMenuAction = new OpenSessionMenuAction(session, new File(session), IGV.getInstance());
                menuItems.add(MenuAndToolbarUtils.createMenuItem(osMenuAction));
            }
        }
        MenuAction fileMenuAction = new MenuAction("File", null, 70);
        return MenuAndToolbarUtils.createMenu(menuItems, fileMenuAction);
    }

    private JMenu createTracksMenu() {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuAction = new SortTracksMenuAction("Sort Tracks ...", 83, IGV.getInstance());
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new GroupTracksMenuAction("Group Tracks  ... ", 71, IGV.getInstance());
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        this.filterTracksAction = new FilterTracksMenuAction("Filter Tracks ...", 70, IGV.getInstance());
        menuItems.add(MenuAndToolbarUtils.createMenuItem(this.filterTracksAction));
        menuItems.add(new JSeparator());
        menuAction = new FitDataToWindowMenuAction("Fit Data to Window", 87, IGV.getInstance());
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new SetTrackHeightMenuAction("Set Track Height...", 72, IGV.getInstance());
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        MenuAction dataMenuAction = new MenuAction("Tracks", null, 75);
        return MenuAndToolbarUtils.createMenu(menuItems, dataMenuAction);
    }

    private JMenu createViewMenu() {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuAction = new MenuAction("Preferences...", null, 80){

            @Override
            public void actionPerformed(ActionEvent e2) {
                UIUtilities.invokeOnEventThread(new Runnable(){

                    @Override
                    public void run() {
                        IGV.getInstance().doViewPreferences();
                    }
                });
            }
        };
        menuAction.setToolTipText("Set user specific preferences");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Color Legends ...", null, 72){

            @Override
            public void actionPerformed(ActionEvent e2) {
                new LegendDialog(IGV.getMainFrame()).setVisible(true);
            }
        };
        menuAction.setToolTipText("IGVPanel or edit color legends and scales");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Show Name Panel", null, 65){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)e2.getSource();
                if (menuItem.isSelected()) {
                    IGV.getInstance().getMainPanel().expandNamePanel();
                } else {
                    IGV.getInstance().getMainPanel().collapseNamePanel();
                }
                IGV.getInstance().doRefresh();
            }
        };
        boolean isShowing = IGV.getInstance().getMainPanel().isExpanded();
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem();
        menuItem.setSelected(isShowing);
        menuItem.setAction(menuAction);
        menuItems.add(menuItem);
        JMenuItem panelWidthmenuItem = new JMenuItem();
        menuAction = new MenuAction("Set Name Panel Width...", null, 65){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MainPanel mainPanel = IGV.getInstance().getMainPanel();
                String currentValue = String.valueOf(mainPanel.getNamePanelWidth());
                String newValue = MessageUtils.showInputDialog("Enter track name panel width: ", currentValue);
                if (newValue != null) {
                    try {
                        Integer w = Integer.parseInt(newValue);
                        if (w <= 0 || w == 1000) {
                            throw new NumberFormatException();
                        }
                        PreferenceManager.getInstance().put("NAME_PANEL_WIDTH", newValue);
                        mainPanel.setNamePanelWidth(w);
                    }
                    catch (NumberFormatException ex) {
                        MessageUtils.showMessage("Error: value must be a positive integer < 1000.");
                    }
                }
            }
        };
        panelWidthmenuItem.setAction(menuAction);
        menuItems.add(panelWidthmenuItem);
        boolean isShow = PreferenceManager.getInstance().getAsBoolean("IGV.track.show.attribute.views");
        IGV.getInstance().doShowAttributeDisplay(isShow);
        menuAction = new MenuAction("Show Attribute Display", null, 65){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)e2.getSource();
                PreferenceManager.getInstance().setShowAttributeView(menuItem.getState());
                IGV.getInstance().getMainPanel().invalidate();
                IGV.getInstance().doRefresh();
            }
        };
        menuAction.setToolTipText("Show or hide the attribute display");
        menuItem = MenuAndToolbarUtils.createMenuItem(menuAction, isShow);
        menuItems.add(menuItem);
        menuAction = new MenuAction("Select Attributes to Show...", null, 83){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IGV.getInstance().doSelectDisplayableAttribute();
            }
        };
        menuAction.setToolTipText("Customize attribute display to show only checked attributes");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Show Header Panel", null, 65){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)e2.getSource();
                if (menuItem.isSelected()) {
                    IGV.getInstance().getMainPanel().restoreHeader();
                } else {
                    IGV.getInstance().getMainPanel().removeHeader();
                }
                IGV.getInstance().doRefresh();
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction, true));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Reorder Panels...", null, 83){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ReorderPanelsDialog dlg = new ReorderPanelsDialog(IGV.getMainFrame());
                dlg.setVisible(true);
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Gene Lists...", null, 83){

            @Override
            public void actionPerformed(ActionEvent e2) {
                new GeneListManagerUI(IGV.getMainFrame()).setVisible(true);
            }
        };
        menuAction.setToolTipText("Customize attribute display to show only checked attributes");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new NavigateRegionsMenuAction("Region Navigator ...", IGV.getInstance());
        menuAction.setToolTipText("Navigate regions");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuItems.add(new HistoryMenu("Go to"));
        MenuAction dataMenuAction = new MenuAction("View", null, 86);
        this.viewMenu = MenuAndToolbarUtils.createMenu(menuItems, dataMenuAction);
        return this.viewMenu;
    }

    private JMenu createHelpMenu() {
        Desktop desktop;
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuAction = new MenuAction("User Guide ... "){

            @Override
            public void actionPerformed(ActionEvent e2) {
                try {
                    BrowserLauncher.openURL("http://www.broadinstitute.org/igv/UserGuide");
                }
                catch (IOException ex) {
                    log.error("Error opening browser", ex);
                }
            }
        };
        menuAction.setToolTipText("Open web help page");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Tutorial ... "){

            @Override
            public void actionPerformed(ActionEvent e2) {
                try {
                    BrowserLauncher.openURL("http://www.broadinstitute.org/igv/QuickStart");
                }
                catch (IOException ex) {
                    log.error("Error opening browser", ex);
                }
            }
        };
        menuAction.setToolTipText("Open tutorial web page");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.MAIL)) {
            menuAction = new MenuAction("Help Forum..."){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    try {
                        URI uri = new URI("http://groups.google.com/forum/#!forum/igv-help");
                        Desktop.getDesktop().browse(uri);
                    }
                    catch (Exception ex) {
                        log.error("Error opening igv-help uri", ex);
                    }
                }
            };
            menuAction.setToolTipText("Email support");
            menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        }
        menuAction = new MenuAction("About IGV "){

            @Override
            public void actionPerformed(ActionEvent e2) {
                new AboutDialog(IGV.getMainFrame(), true).setVisible(true);
            }
        };
        menuAction.setToolTipText("Display application information");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        MenuAction toolMenuAction = new MenuAction("Help");
        return MenuAndToolbarUtils.createMenu(menuItems, toolMenuAction);
    }

    private JMenu createGenomeSpaceMenu() {
        JMenu menu = new JMenu("GenomeSpace");
        MenuAction menuAction = null;
        menuAction = new LoadFromGSMenuAction("Load from GenomeSpace...", 85, IGV.getInstance());
        menu.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menu.addSeparator();
        menuAction = new GSSaveSessionMenuAction("Save session to GenomeSpace...", IGV.getInstance());
        menu.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new GSOpenSessionMenuAction("Load session from GenomeSpace...", IGV.getInstance());
        menu.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menu.add(new JSeparator());
        menuAction = new MenuAction("Logout"){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GSUtils.logout();
            }
        };
        menu.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menu.setVisible(PreferenceManager.getInstance().getAsBoolean("GENOME_SPACE_ENABLE"));
        return menu;
    }

    private JMenu createExtrasMenu() {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuAction = new LoadFromGSMenuAction("Load from GenomeSpace...", 85, IGV.getInstance());
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new ResetPreferencesAction("Reset Preferences", IGV.getInstance());
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Variant list ...  *EXPERIMENTAL*"){

            @Override
            public void actionPerformed(ActionEvent e2) {
                VariantListManager.openNavigator(IGV.getMainFrame());
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Set window dimensions", null, 67){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String value = JOptionPane.showInputDialog("Enter dimensions, e.g. 800x400");
                String[] vals = value.split("x");
                if (vals.length == 2) {
                    int w = Integer.parseInt(vals[0]);
                    int h2 = Integer.parseInt(vals[1]);
                    IGV.getMainFrame().setSize(w, h2);
                }
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Save Screenshot ...", null, 65){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IGV.getInstance().saveImage(IGV.getInstance().getContentPane());
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        JMenu lfMenu = new JMenu("L&F");
        LookAndFeel lf = UIManager.getLookAndFeel();
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            final String lfName = info.getName();
            JMenuItem cb = new JMenuItem(lfName);
            cb.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        if (!lfName.equals(info.getName())) continue;
                        try {
                            UIManager.setLookAndFeel(info.getClassName());
                        }
                        catch (ClassNotFoundException e2) {
                            e2.printStackTrace();
                        }
                        catch (InstantiationException e3) {
                            e3.printStackTrace();
                        }
                        catch (IllegalAccessException e4) {
                            e4.printStackTrace();
                        }
                        catch (UnsupportedLookAndFeelException e5) {
                            e5.printStackTrace();
                        }
                        break;
                    }
                }
            });
            lfMenu.add(cb);
        }
        menuAction = new ExportTrackNamesMenuAction("Export track names...", IGV.getInstance());
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        MenuAction extrasMenuAction = new MenuAction("Extras");
        JMenu menu = MenuAndToolbarUtils.createMenu(menuItems, extrasMenuAction);
        menu.add(lfMenu);
        menu.setVisible(false);
        return menu;
    }

    public void enableRemoveGenomes() {
        if (this.removeImportedGenomeAction != null) {
            this.removeImportedGenomeAction.setEnabled(true);
        }
    }

    public void resetSessionActions() {
        if (this.filterTracksAction != null) {
            this.filterTracksAction.resetTrackFilter();
        }
    }

    public void setFilterMatchAll(boolean value) {
        if (this.filterTracksAction != null) {
            this.filterTracksAction.setFilterMatchAll(value);
        }
    }

    public boolean isFilterMatchAll() {
        if (this.filterTracksAction != null) {
            return this.filterTracksAction.isFilterMatchAll();
        }
        return false;
    }

    public void setFilterShowAllTracks(boolean value) {
        if (this.filterTracksAction != null) {
            this.filterTracksAction.setFilterShowAllTracks(value);
        }
    }

    public boolean isFilterShowAllTracks() {
        if (this.filterTracksAction != null) {
            return this.filterTracksAction.getShowAllTracksFilterCheckBox().isSelected();
        }
        return false;
    }

    public JMenu getViewMenu() {
        return this.viewMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doExitApplication() {
        try {
            IGV igv = IGV.getInstance();
            LinkedList<String> recentSessionList = igv.getRecentSessionList();
            if (!recentSessionList.isEmpty()) {
                int size = recentSessionList.size();
                if (size > 3) {
                    size = 3;
                }
                String recentSessions = "";
                for (int i2 = 0; i2 < size; ++i2) {
                    recentSessions = recentSessions + recentSessionList.get(i2);
                    if (i2 >= size - 1) continue;
                    recentSessions = recentSessions + ";";
                }
                PreferenceManager.getInstance().remove("IGV.Session.recent.sessions");
                PreferenceManager.getInstance().setRecentSessions(recentSessions);
            }
            PreferenceManager.getInstance().setApplicationFrameBounds(IGV.getMainFrame().getBounds());
            IGV.getMainFrame().setVisible(false);
            IGV.getMainFrame().dispose();
        }
        finally {
            System.exit(0);
        }
    }
}

