/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.JComponent;
import org.broad.igv.hic.HeatmapRenderer;
import org.broad.igv.hic.MainWindow;
import org.broad.igv.hic.data.Chromosome;
import org.broad.igv.hic.data.MatrixZoomData;
import org.broad.igv.util.ObjectCache;

public class HeatmapPanel
extends JComponent
implements Serializable {
    private MainWindow mainWindow;
    private int imageTileWidth = 500;
    ObjectCache<String, ImageTile> tileCache = new ObjectCache(100);
    private Rectangle zoomRectangle;
    HeatmapRenderer renderer;

    public HeatmapPanel() {
    }

    public HeatmapPanel(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.renderer = new HeatmapRenderer(mainWindow.colorScale);
        HeatmapMouseHandler mouseHandler = new HeatmapMouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
    }

    @Override
    protected void paintComponent(Graphics g2) {
        if (this.mainWindow != null && this.mainWindow.zd != null && this.mainWindow.xContext.getScale() > 0.0) {
            boolean isWholeGenome;
            int binSize = this.mainWindow.zd.getBinSize();
            int originX = this.mainWindow.xContext.getOrigin();
            int originY = this.mainWindow.yContext.getOrigin();
            int bLeft = originX / binSize;
            int bRight = bLeft + (int)((double)this.getWidth() * this.mainWindow.xContext.getScale() / (double)binSize);
            int bTop = originY / binSize;
            int bBottom = bTop + (int)((double)this.getWidth() * this.mainWindow.xContext.getScale() / (double)binSize);
            int tLeft = bLeft / this.imageTileWidth;
            int tRight = bRight / this.imageTileWidth;
            int tTop = bTop / this.imageTileWidth;
            int tBottom = bBottom / this.imageTileWidth;
            double pixelsPerBin = (double)binSize / this.mainWindow.xContext.getScale();
            for (int i2 = tLeft; i2 <= tRight; ++i2) {
                for (int j2 = tTop; j2 <= tBottom; ++j2) {
                    ImageTile tile = this.getImageTile(i2, j2, pixelsPerBin);
                    int pxOffset = (int)((double)(tile.bLeft - bLeft) * pixelsPerBin);
                    int pyOffset = (int)((double)(tile.bTop - bTop) * pixelsPerBin);
                    g2.drawImage(tile.image, pxOffset, pyOffset, null);
                }
            }
            boolean bl = isWholeGenome = this.mainWindow.xContext.getChromosome().getName().equals("All") && this.mainWindow.yContext.getChromosome().getName().equals("All");
            if (isWholeGenome) {
                Color color = g2.getColor();
                g2.setColor(Color.lightGray);
                Chromosome[] chromosomes = this.mainWindow.getChromosomes();
                int xGenomeCoord = 0;
                for (int i3 = 1; i3 < chromosomes.length; ++i3) {
                    Chromosome c2 = chromosomes[i3];
                    int x = this.mainWindow.xContext.getScreenPosition(xGenomeCoord += c2.getSize() / 1000);
                    g2.drawLine(x, 0, x, this.getHeight());
                }
                int yGenomeCoord = 0;
                for (int i4 = 1; i4 < chromosomes.length; ++i4) {
                    Chromosome c3 = chromosomes[i4];
                    int y = this.mainWindow.yContext.getScreenPosition(yGenomeCoord += c3.getSize() / 1000);
                    g2.drawLine(0, y, this.getWidth(), y);
                }
                g2.setColor(color);
            }
        }
        if (this.zoomRectangle != null) {
            ((Graphics2D)g2).draw(this.zoomRectangle);
        }
    }

    public Image getThumbnailImage(MatrixZoomData zd, int tw, int th) {
        int maxBinCountX = (this.mainWindow.xContext.getChrLength() - this.mainWindow.xContext.getOrigin()) / this.mainWindow.zd.getBinSize() + 1;
        int maxBinCountY = (this.mainWindow.yContext.getChrLength() - this.mainWindow.yContext.getOrigin()) / this.mainWindow.zd.getBinSize() + 1;
        int wh = Math.max(maxBinCountX, maxBinCountY);
        BufferedImage image = (BufferedImage)this.createImage(wh, wh);
        Graphics2D g2 = image.createGraphics();
        int nBins = 500;
        this.renderer.render(0, 0, maxBinCountX, maxBinCountY, zd, g2);
        return image.getScaledInstance(tw, th, 4);
    }

    private ImageTile getImageTile(int i2, int j2, double scaleFactor) {
        String key = "_" + i2 + "_" + j2;
        ImageTile tile = this.tileCache.get(key);
        if (tile == null) {
            int maxBinCountX = (this.mainWindow.xContext.getChrLength() - this.mainWindow.xContext.getOrigin()) / this.mainWindow.zd.getBinSize() + 1;
            int maxBinCountY = (this.mainWindow.yContext.getChrLength() - this.mainWindow.yContext.getOrigin()) / this.mainWindow.zd.getBinSize() + 1;
            int imageWidth = Math.min(maxBinCountX, this.imageTileWidth);
            int imageHeight = Math.min(maxBinCountY, this.imageTileWidth);
            BufferedImage image = (BufferedImage)this.createImage(imageWidth, imageHeight);
            Graphics2D g2D = (Graphics2D)image.getGraphics();
            int bx0 = i2 * this.imageTileWidth;
            int by0 = j2 * this.imageTileWidth;
            this.renderer.render(bx0, by0, imageWidth, imageHeight, this.mainWindow.zd, g2D);
            if (scaleFactor > 0.999 && scaleFactor < 1.001) {
                tile = new ImageTile(image, bx0, by0);
            } else {
                int scaledWidth = (int)(scaleFactor * (double)imageWidth);
                int scaledHeight = (int)(scaleFactor * (double)imageHeight);
                Image scaledImage = image.getScaledInstance(scaledWidth, scaledHeight, 4);
                tile = new ImageTile(scaledImage, bx0, by0);
            }
            this.tileCache.put(key, tile);
        }
        return tile;
    }

    public void clearTileCache() {
        this.tileCache.clear();
    }

    class HeatmapMouseHandler
    extends MouseAdapter {
        int dragMode = 0;
        private Point lastMousePoint;

        HeatmapMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            if (HeatmapPanel.this.mainWindow.isWholeGenome()) {
                return;
            }
            if (e2.isAltDown()) {
                this.dragMode = 2;
            } else {
                this.dragMode = 1;
                HeatmapPanel.this.mainWindow;
                HeatmapPanel.this.setCursor(MainWindow.fistCursor);
            }
            this.lastMousePoint = e2.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (this.dragMode == 2) {
                double xBP = ((HeatmapPanel)HeatmapPanel.this).mainWindow.xContext.getChromosomePosition(((HeatmapPanel)HeatmapPanel.this).zoomRectangle.x);
                double yBP = ((HeatmapPanel)HeatmapPanel.this).mainWindow.yContext.getChromosomePosition(((HeatmapPanel)HeatmapPanel.this).zoomRectangle.y);
                double wBP = (double)((HeatmapPanel)HeatmapPanel.this).zoomRectangle.width * ((HeatmapPanel)HeatmapPanel.this).mainWindow.xContext.getScale();
                double hBP = (double)((HeatmapPanel)HeatmapPanel.this).zoomRectangle.height * ((HeatmapPanel)HeatmapPanel.this).mainWindow.yContext.getScale();
                double newXScale = wBP / (double)HeatmapPanel.this.getWidth();
                double newYScale = hBP / (double)HeatmapPanel.this.getHeight();
                double newScale = Math.max(newXScale, newYScale);
                HeatmapPanel.this.mainWindow.zoomTo(xBP, yBP, newScale);
            }
            this.dragMode = 0;
            this.lastMousePoint = null;
            HeatmapPanel.this.zoomRectangle = null;
            HeatmapPanel.this.setCursor(Cursor.getDefaultCursor());
            HeatmapPanel.this.repaint();
        }

        @Override
        public final void mouseDragged(MouseEvent e2) {
            if (((HeatmapPanel)HeatmapPanel.this).mainWindow.zd == null || HeatmapPanel.this.mainWindow.isWholeGenome()) {
                return;
            }
            if (this.lastMousePoint == null) {
                this.lastMousePoint = e2.getPoint();
                return;
            }
            double deltaX = e2.getX() - this.lastMousePoint.x;
            double deltaY = e2.getY() - this.lastMousePoint.y;
            switch (this.dragMode) {
                case 2: {
                    Rectangle lastRectangle = HeatmapPanel.this.zoomRectangle;
                    if (deltaX == 0.0 || deltaY == 0.0) {
                        return;
                    }
                    double aspectRatio = (double)HeatmapPanel.this.getWidth() / (double)HeatmapPanel.this.getHeight();
                    if (deltaX * aspectRatio > deltaY) {
                        deltaY = (int)(deltaX / aspectRatio);
                    } else {
                        deltaX = (int)(deltaY * aspectRatio);
                    }
                    int x = deltaX > 0.0 ? this.lastMousePoint.x : this.lastMousePoint.x + (int)deltaX;
                    int y = deltaY > 0.0 ? this.lastMousePoint.y : this.lastMousePoint.y + (int)deltaY;
                    HeatmapPanel.this.zoomRectangle = new Rectangle(x, y, (int)Math.abs(deltaX), (int)Math.abs(deltaY));
                    Rectangle damageRect = lastRectangle == null ? HeatmapPanel.this.zoomRectangle : HeatmapPanel.this.zoomRectangle.union(lastRectangle);
                    --damageRect.x;
                    --damageRect.y;
                    damageRect.width += 2;
                    damageRect.height += 2;
                    HeatmapPanel.this.paintImmediately(damageRect);
                    break;
                }
                default: {
                    int dx = (int)(deltaX * ((HeatmapPanel)HeatmapPanel.this).mainWindow.xContext.getScale());
                    int dy = (int)(deltaY * ((HeatmapPanel)HeatmapPanel.this).mainWindow.yContext.getScale());
                    this.lastMousePoint = e2.getPoint();
                    HeatmapPanel.this.mainWindow.moveBy(-dx, -dy);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            if (!e2.isPopupTrigger()) {
                if (HeatmapPanel.this.mainWindow.isWholeGenome()) {
                    double xGenome = ((HeatmapPanel)HeatmapPanel.this).mainWindow.xContext.getChromosomePosition(e2.getX());
                    double yGenome = ((HeatmapPanel)HeatmapPanel.this).mainWindow.yContext.getChromosomePosition(e2.getY());
                    Chromosome xChrom = null;
                    Chromosome yChrom = null;
                    int[] boundaries = HeatmapPanel.this.mainWindow.getChromosomeBoundaries();
                    for (int i2 = 0; i2 < boundaries.length; ++i2) {
                        if (xChrom == null && (double)boundaries[i2] > xGenome) {
                            xChrom = HeatmapPanel.this.mainWindow.getChromosomes()[i2 + 1];
                        }
                        if (yChrom == null && (double)boundaries[i2] > yGenome) {
                            yChrom = HeatmapPanel.this.mainWindow.getChromosomes()[i2 + 1];
                        }
                        if (xChrom == null || yChrom == null) continue;
                        HeatmapPanel.this.mainWindow.setSelectedChromosomes(xChrom, yChrom);
                    }
                } else if (e2.getClickCount() > 1) {
                    int currentZoom = ((HeatmapPanel)HeatmapPanel.this).mainWindow.xContext.getZoom();
                    int newZoom = e2.isAltDown() ? Math.max(currentZoom - 1, 1) : Math.min(11, currentZoom + 1);
                    int centerLocationX = (int)((HeatmapPanel)HeatmapPanel.this).mainWindow.xContext.getChromosomePosition(e2.getX());
                    int centerLocationY = (int)((HeatmapPanel)HeatmapPanel.this).mainWindow.yContext.getChromosomePosition(e2.getY());
                    HeatmapPanel.this.mainWindow.setZoom(newZoom, centerLocationX, centerLocationY);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            if (((HeatmapPanel)HeatmapPanel.this).mainWindow.xContext != null && ((HeatmapPanel)HeatmapPanel.this).mainWindow.zd != null) {
                if (HeatmapPanel.this.mainWindow.isWholeGenome()) {
                    double xGenome = ((HeatmapPanel)HeatmapPanel.this).mainWindow.xContext.getChromosomePosition(e2.getX());
                    double yGenome = ((HeatmapPanel)HeatmapPanel.this).mainWindow.yContext.getChromosomePosition(e2.getY());
                    Chromosome xChrom = null;
                    Chromosome yChrom = null;
                    int[] boundaries = HeatmapPanel.this.mainWindow.getChromosomeBoundaries();
                    for (int i2 = 0; i2 < boundaries.length; ++i2) {
                        if (xChrom == null && (double)boundaries[i2] > xGenome) {
                            xChrom = HeatmapPanel.this.mainWindow.getChromosomes()[i2 + 1];
                        }
                        if (yChrom == null && (double)boundaries[i2] > yGenome) {
                            yChrom = HeatmapPanel.this.mainWindow.getChromosomes()[i2 + 1];
                        }
                        if (xChrom == null || yChrom == null) continue;
                        int leftBoundaryX = xChrom.getIndex() == 1 ? 0 : boundaries[xChrom.getIndex() - 2];
                        int leftBoundaryY = yChrom.getIndex() == 1 ? 0 : boundaries[yChrom.getIndex() - 2];
                        int xChromPos = (int)((xGenome - (double)leftBoundaryX) * 1000.0);
                        int yChromPos = (int)((yGenome - (double)leftBoundaryY) * 1000.0);
                        StringBuffer txt = new StringBuffer();
                        txt.append("<html>");
                        txt.append(yChrom.getName());
                        txt.append(":");
                        txt.append(String.valueOf(yChromPos));
                        txt.append("<br>");
                        txt.append(xChrom.getName());
                        txt.append(":");
                        txt.append(String.valueOf(xChromPos));
                        HeatmapPanel.this.setToolTipText(txt.toString());
                        return;
                    }
                } else {
                    int posX = (int)((HeatmapPanel)HeatmapPanel.this).mainWindow.xContext.getChromosomePosition(e2.getX());
                    int posY = (int)((HeatmapPanel)HeatmapPanel.this).mainWindow.yContext.getChromosomePosition(e2.getY());
                    StringBuffer txt = new StringBuffer();
                    txt.append("<html>");
                    txt.append(((HeatmapPanel)HeatmapPanel.this).mainWindow.xContext.getChromosome().getName());
                    txt.append(":");
                    txt.append(String.valueOf(posX));
                    txt.append("<br>");
                    txt.append(((HeatmapPanel)HeatmapPanel.this).mainWindow.yContext.getChromosome().getName());
                    txt.append(":");
                    txt.append(String.valueOf(posY));
                    HeatmapPanel.this.setToolTipText(txt.toString());
                }
            }
        }
    }

    static class ImageTile {
        int bLeft;
        int bTop;
        Image image;

        ImageTile(Image image, int bLeft, int py0) {
            this.bLeft = bLeft;
            this.bTop = py0;
            this.image = image;
        }
    }
}

