/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.Painter;
import com.jidesoft.swing.JideCursors;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.PortingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;

public class JideSplitPaneDivider
extends JPanel
implements PropertyChangeListener {
    protected DragController _dragger;
    protected int _dividerSize = UIDefaultsLookup.getInt("JideSplitPane.dividerSize");
    protected JideSplitPane _jideSplitPane;
    protected MouseHandler _mouseHandler;
    protected int _orientation;
    static final Cursor HORIZONTAL_CURSOR = JideCursors.getPredefinedCursor(20);
    static final Cursor VERTICAL_CURSOR = JideCursors.getPredefinedCursor(21);
    static final Cursor DEFAULT_CURSOR = Cursor.getDefaultCursor();
    private Painter _gripperPainter;
    public static final int COLLAPSED_STATE = 0;
    public static final int DEFAULT_STATE = 1;
    public static final int EXPANDED_STATE = 2;
    private int _currentState = 1;
    protected JButton _leftButton = null;
    protected JButton _rightButton = null;
    private int _triangleSize = 5;
    private int _buttonWidth = 5;
    private int _buttonHeight = 10;
    private int _lastPosition;

    public JideSplitPaneDivider(JideSplitPane jideSplitPane) {
        this.setJideSplitPane(jideSplitPane);
        this._orientation = this._jideSplitPane.getOrientation();
        this.setDividerSize(jideSplitPane.getDividerSize());
        this.setDefaultResizeCursor();
        this.setBackground(UIDefaultsLookup.getColor("JideSplitPaneDivider.background"));
        this.setBorder(UIDefaultsLookup.getBorder("JideSplitPaneDivider.border"));
        this.oneTouchExpandableChanged();
        this._gripperPainter = (Painter)UIDefaultsLookup.get("JideSplitPaneDivider.gripperPainter");
        this.setOpaque(false);
        this.setLayout(null);
    }

    public void setDefaultResizeCursor() {
        this.setCursor(this._orientation == 1 ? HORIZONTAL_CURSOR : VERTICAL_CURSOR);
    }

    public JideSplitPane getJideSplitPane() {
        return this._jideSplitPane;
    }

    public void setJideSplitPane(JideSplitPane jideSplitPane) {
        this.uninstallListeners();
        this._jideSplitPane = jideSplitPane;
        this.installListeners();
    }

    private void installListeners() {
        if (this._jideSplitPane != null) {
            if (this._mouseHandler == null) {
                this._mouseHandler = this.createMouseHandler();
            }
            this._jideSplitPane.addMouseListener(this._mouseHandler);
            this._jideSplitPane.addMouseMotionListener(this._mouseHandler);
            this.addMouseListener(this._mouseHandler);
            this.addMouseMotionListener(this._mouseHandler);
            this._jideSplitPane.addPropertyChangeListener(this);
        }
    }

    private void uninstallListeners() {
        if (this._jideSplitPane != null) {
            this._jideSplitPane.removePropertyChangeListener(this);
            if (this._mouseHandler != null) {
                this._jideSplitPane.removeMouseListener(this._mouseHandler);
                this._jideSplitPane.removeMouseMotionListener(this._mouseHandler);
                this.removeMouseListener(this._mouseHandler);
                this.removeMouseMotionListener(this._mouseHandler);
                this._mouseHandler = null;
            }
        }
    }

    protected MouseHandler createMouseHandler() {
        return new MouseHandler();
    }

    public void setDividerSize(int n2) {
        this._dividerSize = n2;
    }

    public int getDividerSize() {
        return this._dividerSize;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getDividerSize(), this.getDividerSize());
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this._jideSplitPane) {
            if ("orientation".equals(propertyChangeEvent.getPropertyName())) {
                this._orientation = this._jideSplitPane.getOrientation();
                this.setCursor(this._orientation == 1 ? HORIZONTAL_CURSOR : VERTICAL_CURSOR);
                this.invalidate();
                this.validate();
            } else if ("oneTouchExpandable".equals(propertyChangeEvent.getPropertyName())) {
                this.setDividerSize(this._jideSplitPane.getDividerSize());
                this.oneTouchExpandableChanged();
            } else if ("gripper".equals(propertyChangeEvent.getPropertyName())) {
                this.repaint();
            }
        }
    }

    public void updateUI() {
        super.updateUI();
        this.setBackground(UIDefaultsLookup.getColor("JideSplitPaneDivider.background"));
        this.setBorder(UIDefaultsLookup.getBorder("JideSplitPaneDivider.border"));
        this._gripperPainter = (Painter)UIDefaultsLookup.get("JideSplitPaneDivider.gripperPainter");
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Border border = this.getBorder();
        Dimension dimension = this.getSize();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        if (border != null) {
            border.paintBorder(this, graphics, 0, 0, dimension.width, dimension.height);
        }
        if (this._jideSplitPane.isShowGripper()) {
            Rectangle rectangle = new Rectangle(dimension);
            if (this._gripperPainter != null) {
                if (rectangle.width > rectangle.height) {
                    this._gripperPainter.paint(this, graphics, rectangle, 1, 0);
                } else {
                    this._gripperPainter.paint(this, graphics, rectangle, 0, 0);
                }
            } else {
                ++rectangle.x;
                ++rectangle.y;
                JideSwingUtilities.drawGrip(graphics, rectangle, 9, UIDefaultsLookup.getInt("JideSplitPane.dividerSize") / 3);
            }
        }
    }

    protected void prepareForDragging() {
        this._jideSplitPane.startDragging(this);
    }

    protected void dragDividerTo(int n2) {
        this._jideSplitPane.dragDividerTo(this, n2);
        this._currentState = 1;
        int n3 = this._jideSplitPane.indexOfDivider(this);
        this._lastPosition = this._jideSplitPane.getDividerLocation(n3);
    }

    protected void finishDraggingTo(int n2) {
        this._jideSplitPane.finishDraggingTo(this, n2);
    }

    protected int getPreviousDividerLocation(boolean bl, boolean bl2) {
        return this._jideSplitPane.getPreviousDividerLocation(this, bl, bl2);
    }

    protected int getNextDividerLocation(boolean bl, boolean bl2) {
        return this._jideSplitPane.getNextDividerLocation(this, bl, bl2);
    }

    public Component getFirstComponent(boolean bl) {
        int n2 = this._jideSplitPane.indexOf(this);
        if (n2 - 1 >= 0) {
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                if (!bl && !this._jideSplitPane.getComponent(i2).isVisible()) continue;
                return this._jideSplitPane.getComponent(i2);
            }
            return this._jideSplitPane.getComponent(n2 - 1);
        }
        throw new IndexOutOfBoundsException("There is no component before divider " + n2);
    }

    public Component getSecondComponent(boolean bl) {
        int n2 = this._jideSplitPane.indexOf(this);
        if (n2 + 1 < this._jideSplitPane.getComponentCount()) {
            for (int i2 = n2 + 1; i2 >= 0; ++i2) {
                if (!bl && !this._jideSplitPane.getComponent(i2).isVisible()) continue;
                return this._jideSplitPane.getComponent(i2);
            }
            return this._jideSplitPane.getComponent(n2 + 1);
        }
        throw new IndexOutOfBoundsException("There is no component before divider " + n2);
    }

    protected void oneTouchExpandableChanged() {
        if (this._jideSplitPane.isOneTouchExpandable() && this._leftButton == null) {
            this._leftButton = this.createLeftOneTouchButton();
            if (this._leftButton != null) {
                this._leftButton.addActionListener(new OneTouchActionHandler(true));
                if (this._orientation == 1) {
                    this._leftButton.setBounds(1, 10, this._buttonWidth, this._buttonHeight);
                } else if (this._orientation == 0) {
                    this._leftButton.setBounds(10, 1, this._buttonHeight, this._buttonWidth);
                }
                this.add(this._leftButton);
            }
        }
        if (this._jideSplitPane.isOneTouchExpandable() && this._rightButton == null) {
            this._rightButton = this.createRightOneTouchButton();
            if (this._rightButton != null) {
                this._rightButton.addActionListener(new OneTouchActionHandler(false));
                if (this._orientation == 1) {
                    this._rightButton.setBounds(1, 25, this._buttonWidth, this._buttonHeight);
                } else if (this._orientation == 0) {
                    this._rightButton.setBounds(25, 1, this._buttonHeight, this._buttonWidth);
                }
                this.add(this._rightButton);
            }
        }
        if (!this._jideSplitPane.isOneTouchExpandable() && this._leftButton != null) {
            this.remove(this._leftButton);
            this._leftButton = null;
        }
        if (!this._jideSplitPane.isOneTouchExpandable() && this._rightButton != null) {
            this.remove(this._rightButton);
            this._rightButton = null;
        }
        int n2 = this._jideSplitPane.getPaneCount();
        if (this._jideSplitPane.isOneTouchExpandable()) {
            for (int i2 = 0; i2 < n2; ++i2) {
                Component component = this._jideSplitPane.getPaneAt(i2);
                PortingUtils.setMinimumSize(component, new Dimension(0, 0));
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                Component component = this._jideSplitPane.getPaneAt(i3);
                PortingUtils.setMinimumSize(component, null);
            }
        }
    }

    protected JButton createLeftOneTouchButton() {
        JButton jButton = new JButton(){

            public void setBorder(Border border) {
            }

            public void paint(Graphics graphics) {
                block3: {
                    block5: {
                        block4: {
                            if (JideSplitPaneDivider.this._jideSplitPane == null) break block3;
                            graphics.setColor(this.getBackground());
                            if (this.isOpaque()) {
                                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                            }
                            if (JideSplitPaneDivider.this._jideSplitPane.getLeftOneTouchButtonImageIcon() == null) break block4;
                            JideSplitPaneDivider.this._jideSplitPane.getLeftOneTouchButtonImageIcon().paintIcon(this, graphics, 0, 0);
                            break block3;
                        }
                        if (JideSplitPaneDivider.this._orientation != 1) break block5;
                        graphics.setColor(JideSplitPaneDivider.this.getDarkShadowColor());
                        int n2 = JideSplitPaneDivider.this._triangleSize;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            graphics.drawLine(i2, n2 - i2, i2, n2 + i2);
                        }
                        break block3;
                    }
                    if (JideSplitPaneDivider.this._orientation != 0) break block3;
                    graphics.setColor(JideSplitPaneDivider.this.getDarkShadowColor());
                    int n3 = JideSplitPaneDivider.this._triangleSize;
                    for (int i3 = 0; i3 < n3; ++i3) {
                        graphics.drawLine(n3 - i3, i3, n3 + i3, i3);
                    }
                }
            }

            public boolean isFocusTraversable() {
                return false;
            }
        };
        jButton.setMinimumSize(new Dimension(this._buttonWidth, this._buttonHeight));
        jButton.setCursor(Cursor.getPredefinedCursor(0));
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setRequestFocusEnabled(false);
        return jButton;
    }

    protected JButton createRightOneTouchButton() {
        JButton jButton = new JButton(){

            public void setBorder(Border border) {
            }

            public void paint(Graphics graphics) {
                block3: {
                    block5: {
                        block4: {
                            if (JideSplitPaneDivider.this._jideSplitPane == null) break block3;
                            graphics.setColor(this.getBackground());
                            if (this.isOpaque()) {
                                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                            }
                            if (JideSplitPaneDivider.this._jideSplitPane.getRightOneTouchButtonImageIcon() == null) break block4;
                            JideSplitPaneDivider.this._jideSplitPane.getRightOneTouchButtonImageIcon().paintIcon(this, graphics, 0, 0);
                            break block3;
                        }
                        if (JideSplitPaneDivider.this._orientation != 1) break block5;
                        graphics.setColor(JideSplitPaneDivider.this.getDarkShadowColor());
                        int n2 = JideSplitPaneDivider.this._triangleSize;
                        int n3 = 0;
                        for (int i2 = n2 - 1; i2 >= 0; --i2) {
                            graphics.drawLine(n3, n2 - i2, n3, n2 + i2);
                            ++n3;
                        }
                        break block3;
                    }
                    if (JideSplitPaneDivider.this._orientation != 0) break block3;
                    graphics.setColor(JideSplitPaneDivider.this.getDarkShadowColor());
                    int n4 = JideSplitPaneDivider.this._triangleSize;
                    int n5 = 0;
                    for (int i3 = n4 - 1; i3 >= 0; --i3) {
                        graphics.drawLine(n4 - i3, n5, n4 + i3, n5);
                        ++n5;
                    }
                }
            }

            public boolean isFocusTraversable() {
                return false;
            }
        };
        jButton.setMinimumSize(new Dimension(this._buttonWidth, this._buttonHeight));
        jButton.setCursor(Cursor.getPredefinedCursor(0));
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setRequestFocusEnabled(false);
        return jButton;
    }

    protected Color getDarkShadowColor() {
        return UIManager.getColor("controlDkShadow");
    }

    public void collapse() {
        if (this._leftButton != null) {
            this._leftButton.doClick();
        } else {
            new OneTouchActionHandler(true).actionPerformed(null);
        }
    }

    public void expand() {
        if (this._rightButton != null) {
            this._rightButton.doClick();
        } else {
            new OneTouchActionHandler(false).actionPerformed(null);
        }
    }

    protected class OneTouchActionHandler
    implements ActionListener {
        private boolean _collapse;

        public OneTouchActionHandler(boolean bl) {
            this._collapse = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this._collapse) {
                int n2;
                int n3;
                int n4;
                if (JideSplitPaneDivider.this._currentState == 0 && (n4 = JideSplitPaneDivider.this._jideSplitPane.getDividerLocation(n3 = JideSplitPaneDivider.this._jideSplitPane.indexOfDivider(JideSplitPaneDivider.this))) != (n2 = JideSplitPaneDivider.this.getPreviousDividerLocation(true, false))) {
                    JideSplitPaneDivider.this._currentState = 1;
                }
                if (JideSplitPaneDivider.this._currentState == 2) {
                    JideSplitPaneDivider.this._jideSplitPane.setDividerLocation(JideSplitPaneDivider.this, JideSplitPaneDivider.this._lastPosition);
                    JideSplitPaneDivider.this._currentState = 1;
                } else if (JideSplitPaneDivider.this._currentState == 1) {
                    n3 = JideSplitPaneDivider.this._jideSplitPane.indexOfDivider(JideSplitPaneDivider.this);
                    JideSplitPaneDivider.this._lastPosition = JideSplitPaneDivider.this._jideSplitPane.getDividerLocation(n3);
                    n4 = JideSplitPaneDivider.this.getPreviousDividerLocation(true, false);
                    JideSplitPaneDivider.this._jideSplitPane.setDividerLocation(JideSplitPaneDivider.this, n4);
                    JideSplitPaneDivider.this._currentState = 0;
                }
            } else {
                int n5;
                int n6;
                int n7;
                if (JideSplitPaneDivider.this._currentState == 2 && (n7 = JideSplitPaneDivider.this._jideSplitPane.getDividerLocation(n6 = JideSplitPaneDivider.this._jideSplitPane.indexOfDivider(JideSplitPaneDivider.this))) != (n5 = JideSplitPaneDivider.this.getNextDividerLocation(true, false))) {
                    JideSplitPaneDivider.this._currentState = 1;
                }
                if (JideSplitPaneDivider.this._currentState == 0) {
                    JideSplitPaneDivider.this._jideSplitPane.setDividerLocation(JideSplitPaneDivider.this, JideSplitPaneDivider.this._lastPosition);
                    JideSplitPaneDivider.this._currentState = 1;
                } else if (JideSplitPaneDivider.this._currentState == 1) {
                    n6 = JideSplitPaneDivider.this._jideSplitPane.indexOfDivider(JideSplitPaneDivider.this);
                    JideSplitPaneDivider.this._lastPosition = JideSplitPaneDivider.this._jideSplitPane.getDividerLocation(n6);
                    n7 = JideSplitPaneDivider.this.getNextDividerLocation(true, false);
                    JideSplitPaneDivider.this._jideSplitPane.setDividerLocation(JideSplitPaneDivider.this, n7);
                    JideSplitPaneDivider.this._currentState = 2;
                }
            }
        }
    }

    protected class VerticalDragController
    extends DragController {
        protected VerticalDragController(MouseEvent mouseEvent) {
            super(mouseEvent);
            Component component = JideSplitPaneDivider.this.getFirstComponent(false);
            Component component2 = JideSplitPaneDivider.this.getSecondComponent(false);
            this.initialLocation = JideSplitPaneDivider.this.getLocation().y;
            this.offset = mouseEvent.getSource() == JideSplitPaneDivider.this ? mouseEvent.getY() : mouseEvent.getY() - this.initialLocation;
            if (component == null || component2 == null || this.offset < -1 || this.offset >= JideSplitPaneDivider.this._jideSplitPane.getSize().height) {
                this.maxLocation = -1;
            } else {
                this.minLocation = component.isVisible() ? JideSplitPaneDivider.this.getPreviousDividerLocation(false, false) + component.getMinimumSize().height : 0;
                this.maxLocation = component2.isVisible() ? Math.max(0, JideSplitPaneDivider.this.getNextDividerLocation(false, false) - JideSplitPaneDivider.this.getSize().height - component2.getMinimumSize().height) : Math.max(0, JideSplitPaneDivider.this.getNextDividerLocation(true, false) - JideSplitPaneDivider.this.getSize().height);
                if (this.maxLocation < this.minLocation) {
                    this.maxLocation = 0;
                    this.minLocation = 0;
                }
            }
        }

        protected int getNeededLocation(int n2, int n3) {
            int n4 = Math.min(this.maxLocation, Math.max(this.minLocation, n3 - this.offset));
            return n4;
        }

        protected int positionForMouseEvent(MouseEvent mouseEvent) {
            int n2 = mouseEvent.getSource() == JideSplitPaneDivider.this ? mouseEvent.getY() + JideSplitPaneDivider.this.getLocation().y : mouseEvent.getY();
            n2 = Math.min(this.maxLocation, Math.max(this.minLocation, n2 - this.offset));
            return n2;
        }
    }

    protected class DragController {
        int initialLocation;
        int maxLocation;
        int minLocation;
        int offset;

        protected DragController(MouseEvent mouseEvent) {
            ComponentOrientation componentOrientation = JideSplitPaneDivider.this.getComponentOrientation();
            boolean bl = componentOrientation.isLeftToRight();
            boolean bl2 = !bl && JideSplitPaneDivider.this._jideSplitPane.getOrientation() == 1;
            Component component = bl2 ? JideSplitPaneDivider.this.getSecondComponent(false) : JideSplitPaneDivider.this.getFirstComponent(false);
            Component component2 = bl2 ? JideSplitPaneDivider.this.getFirstComponent(false) : JideSplitPaneDivider.this.getSecondComponent(false);
            this.initialLocation = JideSplitPaneDivider.this.getLocation().x;
            this.offset = mouseEvent.getSource() == JideSplitPaneDivider.this ? mouseEvent.getX() : mouseEvent.getX() - this.initialLocation;
            if (component == null || component2 == null || this.offset < -1 || this.offset >= JideSplitPaneDivider.this._jideSplitPane.getSize().width) {
                this.maxLocation = -1;
            } else {
                this.minLocation = component.isVisible() ? JideSplitPaneDivider.this.getPreviousDividerLocation(false, bl2) + component.getMinimumSize().width : JideSplitPaneDivider.this.getPreviousDividerLocation(true, bl2);
                this.maxLocation = component2.isVisible() ? Math.max(0, JideSplitPaneDivider.this.getNextDividerLocation(false, bl2) - JideSplitPaneDivider.this.getSize().width - component2.getMinimumSize().width) : Math.max(0, JideSplitPaneDivider.this.getNextDividerLocation(true, bl2) - JideSplitPaneDivider.this.getSize().width);
                if (this.maxLocation < this.minLocation) {
                    this.maxLocation = 0;
                    this.minLocation = 0;
                }
            }
        }

        protected boolean isValid() {
            return this.maxLocation > 0;
        }

        protected int positionForMouseEvent(MouseEvent mouseEvent) {
            int n2 = mouseEvent.getSource() == JideSplitPaneDivider.this ? mouseEvent.getX() + JideSplitPaneDivider.this.getLocation().x : mouseEvent.getX();
            n2 = Math.min(this.maxLocation, Math.max(this.minLocation, n2 - this.offset));
            return n2;
        }

        protected int getNeededLocation(int n2, int n3) {
            int n4 = Math.min(this.maxLocation, Math.max(this.minLocation, n2 - this.offset));
            return n4;
        }

        protected void continueDrag(int n2, int n3) {
            JideSplitPaneDivider.this.dragDividerTo(this.getNeededLocation(n2, n3));
        }

        protected void continueDrag(MouseEvent mouseEvent) {
            JideSplitPaneDivider.this.dragDividerTo(this.positionForMouseEvent(mouseEvent));
        }

        protected void completeDrag(int n2, int n3) {
            JideSplitPaneDivider.this.finishDraggingTo(this.getNeededLocation(n2, n3));
        }

        protected void completeDrag(MouseEvent mouseEvent) {
            JideSplitPaneDivider.this.finishDraggingTo(this.positionForMouseEvent(mouseEvent));
        }
    }

    protected class MouseHandler
    extends MouseInputAdapter {
        protected MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == JideSplitPaneDivider.this && JideSplitPaneDivider.this._dragger == null && JideSplitPaneDivider.this._jideSplitPane.isEnabled()) {
                if (JideSplitPaneDivider.this.getFirstComponent(true) != null && JideSplitPaneDivider.this.getSecondComponent(true) != null) {
                    JideSplitPaneDivider.this._dragger = JideSplitPaneDivider.this._orientation == 1 ? new DragController(mouseEvent) : new VerticalDragController(mouseEvent);
                    if (!JideSplitPaneDivider.this._dragger.isValid()) {
                        JideSplitPaneDivider.this._dragger = null;
                    } else {
                        JideSplitPaneDivider.this.prepareForDragging();
                        JideSplitPaneDivider.this._dragger.continueDrag(mouseEvent);
                    }
                }
                mouseEvent.consume();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (JideSplitPaneDivider.this._dragger != null) {
                if (mouseEvent.getSource() == JideSplitPaneDivider.this._jideSplitPane) {
                    JideSplitPaneDivider.this._dragger.completeDrag(mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getSource() == JideSplitPaneDivider.this) {
                    Point point = JideSplitPaneDivider.this.getLocation();
                    JideSplitPaneDivider.this._dragger.completeDrag(mouseEvent.getX() + point.x, mouseEvent.getY() + point.y);
                }
                JideSplitPaneDivider.this._dragger = null;
                mouseEvent.consume();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (JideSplitPaneDivider.this._dragger != null) {
                if (mouseEvent.getSource() == JideSplitPaneDivider.this._jideSplitPane) {
                    JideSplitPaneDivider.this._dragger.continueDrag(mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getSource() == JideSplitPaneDivider.this) {
                    Point point = JideSplitPaneDivider.this.getLocation();
                    JideSplitPaneDivider.this._dragger.continueDrag(mouseEvent.getX() + point.x, mouseEvent.getY() + point.y);
                }
                mouseEvent.consume();
            }
        }
    }
}

