/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LittleEndianInputStream
extends FilterInputStream {
    public LittleEndianInputStream(InputStream in) {
        super(in);
    }

    public boolean readBoolean() throws IOException {
        int bool = this.in.read();
        if (bool == -1) {
            throw new EOFException();
        }
        return bool != 0;
    }

    public byte readByte() throws IOException {
        int temp = this.in.read();
        if (temp == -1) {
            throw new EOFException();
        }
        return (byte)temp;
    }

    public int readUnsignedByte() throws IOException {
        int temp = this.in.read();
        if (temp == -1) {
            throw new EOFException();
        }
        return temp;
    }

    public short readShort() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 == -1) {
            throw new EOFException();
        }
        return (short)((byte2 << 24 >>> 16) + (byte1 << 24 >>> 24));
    }

    public int readUnsignedShort() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 == -1) {
            throw new EOFException();
        }
        return (byte2 << 24 >> 16) + (byte1 << 24 >> 24);
    }

    public char readChar() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 == -1) {
            throw new EOFException();
        }
        return (char)((byte2 << 24 >>> 16) + (byte1 << 24 >>> 24));
    }

    public int readInt() throws IOException {
        byte[] bytes = new byte[4];
        this.readFully(bytes);
        return (bytes[3] << 24) + (bytes[2] << 24 >>> 8) + (bytes[1] << 24 >>> 16) + (bytes[0] << 24 >>> 24);
    }

    public long readLong() throws IOException {
        byte[] bytes = new byte[8];
        this.readFully(bytes);
        return (bytes[7] << 56) + (bytes[6] << 56 >>> 8) + (bytes[5] << 56 >>> 16) + (bytes[4] << 56 >>> 24) + (bytes[3] << 56 >>> 32) + (bytes[2] << 56 >>> 40) + (bytes[1] << 56 >>> 48) + (bytes[0] << 56 >>> 56);
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public String readString() throws IOException {
        byte b2;
        ByteArrayOutputStream bis = new ByteArrayOutputStream(100);
        while ((b2 = (byte)this.in.read()) != 0) {
            bis.write(b2);
        }
        return new String(bis.toByteArray());
    }

    private void readFully(byte[] b2) throws IOException {
        int count;
        int len = b2.length;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n2 = 0; n2 < len; n2 += count) {
            count = this.read(b2, n2, len - n2);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }
}

