/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.FeatureRenderer;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.PairedAlignment;
import org.broad.igv.track.RenderContext;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.ChromosomeColors;
import org.broad.igv.util.ColorUtilities;

public class AlignmentRenderer
implements FeatureRenderer {
    private static Map<Character, Color> nucleotideColors;
    public static boolean colorSpace;
    private static Color smallISizeColor;
    private static Color largeISizeColor;
    private static Color purple;
    private static Color deletionColor;
    private static Color skippedColor;
    private static float[] rbgBuffer;
    private static float[] colorComps;
    private static float[] alignComps;
    private static float[] whiteComponents;
    private static Color grey2;
    public static Color grey1;
    private static Stroke thickStroke;
    private static final Color negStrandColor;
    private static final Color posStrandColor;
    private static HashMap<String, Color> readGroupColors;
    private static final Color LR_COLOR;
    private static final Color RL_COLOR;
    private static final Color RR_COLOR;
    private static final Color LL_COLOR;
    static Map<String, Color> frOrientationColors;
    static Map<String, Color> ffOrientationColors;
    static Map<String, Color> rfOrientationColors;
    PreferenceManager prefs = PreferenceManager.getInstance();
    ContinuousColorScale cs = null;

    @Override
    public void renderAlignments(List<Alignment> alignments, RenderContext context, Rectangle rect, AlignmentTrack.RenderOptions renderOptions, boolean leaveMargin, Map<String, Color> selectedReadNames) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        Rectangle screenRect = context.getVisibleRect();
        Font font = FontManager.getFont(10);
        if (alignments != null && alignments.size() > 0) {
            for (Alignment alignment : alignments) {
                Graphics2D g2;
                Color alignmentColor;
                double pixelStart = ((double)alignment.getStart() - origin) / locScale;
                double pixelEnd = ((double)alignment.getEnd() - origin) / locScale;
                if (pixelEnd < (double)rect.x) continue;
                if (pixelStart > rect.getMaxX()) break;
                if (pixelEnd - pixelStart < 4.0) {
                    alignmentColor = this.getAlignmentColor(alignment, locScale, context.getReferenceFrame().getCenter(), renderOptions);
                    g2 = context.getGraphic2DForColor(alignmentColor);
                    g2.setFont(font);
                    int w = Math.max(1, (int)(pixelEnd - pixelStart));
                    int h2 = (int)Math.max(1.0, rect.getHeight() - 2.0);
                    int y = (int)(rect.getY() + (rect.getHeight() - (double)h2) / 2.0);
                    g2.fillRect((int)pixelStart, y, w, h2);
                    continue;
                }
                if (alignment instanceof PairedAlignment) {
                    this.drawPairedAlignment((PairedAlignment)alignment, rect, context, renderOptions, leaveMargin, selectedReadNames, font);
                    continue;
                }
                alignmentColor = this.getAlignmentColor(alignment, locScale, context.getReferenceFrame().getCenter(), renderOptions);
                g2 = context.getGraphic2DForColor(alignmentColor);
                g2.setFont(font);
                this.drawAlignment(alignment, rect, g2, context, alignmentColor, renderOptions, leaveMargin, selectedReadNames);
            }
            if (locScale < 5.0 && renderOptions.showCenterLine) {
                double center = (int)(context.getReferenceFrame().getCenter() - origin);
                int centerLeftP = (int)(center / locScale);
                int centerRightP = (int)((center + 1.0) / locScale);
                Graphics2D gBlack = context.getGraphic2DForColor(Color.black);
                GraphicUtils.drawDottedDashLine(gBlack, centerLeftP, rect.y, centerLeftP, rect.y + rect.height);
                if (centerRightP - centerLeftP > 2) {
                    GraphicUtils.drawDottedDashLine(gBlack, centerRightP, rect.y, centerRightP, rect.y + rect.height);
                }
            }
        }
    }

    private void drawSimpleAlignment(Alignment alignment, Rectangle rect, Graphics2D g2, RenderContext context, boolean flagUnmappedPair) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        int x = (int)(((double)alignment.getStart() - origin) / locScale);
        int length = alignment.getEnd() - alignment.getStart();
        int w = (int)Math.ceil((double)length / locScale);
        int h2 = (int)Math.max(1.0, rect.getHeight() - 2.0);
        int y = (int)(rect.getY() + (rect.getHeight() - (double)h2) / 2.0);
        int arrowLength = Math.min(5, w / 6);
        int[] xPoly = null;
        int[] yPoly = new int[]{y, y, y + h2 / 2, y + h2, y + h2};
        if (x < rect.x && x + w > rect.x + rect.width) {
            x = rect.x;
            w = rect.width;
            arrowLength = 0;
        } else if (x < rect.x) {
            int delta = rect.x - x;
            x = rect.x;
            w -= delta;
            if (alignment.isNegativeStrand()) {
                arrowLength = 0;
            }
        } else if (x + w > rect.x + rect.width) {
            w -= x + w - (rect.x + rect.width);
            if (!alignment.isNegativeStrand()) {
                arrowLength = 0;
            }
        }
        xPoly = alignment.isNegativeStrand() ? new int[]{x + w, x, x - arrowLength, x, x + w} : new int[]{x, x + w, x + w + arrowLength, x + w, x};
        g2.fillPolygon(xPoly, yPoly, xPoly.length);
        if (flagUnmappedPair && alignment.isPaired() && !alignment.getMate().isMapped()) {
            Graphics2D cRed = context.getGraphic2DForColor(Color.red);
            cRed.drawPolygon(xPoly, yPoly, xPoly.length);
        }
    }

    private void drawPairedAlignment(PairedAlignment pair, Rectangle rect, RenderContext context, AlignmentTrack.RenderOptions renderOptions, boolean leaveMargin, Map<String, Color> selectedReadNames, Font font) {
        double locScale = context.getScale();
        Color alignmentColor = this.getAlignmentColor(pair.firstAlignment, locScale, context.getReferenceFrame().getCenter(), renderOptions);
        Graphics2D g2 = context.getGraphic2DForColor(alignmentColor);
        g2.setFont(font);
        this.drawAlignment(pair.firstAlignment, rect, g2, context, alignmentColor, renderOptions, leaveMargin, selectedReadNames);
        if (pair.secondAlignment != null) {
            alignmentColor = this.getAlignmentColor(pair.secondAlignment, locScale, context.getReferenceFrame().getCenter(), renderOptions);
            g2 = context.getGraphic2DForColor(alignmentColor);
            this.drawAlignment(pair.secondAlignment, rect, g2, context, alignmentColor, renderOptions, leaveMargin, selectedReadNames);
            Graphics2D gLine = context.getGraphic2DForColor(grey1);
            double origin = context.getOrigin();
            int startX = (int)(((double)pair.firstAlignment.getEnd() - origin) / locScale);
            startX = Math.max(rect.x, startX);
            int endX = (int)(((double)pair.secondAlignment.getStart() - origin) / locScale);
            endX = Math.min(rect.x + rect.width, endX);
            int h2 = (int)Math.max(1.0, rect.getHeight() - (double)(leaveMargin ? 2 : 0));
            int y = (int)rect.getY();
            gLine.drawLine(startX, y + h2 / 2, endX, y + h2 / 2);
        }
    }

    private void drawAlignment(Alignment alignment, Rectangle rect, Graphics2D g2, RenderContext context, Color alignmentColor, AlignmentTrack.RenderOptions renderOptions, boolean leaveMargin, Map<String, Color> selectedReadNames) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        AlignmentBlock[] blocks = alignment.getAlignmentBlocks();
        if (blocks == null || blocks.length == 0) {
            this.drawSimpleAlignment(alignment, rect, g2, context, renderOptions.flagUnmappedPairs);
            return;
        }
        AlignmentBlock terminalBlock = alignment.isNegativeStrand() ? blocks[0] : blocks[blocks.length - 1];
        Graphics2D greyGraphics = context.getGraphic2DForColor(new Color(185, 185, 185));
        int lastBlockEnd = Integer.MIN_VALUE;
        int blockNumber = -1;
        char[] gapTypes = alignment.getGapTypes();
        boolean highZoom = locScale < 0.1251;
        for (AlignmentBlock aBlock : alignment.getAlignmentBlocks()) {
            boolean isZeroQuality;
            ++blockNumber;
            int x = (int)(((double)aBlock.getStart() - origin) / locScale);
            int w = (int)Math.ceil((double)aBlock.getBases().length / locScale);
            int h2 = (int)Math.max(1.0, rect.getHeight() - (double)(leaveMargin ? 2 : 0));
            int y = (int)rect.getY();
            boolean bl = isZeroQuality = alignment.getMappingQuality() == 0 && renderOptions.flagZeroQualityAlignments;
            if (highZoom && w > 10) {
                ++x;
                w -= 2;
            }
            if (x + w >= rect.x && (double)x <= rect.getMaxX()) {
                if (w <= 10 || h2 <= 10 || aBlock != terminalBlock) {
                    g2.fillRect(x, y, w, h2);
                    if (isZeroQuality) {
                        greyGraphics.drawRect(x, y, w - 1, h2);
                    }
                    if (renderOptions.flagUnmappedPairs && alignment.isPaired() && !alignment.getMate().isMapped()) {
                        Graphics2D cRed = context.getGraphic2DForColor(Color.red);
                        cRed.drawRect(x, y, w, h2);
                    }
                    if (selectedReadNames.containsKey(alignment.getReadName())) {
                        Color c2 = selectedReadNames.get(alignment.getReadName());
                        if (c2 == null) {
                            c2 = Color.blue;
                        }
                        Graphics2D cBlue = context.getGraphic2DForColor(c2);
                        Stroke s = cBlue.getStroke();
                        cBlue.setStroke(thickStroke);
                        cBlue.drawRect(x, y, w, h2);
                        cBlue.setStroke(s);
                    }
                } else {
                    int arrowLength = Math.min(5, w / 6);
                    if (x < rect.x && x + w > rect.x + rect.width) {
                        x = rect.x;
                        w = rect.width;
                        arrowLength = 0;
                    } else if (x < rect.x) {
                        int delta = rect.x - x;
                        x = rect.x;
                        w -= delta;
                        if (alignment.isNegativeStrand()) {
                            arrowLength = 0;
                        }
                    } else if (x + w > rect.x + rect.width) {
                        w -= x + w - (rect.x + rect.width);
                        if (!alignment.isNegativeStrand()) {
                            arrowLength = 0;
                        }
                    }
                    int[] yPoly = new int[]{y, y, y + h2 / 2, y + h2, y + h2};
                    int[] xPoly = alignment.isNegativeStrand() ? new int[]{x + w, x, x - arrowLength, x, x + w} : new int[]{x, x + w, x + w + arrowLength, x + w, x};
                    g2.fillPolygon(xPoly, yPoly, xPoly.length);
                    if (isZeroQuality) {
                        greyGraphics.drawPolygon(xPoly, yPoly, xPoly.length);
                    }
                    if (renderOptions.flagUnmappedPairs && alignment.isPaired() && !alignment.getMate().isMapped()) {
                        Graphics2D cRed = context.getGraphic2DForColor(Color.red);
                        cRed.drawPolygon(xPoly, yPoly, xPoly.length);
                    }
                    if (selectedReadNames.containsKey(alignment.getReadName())) {
                        Color c3 = selectedReadNames.get(alignment.getReadName());
                        if (c3 == null) {
                            c3 = Color.blue;
                        }
                        Graphics2D cBlue = context.getGraphic2DForColor(c3);
                        Stroke s = cBlue.getStroke();
                        cBlue.setStroke(thickStroke);
                        cBlue.drawPolygon(xPoly, yPoly, xPoly.length);
                        cBlue.setStroke(s);
                    }
                }
            }
            if (locScale < 5.0) {
                this.drawBases(context, rect, aBlock, alignmentColor, renderOptions.shadeBases, renderOptions.showAllBases);
            }
            if (lastBlockEnd > Integer.MIN_VALUE && x > rect.x) {
                Stroke stroke;
                Graphics2D gLine;
                int gapIdx = blockNumber - 1;
                Color gapLineColor = deletionColor;
                if (gapTypes != null && gapIdx < gapTypes.length && gapTypes[gapIdx] == 'N') {
                    gLine = context.getGraphic2DForColor(skippedColor);
                    stroke = gLine.getStroke();
                } else {
                    gLine = context.getGraphic2DForColor(gapLineColor);
                    stroke = gLine.getStroke();
                    gLine.setStroke(thickStroke);
                }
                int startX = Math.max(rect.x, lastBlockEnd);
                int endX = Math.min(rect.x + rect.width, x);
                gLine.drawLine(startX, y + h2 / 2, endX, y + h2 / 2);
                gLine.setStroke(stroke);
            }
            if ((double)(lastBlockEnd = x + w) > rect.getMaxX()) break;
        }
        if (locScale < 0.25) {
            this.drawInsertions(origin, rect, locScale, alignment, context);
        }
    }

    private void drawBases(RenderContext context, Rectangle rect, AlignmentBlock block, Color alignmentColor, boolean shadeBases, boolean showAllBases) {
        alignmentColor.getRGBColorComponents(alignComps);
        double locScale = context.getScale();
        double origin = context.getOrigin();
        String chr = context.getChr();
        Genome genome = IGV.getInstance().getGenomeManager().getCurrentGenome();
        byte[] read = block.getBases();
        boolean isSoftClipped = block.isSoftClipped();
        if (read != null && read.length > 0) {
            int pY = (int)rect.getY();
            int dY = (int)rect.getHeight();
            int dX = (int)Math.max(1.0, 1.0 / locScale);
            Graphics2D g2 = (Graphics2D)context.getGraphics().create();
            if (dX >= 8) {
                Font f2 = FontManager.getFont(1, Math.min(dX, 12));
                g2.setFont(f2);
            }
            int start = block.getStart();
            int end = start + read.length;
            byte[] reference = isSoftClipped ? null : genome.getSequence(chr, start, end);
            for (int loc = start; loc < end; ++loc) {
                int dW;
                int pX0;
                boolean misMatch;
                int idx = loc - start;
                byte refbase = reference[idx];
                byte readbase = read[idx];
                boolean bl = misMatch = isSoftClipped || readbase != 61 && reference != null && idx < reference.length && refbase != 0 && refbase != readbase && refbase - 32 != readbase;
                if (!misMatch && !showAllBases) continue;
                char c2 = (char)read[loc - start];
                Color color = nucleotideColors.get(Character.valueOf(c2));
                if (color == null) {
                    color = Color.black;
                }
                if (shadeBases) {
                    byte qual = block.qualities[loc - start];
                    color = this.getShadedColor(qual, color, this.prefs);
                }
                if ((double)(pX0 = (int)(((double)loc - origin) / locScale)) > rect.getMaxX()) break;
                if ((double)(pX0 + dX) < rect.getX()) continue;
                if (dX >= 8 && dY >= 12) {
                    g2.setColor(color);
                    this.drawCenteredText(g2, new char[]{c2}, pX0, pY + 1, dX, dY - 2);
                    continue;
                }
                int n2 = dW = dX > 4 ? dX - 1 : dX;
                if (color == null) continue;
                g2.setColor(color);
                if (dY < 10) {
                    g2.fillRect(pX0, pY, dX, dY);
                    continue;
                }
                g2.fillRect(pX0, pY + 1, dW, dY - 3);
            }
        }
    }

    private Color getShadedColor(byte qual, Color color, PreferenceManager prefs) {
        float alpha = 0.0f;
        int minQ = prefs.getAsInt("SAM.BASE_QUALITY_MIN");
        color.getRGBColorComponents(colorComps);
        if (qual < minQ) {
            alpha = 0.1f;
        } else {
            int maxQ = prefs.getAsInt("SAM.BASE_QUALITY_MAX");
            alpha = Math.max(0.1f, Math.min(1.0f, 0.1f + 0.9f * (float)(qual - minQ) / (float)(maxQ - minQ)));
        }
        alpha = (float)((int)(alpha * 10.0f + 0.5f)) / 10.0f;
        color = ColorUtilities.getCompositeColor(alignComps, colorComps, alpha);
        return color;
    }

    private void drawCenteredText(Graphics2D g2, char[] chars, int x, int y, int w, int h2) {
        FontMetrics fm = g2.getFontMetrics();
        int msg_width = fm.charsWidth(chars, 0, 1);
        int ascent = fm.getMaxAscent();
        int descent = fm.getMaxDescent();
        int msgX = x + w / 2 - msg_width / 2;
        int msgY = y + h2 / 2 - descent / 2 + ascent / 2;
        g2.drawChars(chars, 0, 1, msgX, msgY);
    }

    private void drawInsertions(double origin, Rectangle rect, double locScale, Alignment alignment, RenderContext context) {
        Graphics2D gInsertion = context.getGraphic2DForColor(purple);
        AlignmentBlock[] insertions = alignment.getInsertions();
        if (insertions != null) {
            for (AlignmentBlock aBlock : insertions) {
                int x = (int)(((double)aBlock.getStart() - origin) / locScale);
                int h2 = (int)Math.max(1.0, rect.getHeight() - 2.0);
                int y = (int)(rect.getY() + (rect.getHeight() - (double)h2) / 2.0);
                if ((double)x > rect.getMaxX()) break;
                if ((double)x < rect.getX()) continue;
                gInsertion.fillRect(x - 2, y, 4, 2);
                gInsertion.fillRect(x - 1, y, 2, h2);
                gInsertion.fillRect(x - 2, y + h2 - 2, 4, 2);
            }
        }
    }

    private Color getAlignmentColor(Alignment alignment, double locScale, double center, AlignmentTrack.RenderOptions renderOptions) {
        String lb = alignment.getLibrary();
        if (lb == null) {
            lb = "null";
        }
        PEStats peStats = renderOptions.peStats.get(lb);
        Color c2 = alignment.getDefaultColor();
        switch (renderOptions.colorOption) {
            case INSERT_SIZE: {
                boolean sameChr;
                boolean isPairedAlignment = alignment instanceof PairedAlignment;
                if ((!alignment.isPaired() || !alignment.getMate().isMapped()) && !isPairedAlignment) break;
                boolean bl = sameChr = isPairedAlignment || alignment.getMate().getChr().equals(alignment.getChr());
                if (sameChr) {
                    int readDistance = Math.abs(alignment.getInferredInsertSize());
                    if (readDistance <= 0) break;
                    int minThreshold = renderOptions.getMinInsertSize();
                    int maxThreshold = renderOptions.getMaxInsertSize();
                    if (renderOptions.isComputeIsizes() && renderOptions.peStats != null && peStats != null) {
                        minThreshold = peStats.getMinThreshold();
                        maxThreshold = peStats.getMaxThreshold();
                    }
                    if (readDistance < minThreshold) {
                        c2 = smallISizeColor;
                        break;
                    }
                    if (readDistance <= maxThreshold) break;
                    c2 = largeISizeColor;
                    break;
                }
                c2 = ChromosomeColors.getColor(alignment.getMate().getChr());
                if (c2 != null) break;
                c2 = Color.black;
                break;
            }
            case PAIR_ORIENTATION: {
                c2 = this.getOrientationColor(alignment, peStats);
                break;
            }
            case READ_STRAND: {
                if (alignment.isNegativeStrand()) {
                    c2 = negStrandColor;
                    break;
                }
                c2 = posStrandColor;
                break;
            }
            case FRAGMENT_STRAND: {
                if (alignment.getFragmentStrand(1) == Strand.NEGATIVE) {
                    c2 = negStrandColor;
                    break;
                }
                if (alignment.getFragmentStrand(1) != Strand.POSITIVE) break;
                c2 = posStrandColor;
                break;
            }
            case READ_GROUP: {
                String rg = alignment.getReadGroup();
                if (rg == null || (c2 = readGroupColors.get(rg)) != null) break;
                c2 = ColorUtilities.randomColor(readGroupColors.size() + 1);
                readGroupColors.put(rg, c2);
                break;
            }
            case SAMPLE: {
                String sample = alignment.getSample();
                if (sample == null || (c2 = readGroupColors.get(sample)) != null) break;
                c2 = ColorUtilities.randomColor(readGroupColors.size() + 1);
                readGroupColors.put(sample, c2);
                break;
            }
            default: {
                if (!renderOptions.shadeCenters || !(center >= (double)alignment.getStart()) || !(center <= (double)alignment.getEnd()) || !(locScale < 1.0)) break;
                c2 = grey2;
            }
        }
        if (alignment.getMappingQuality() == 0 && renderOptions.flagZeroQualityAlignments) {
            float alpha = 0.15f;
            c2.getColorComponents(rbgBuffer);
            return ColorUtilities.getCompositeColor(whiteComponents, rbgBuffer, alpha);
        }
        return c2;
    }

    private Color getOrientationColor(Alignment alignment, PEStats peStats) {
        Color c2 = null;
        if (!alignment.isProperPair()) {
            String pairOrientation = alignment.getPairOrientation();
            if (peStats != null) {
                PEStats.Orientation libraryOrientation = peStats.getOrientation();
                switch (libraryOrientation) {
                    case FR: {
                        if (alignment.isSmallInsert()) break;
                        c2 = frOrientationColors.get(pairOrientation);
                        break;
                    }
                    case RF: {
                        c2 = rfOrientationColors.get(pairOrientation);
                        break;
                    }
                    case FF: {
                        c2 = ffOrientationColors.get(pairOrientation);
                    }
                }
            } else {
                c2 = alignment.getAttribute("CS") != null ? ffOrientationColors.get(pairOrientation) : frOrientationColors.get(pairOrientation);
            }
        }
        return c2 == null ? grey1 : c2;
    }

    public static Map<Character, Color> getNucleotideColors() {
        return nucleotideColors;
    }

    static {
        smallISizeColor = new Color(0, 0, 150);
        largeISizeColor = new Color(150, 0, 0);
        purple = new Color(118, 24, 220);
        deletionColor = Color.black;
        skippedColor = new Color(150, 184, 200);
        rbgBuffer = new float[3];
        colorComps = new float[3];
        alignComps = new float[3];
        whiteComponents = Color.white.getRGBColorComponents(null);
        grey2 = new Color(165, 165, 165);
        grey1 = new Color(200, 200, 200);
        thickStroke = new BasicStroke(2.0f);
        negStrandColor = new Color(110, 145, 225);
        posStrandColor = new Color(165, 35, 39);
        readGroupColors = new HashMap();
        LR_COLOR = grey1;
        RL_COLOR = new Color(0, 150, 0);
        RR_COLOR = new Color(0, 0, 150);
        LL_COLOR = new Color(0, 150, 150);
        nucleotideColors = new HashMap<Character, Color>();
        nucleotideColors.put(Character.valueOf('A'), Color.GREEN);
        nucleotideColors.put(Character.valueOf('a'), Color.GREEN);
        nucleotideColors.put(Character.valueOf('C'), Color.BLUE);
        nucleotideColors.put(Character.valueOf('c'), Color.BLUE);
        nucleotideColors.put(Character.valueOf('T'), Color.RED);
        nucleotideColors.put(Character.valueOf('t'), Color.RED);
        nucleotideColors.put(Character.valueOf('G'), new Color(209, 113, 5));
        nucleotideColors.put(Character.valueOf('g'), new Color(209, 113, 5));
        nucleotideColors.put(Character.valueOf('N'), Color.gray.brighter());
        nucleotideColors.put(Character.valueOf('n'), Color.gray.brighter());
        frOrientationColors = new HashMap<String, Color>();
        frOrientationColors.put("F1R2", LR_COLOR);
        frOrientationColors.put("F2R1", LR_COLOR);
        frOrientationColors.put("F R ", LR_COLOR);
        frOrientationColors.put("F1F2", LL_COLOR);
        frOrientationColors.put("F2F1", LL_COLOR);
        frOrientationColors.put("F F ", LL_COLOR);
        frOrientationColors.put("FF", LL_COLOR);
        frOrientationColors.put("R1R2", RR_COLOR);
        frOrientationColors.put("R2R1", RR_COLOR);
        frOrientationColors.put("R R ", RR_COLOR);
        frOrientationColors.put("RR", RR_COLOR);
        frOrientationColors.put("R1F2", RL_COLOR);
        frOrientationColors.put("R2F1", RL_COLOR);
        frOrientationColors.put("R F ", RL_COLOR);
        rfOrientationColors = new HashMap<String, Color>();
        rfOrientationColors.put("R1F2", LR_COLOR);
        rfOrientationColors.put("R2F1", LR_COLOR);
        rfOrientationColors.put("R F ", LR_COLOR);
        rfOrientationColors.put("R1R2", LL_COLOR);
        rfOrientationColors.put("R2R1", LL_COLOR);
        rfOrientationColors.put("R r ", LL_COLOR);
        rfOrientationColors.put("F1F2", RR_COLOR);
        rfOrientationColors.put("F2F1", RR_COLOR);
        rfOrientationColors.put("F F ", RR_COLOR);
        rfOrientationColors.put("F1R2", RL_COLOR);
        rfOrientationColors.put("F2R1", RL_COLOR);
        rfOrientationColors.put("F R ", RL_COLOR);
        ffOrientationColors = new HashMap<String, Color>();
        ffOrientationColors.put("F1F2", LR_COLOR);
        ffOrientationColors.put("R2R1", LR_COLOR);
        ffOrientationColors.put("F1R2", RR_COLOR);
        ffOrientationColors.put("R2F1", RR_COLOR);
        ffOrientationColors.put("R1F2", LL_COLOR);
        ffOrientationColors.put("F2R1", LL_COLOR);
        ffOrientationColors.put("R1R2", RL_COLOR);
        ffOrientationColors.put("F2F1", RL_COLOR);
    }
}

