/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.peaks;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.tdf.BufferedByteWriter;
import org.broad.igv.tools.sort.Sorter;
import org.broad.igv.util.CompressionUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.tribble.readers.AsciiLineReader;
import org.broad.tribble.util.LittleEndianOutputStream;

public class BedToPeaks {
    private static Map<String, String> colorMap;

    public static void main(String[] args) throws IOException {
        File inputDir = new File("/Users/jrobinso/IGV/ichip/bed/");
        File destDir = new File("/Users/jrobinso/IGV/ichip/peaks");
        BedToPeaks.convertAll(inputDir, destDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createCfgFile(String factor, File outputDir) throws IOException {
        String c2;
        int[] times = new int[]{0, 30, 60, 120};
        if (colorMap == null) {
            colorMap = BedToPeaks.loadColors("/Users/jrobinso/IGV/time_course/colors.txt");
        }
        if ((c2 = colorMap.get(factor)) == null) {
            System.out.println("No color found for " + factor);
            c2 = "0,0,150";
        }
        PrintWriter cfgWriter = null;
        try {
            File cfgFile = new File(outputDir, factor + ".peak.cfg");
            cfgWriter = new PrintWriter(new BufferedWriter(new FileWriter(cfgFile)));
            String peeksFile = factor + ".peak";
            String peaks = "http://www.broadinstitute.org/igvdata/ichip/peaks/" + peeksFile;
            String tdf = "http://www.broadinstitute.org/igvdata/ichip/tdf/compressed/" + factor + ".merged.bam.tdf";
            String bam = "http://www.broadinstitute.org/igvdata/ichip/compressed/" + factor + "/" + factor + ".merged.bam";
            cfgWriter.println("track name=" + factor + " sample=" + factor + " viewLimits=0:100 useScore=1 color=" + c2);
            cfgWriter.println("timePoints=0,30,60,120");
            cfgWriter.println("peaks=" + peaks);
            cfgWriter.println("signals=" + tdf);
            cfgWriter.print("timeSignals=");
            String root = "http://www.broadinstitute.org/igvdata/ichip/tdf/timecourses/";
            for (int t : times) {
                cfgWriter.print(root + factor + "_" + t + "/" + factor + "_" + t + ".merged.bam.tdf,");
            }
            cfgWriter.println();
            cfgWriter.println("#index");
            File pf = new File(outputDir, peeksFile);
            BedToPeaks.indexPeakFile(pf, cfgWriter);
        }
        finally {
            if (cfgWriter != null) {
                cfgWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void indexPeakFile(File peeksFile, PrintWriter cfgWriter) {
        AsciiLineReader reader = null;
        try {
            String nextLine;
            reader = ParsingUtils.openAsciiReader(new ResourceLocator(peeksFile.getAbsolutePath()));
            reader.readLine();
            reader.readLine();
            String lastChr = "";
            long position = reader.getPosition();
            while ((nextLine = reader.readLine()) != null) {
                String chr = nextLine.split("\t")[0];
                if (!chr.equals(lastChr)) {
                    cfgWriter.println(chr + "\t" + position);
                }
                position = reader.getPosition();
                lastChr = chr;
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createBinaryPeakFile(String factor, List<File> bedFiles, File outputDir) throws IOException {
        BufferedReader[] readers;
        block16: {
            readers = new BufferedReader[bedFiles.size()];
            FilterOutputStream peakWriter = null;
            File peeksFile = null;
            long indexPosition = 0L;
            try {
                for (int i2 = 0; i2 < bedFiles.size(); ++i2) {
                    readers[i2] = new BufferedReader(new FileReader(bedFiles.get(i2)));
                }
                peeksFile = new File(outputDir, factor + ".peak.bin");
                peakWriter = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(peeksFile)));
                if (peakWriter != null) {
                    LinkedHashMap<String, Long> chrIndex = new LinkedHashMap<String, Long>();
                    String[] line = new String[readers.length];
                    int nTimePoints = readers.length - 1;
                    ((LittleEndianOutputStream)peakWriter).writeLong(0L);
                    ((LittleEndianOutputStream)peakWriter).writeInt(nTimePoints);
                    String lastChr = "";
                    ArrayList<PeakRecord> records = new ArrayList<PeakRecord>(20000);
                    while (true) {
                        String chr = null;
                        String[] tokens = null;
                        for (int i3 = 0; i3 < readers.length; ++i3) {
                            line[i3] = readers[i3].readLine();
                            if (line[i3] == null) break;
                        }
                        if (line[0] != null) {
                            if (line[0].startsWith("#") || line[0].startsWith("track")) continue;
                            tokens = line[0].split("\t");
                            chr = tokens[0];
                        }
                        if ((chr == null && lastChr != null || !chr.equals(lastChr)) && records.size() > 0) {
                            chrIndex.put(lastChr, ((LittleEndianOutputStream)peakWriter).getWrittenCount());
                            BufferedByteWriter buffer = new BufferedByteWriter(100000);
                            buffer.putNullTerminatedString(lastChr);
                            buffer.putInt(records.size());
                            for (PeakRecord record : records) {
                                buffer.putInt(record.start);
                                buffer.putInt(record.end);
                                buffer.putFloat(record.score);
                                for (int i4 = 0; i4 < record.timeScores.length; ++i4) {
                                    buffer.putFloat(record.timeScores[i4]);
                                }
                            }
                            records.clear();
                            byte[] bytes = buffer.getBytes();
                            bytes = CompressionUtils.compress(bytes);
                            ((LittleEndianOutputStream)peakWriter).writeInt(bytes.length);
                            peakWriter.write(bytes);
                        }
                        if (chr == null) break;
                        lastChr = chr;
                        int start = Integer.parseInt((String)tokens[1]);
                        int end = Integer.parseInt(tokens[2]);
                        float score = Float.parseFloat(tokens[4]);
                        float[] timeScores = new float[nTimePoints];
                        for (int i5 = 0; i5 < nTimePoints; ++i5) {
                            tokens = line[i5 + 1].split("\t");
                            if (!tokens[0].equals(chr) || Integer.parseInt(tokens[1]) != start || Integer.parseInt(tokens[2]) != end) {
                                throw new RuntimeException("Unordered files");
                            }
                            timeScores[i5] = Float.parseFloat(tokens[4]);
                        }
                        records.add(new PeakRecord(start, end, score, timeScores));
                    }
                    indexPosition = ((LittleEndianOutputStream)peakWriter).getWrittenCount();
                    ((LittleEndianOutputStream)peakWriter).writeInt(chrIndex.size());
                    for (Map.Entry entry : chrIndex.entrySet()) {
                        ((LittleEndianOutputStream)peakWriter).writeString((String)entry.getKey());
                        ((LittleEndianOutputStream)peakWriter).writeLong((Long)entry.getValue());
                    }
                }
                if (peakWriter == null) break block16;
            }
            catch (Throwable throwable) {
                if (peakWriter != null) {
                    peakWriter.close();
                    BedToPeaks.writeIndexPosition(peeksFile, indexPosition);
                }
                for (BufferedReader reader : readers) {
                    reader.close();
                }
                throw throwable;
            }
            peakWriter.close();
            BedToPeaks.writeIndexPosition(peeksFile, indexPosition);
        }
        for (BufferedReader reader : readers) {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeIndexPosition(File file, long indexPosition) throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "rw");
            raf.getChannel().position(0L);
            BufferedByteWriter buffer = new BufferedByteWriter();
            buffer.putLong(indexPosition);
            raf.write(buffer.getBytes());
            raf.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void createPeakFile(String factor, List<File> bedFiles, File outputDir) throws IOException {
        times = new int[]{0, 30, 60, 120};
        if (BedToPeaks.colorMap == null) {
            BedToPeaks.colorMap = BedToPeaks.loadColors("/Users/jrobinso/IGV/time_course/colors.txt");
        }
        if ((c = BedToPeaks.colorMap.get(factor)) == null) {
            System.out.println("No color found for " + factor);
            c = "0,0,150";
        }
        readers = new BufferedReader[bedFiles.size()];
        peakWriter = null;
        cfgWriter = null;
        try {
            for (i = 0; i < bedFiles.size(); ++i) {
                readers[i] = new BufferedReader(new FileReader(bedFiles.get(i)));
            }
            peeksFile = new File(outputDir, factor + ".peak");
            peakWriter = new PrintWriter(new BufferedWriter(new FileWriter(peeksFile)));
            peaks = "http://www.broadinstitute.org/igvdata/ichip/peaks/" + peeksFile.getName();
            tdf = "http://www.broadinstitute.org/igvdata/ichip/tdf/compressed/" + factor + ".merged.bam.tdf";
            bam = "http://www.broadinstitute.org/igvdata/ichip/compressed/" + factor + "/" + factor + ".merged.bam";
            if (peakWriter != null) {
                peakWriter.println("track name=" + factor + " sample=" + factor + " viewLimits=0:100 useScore=1 color=" + c);
                for (File f : bedFiles) {
                    peakWriter.print("\t" + f.getName().replace(".bed", ""));
                }
                peakWriter.println();
                line = new String[readers.length];
                while (true) {
                    for (i = 0; i < readers.length; ++i) {
                        line[i] = readers[i].readLine();
                        if (line[i] != null) continue;
                        return;
                    }
                    if (line[0].startsWith("#") || line[0].startsWith("track")) ** continue;
                    tokens = line[0].split("\t");
                    chr = tokens[0];
                    start = Integer.parseInt(tokens[1]);
                    end = Integer.parseInt(tokens[2]);
                    name = tokens[3];
                    score = Float.parseFloat(tokens[4]);
                    peakWriter.print(chr + "\t" + start + "\t" + end + "\t" + name + "\t" + score);
                    for (i = 1; i < line.length; ++i) {
                        tokens = line[i].split("\t");
                        if (!tokens[0].equals(chr) || Integer.parseInt(tokens[1]) != start || Integer.parseInt(tokens[2]) != end) {
                            throw new RuntimeException("Unordered files");
                        }
                        score = Float.parseFloat(tokens[4]);
                        peakWriter.print("\t" + score);
                    }
                    peakWriter.println();
                }
            }
        }
        finally {
            if (peakWriter != null) {
                peakWriter.close();
            }
            if (cfgWriter != null) {
                cfgWriter.close();
            }
            for (BufferedReader reader : readers) {
                reader.close();
            }
        }
    }

    public static void sortAll(String rootDir) throws IOException {
        for (File f2 : new File(rootDir).listFiles()) {
            File of;
            if (!f2.getName().endsWith(".bed") || f2.getName().endsWith(".sorted.bed") || (of = new File(f2.getAbsolutePath().replace(".bed", ".sorted.bed"))).exists()) continue;
            System.out.println("Sorting " + f2.getName());
            Sorter sorter = Sorter.getSorter(f2, of);
            sorter.run();
        }
    }

    public static void convertAll(File rootDir, File destDir) throws IOException {
        String factor;
        File factorFile = new File("/Users/jrobinso/IGV/ichip/bed/factors.txt");
        int[] time = new int[]{0, 30, 60, 120};
        BufferedReader reader = new BufferedReader(new FileReader(factorFile));
        while ((factor = reader.readLine()) != null) {
            factor = factor.trim();
            ArrayList<File> bedFiles = new ArrayList<File>();
            File bedFile = new File(rootDir, factor + ".peaks.filtered.by.fold.real.sorted.bed");
            if (bedFile.exists()) {
                bedFiles.add(bedFile);
            } else {
                System.out.println("Can't find " + bedFile.getName());
            }
            for (int i2 = 0; i2 < time.length; ++i2) {
                bedFile = new File(rootDir, factor + "_" + time[i2] + ".peaks.filtered.by.fold.real.sorted.bed");
                if (bedFile.exists()) {
                    bedFiles.add(bedFile);
                    continue;
                }
                System.out.println("Can't find " + bedFile.getName());
            }
            BedToPeaks.createBinaryPeakFile(factor, bedFiles, destDir);
        }
        reader.close();
    }

    public static void downloadAll(String rootDir, File destDir) throws IOException {
        String factor;
        File factorFile = new File("/Users/jrobinso/IGV/time_course/factors.txt");
        int[] time = new int[]{0, 30, 60, 120};
        BufferedReader reader = new BufferedReader(new FileReader(factorFile));
        while ((factor = reader.readLine()) != null) {
            factor = factor.trim();
            ArrayList bedFiles = new ArrayList();
            String segments = factor.equals("K4me3") || factor.equals("K4me1") || factor.equals("K27Ac") ? "/segments_0.01/" : "/segments_0.05/";
            File bedFile = new File(rootDir + factor + segments + factor + ".peaks.filtered.by.fold.real.bed");
            if (bedFile.exists()) {
                System.out.println("Copying " + bedFile.getName());
                FileUtils.copyFile(bedFile, new File(destDir, bedFile.getName()));
            } else {
                System.out.println("File not found: " + bedFile);
            }
            for (int i2 = 0; i2 < time.length; ++i2) {
                bedFile = new File(rootDir + "timecourses/" + factor + "_" + time[i2] + segments + factor + "_" + time[i2] + ".peaks.filtered.by.fold.real.bed");
                if (!bedFile.exists()) continue;
                System.out.println("Copying " + bedFile.getName());
                FileUtils.copyFile(bedFile, new File(destDir, bedFile.getName()));
            }
        }
        reader.close();
    }

    public static Map<String, String> loadColors(String file) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        HashMap<String, String> map = new HashMap<String, String>();
        while ((line = reader.readLine()) != null) {
            String[] tokens = line.split("\t");
            map.put(tokens[0], tokens[1]);
        }
        reader.close();
        return map;
    }

    static class PeakRecord {
        int start;
        int end;
        float score;
        float[] timeScores;

        PeakRecord(int start, int end, float score, float[] timeScores) {
            this.start = start;
            this.end = end;
            this.score = score;
            this.timeScores = timeScores;
        }
    }
}

