/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math.stat.StatUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.collections.IntArrayList;

public class ProcessingUtils {
    protected static int[] findBoundaries(List<LocusScore> scores) {
        int[] boundaries = new int[2 * scores.size() + 1];
        for (int i2 = 0; i2 < scores.size(); ++i2) {
            LocusScore score = scores.get(i2);
            boundaries[2 * i2] = score.getStart();
            boundaries[2 * i2 + 1] = score.getEnd();
        }
        Arrays.sort(boundaries);
        IntArrayList boundaryList = new IntArrayList(boundaries.length);
        int lastPos = -1;
        for (int i3 = 0; i3 < boundaries.length; ++i3) {
            if (boundaries[i3] == lastPos) continue;
            lastPos = boundaries[i3];
            boundaryList.add(lastPos);
        }
        boundaries = boundaryList.toArray();
        return boundaries;
    }

    private static boolean nullDataCheck(float[] data) {
        boolean noData = true;
        if (data != null && data.length > 0) {
            for (int i2 = 0; i2 < data.length; ++i2) {
                if (Float.isNaN(data[i2])) continue;
                noData = false;
                break;
            }
        }
        return noData;
    }

    private static float computeQuantile(float[] data, double quantile) {
        double[] dData = new double[data.length];
        for (int i2 = 0; i2 < data.length; ++i2) {
            dData[i2] = data[i2];
        }
        return (float)StatUtils.percentile(dData, quantile);
    }

    private static float computeMin(float[] data) {
        float min = Float.MAX_VALUE;
        for (int i2 = 0; i2 < data.length; ++i2) {
            if (Float.isNaN(data[i2])) continue;
            min = Math.min(data[i2], min);
        }
        return min;
    }

    private static float computeMax(float[] data) {
        float max = -3.4028235E38f;
        for (int i2 = 0; i2 < data.length; ++i2) {
            if (Float.isNaN(data[i2])) continue;
            max = Math.max(data[i2], max);
        }
        return max;
    }

    private static float computeMean(float[] data) {
        float sum = 0.0f;
        int nPts = 0;
        for (int i2 = 0; i2 < data.length; ++i2) {
            if (Float.isNaN(data[i2])) continue;
            sum += data[i2];
            ++nPts;
        }
        return nPts == 0 ? Float.NaN : sum / (float)nPts;
    }

    public static float computeStat(float[] data, WindowFunction function) {
        if (ProcessingUtils.nullDataCheck(data)) {
            return Float.NaN;
        }
        switch (function) {
            case mean: {
                return ProcessingUtils.computeMean(data);
            }
            case median: {
                return ProcessingUtils.computeQuantile(data, 50.0);
            }
            case min: {
                return ProcessingUtils.computeMin(data);
            }
            case max: {
                return ProcessingUtils.computeMax(data);
            }
            case percentile2: {
                return ProcessingUtils.computeQuantile(data, 2.0);
            }
            case percentile10: {
                return ProcessingUtils.computeQuantile(data, 10.0);
            }
            case percentile90: {
                return ProcessingUtils.computeQuantile(data, 90.0);
            }
            case percentile98: {
                return ProcessingUtils.computeQuantile(data, 98.0);
            }
            case count: {
                return data.length;
            }
        }
        return Float.NaN;
    }

    static class Interval {
        int start;
        int end;
        List<LocusScore> scores = new ArrayList<LocusScore>(3);

        public Interval(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

