/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.batch;

import java.io.BufferedReader;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.batch.CommandExecutor;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.ParsingUtils;

public class BatchRunner
implements NamedRunnable {
    private static Logger log = Logger.getLogger(BatchRunner.class);
    String inputFile;

    public BatchRunner(String inputFile) {
        this.inputFile = inputFile;
    }

    @Override
    public String getName() {
        return "batchExecution";
    }

    @Override
    public void run() {
        CommandExecutor cmdExe = new CommandExecutor();
        Globals.setSuppressMessages(true);
        Globals.batch = true;
        WaitCursorManager.CursorToken cursorToken = null;
        BufferedReader reader = null;
        try {
            String inLine;
            cursorToken = WaitCursorManager.showWaitCursor();
            reader = ParsingUtils.openBufferedReader(this.inputFile);
            while ((inLine = reader.readLine()) != null) {
                if (inLine.startsWith("#") || inLine.startsWith("//")) continue;
                log.info("Executing Command: " + inLine);
                cmdExe.execute(inLine);
            }
        }
        catch (IOException ioe) {
            throw new DataLoadException(ioe.getMessage(), this.inputFile);
        }
        finally {
            Globals.setSuppressMessages(false);
            Globals.batch = false;
            if (cursorToken != null) {
                WaitCursorManager.removeWaitCursor(cursorToken);
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBatchFile(String resource) {
        BufferedReader reader = null;
        try {
            reader = ParsingUtils.openBufferedReader(resource);
            String firstLine = reader.readLine();
            boolean bl = firstLine.startsWith("#batch");
            return bl;
        }
        catch (IOException e2) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
    }
}

