/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.math.BigDecimal;
import org.apache.commons.math.linear.BigMatrix;
import org.apache.commons.math.linear.BigMatrixImpl;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealMatrixImpl;

public class MatrixUtils {
    public static RealMatrix createRealMatrix(double[][] data) {
        return new RealMatrixImpl(data);
    }

    public static RealMatrix createRealIdentityMatrix(int dimension) {
        RealMatrixImpl out = new RealMatrixImpl(dimension, dimension);
        double[][] d2 = out.getDataRef();
        int row = 0;
        while (row < dimension) {
            int col = 0;
            while (col < dimension) {
                d2[row][col] = row == col ? 1.0 : 0.0;
                ++col;
            }
            ++row;
        }
        return out;
    }

    public static BigMatrix createBigMatrix(double[][] data) {
        return new BigMatrixImpl(data);
    }

    public static BigMatrix createBigMatrix(BigDecimal[][] data) {
        return new BigMatrixImpl(data);
    }

    public static BigMatrix createBigMatrix(String[][] data) {
        return new BigMatrixImpl(data);
    }

    public static RealMatrix createRowRealMatrix(double[] rowData) {
        int nCols = rowData.length;
        double[][] data = new double[1][nCols];
        System.arraycopy(rowData, 0, data[0], 0, nCols);
        return new RealMatrixImpl(data);
    }

    public static BigMatrix createRowBigMatrix(double[] rowData) {
        int nCols = rowData.length;
        double[][] data = new double[1][nCols];
        System.arraycopy(rowData, 0, data[0], 0, nCols);
        return new BigMatrixImpl(data);
    }

    public static BigMatrix createRowBigMatrix(BigDecimal[] rowData) {
        int nCols = rowData.length;
        BigDecimal[][] data = new BigDecimal[1][nCols];
        System.arraycopy(rowData, 0, data[0], 0, nCols);
        return new BigMatrixImpl(data);
    }

    public static BigMatrix createRowBigMatrix(String[] rowData) {
        int nCols = rowData.length;
        String[][] data = new String[1][nCols];
        System.arraycopy(rowData, 0, data[0], 0, nCols);
        return new BigMatrixImpl(data);
    }

    public static RealMatrix createColumnRealMatrix(double[] columnData) {
        int nRows = columnData.length;
        double[][] data = new double[nRows][1];
        int row = 0;
        while (row < nRows) {
            data[row][0] = columnData[row];
            ++row;
        }
        return new RealMatrixImpl(data);
    }

    public static BigMatrix createColumnBigMatrix(double[] columnData) {
        int nRows = columnData.length;
        double[][] data = new double[nRows][1];
        int row = 0;
        while (row < nRows) {
            data[row][0] = columnData[row];
            ++row;
        }
        return new BigMatrixImpl(data);
    }

    public static BigMatrix createColumnBigMatrix(BigDecimal[] columnData) {
        int nRows = columnData.length;
        BigDecimal[][] data = new BigDecimal[nRows][1];
        int row = 0;
        while (row < nRows) {
            data[row][0] = columnData[row];
            ++row;
        }
        return new BigMatrixImpl(data);
    }

    public static BigMatrix createColumnBigMatrix(String[] columnData) {
        int nRows = columnData.length;
        String[][] data = new String[nRows][1];
        int row = 0;
        while (row < nRows) {
            data[row][0] = columnData[row];
            ++row;
        }
        return new BigMatrixImpl(data);
    }

    public static BigMatrix createBigIdentityMatrix(int dimension) {
        BigMatrixImpl out = new BigMatrixImpl(dimension, dimension);
        BigDecimal[][] d2 = out.getDataRef();
        int row = 0;
        while (row < dimension) {
            int col = 0;
            while (col < dimension) {
                d2[row][col] = row == col ? BigMatrixImpl.ONE : BigMatrixImpl.ZERO;
                ++col;
            }
            ++row;
        }
        return out;
    }
}

