/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value;

import org.apache.batik.css.engine.value.Messages;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.DOMException;

public abstract class AbstractValueFactory {
    public abstract String getPropertyName();

    protected static String resolveURI(ParsedURL base, String value) {
        return new ParsedURL(base, value).toString();
    }

    protected DOMException createInvalidIdentifierDOMException(String ident) {
        Object[] p2 = new Object[]{this.getPropertyName(), ident};
        String s = Messages.formatMessage("invalid.identifier", p2);
        return new DOMException(12, s);
    }

    protected DOMException createInvalidLexicalUnitDOMException(short type) {
        Object[] p2 = new Object[]{this.getPropertyName(), new Integer(type)};
        String s = Messages.formatMessage("invalid.lexical.unit", p2);
        return new DOMException(9, s);
    }

    protected DOMException createInvalidFloatTypeDOMException(short t) {
        Object[] p2 = new Object[]{this.getPropertyName(), new Integer(t)};
        String s = Messages.formatMessage("invalid.float.type", p2);
        return new DOMException(15, s);
    }

    protected DOMException createInvalidFloatValueDOMException(float f2) {
        Object[] p2 = new Object[]{this.getPropertyName(), new Float(f2)};
        String s = Messages.formatMessage("invalid.float.value", p2);
        return new DOMException(15, s);
    }

    protected DOMException createInvalidStringTypeDOMException(short t) {
        Object[] p2 = new Object[]{this.getPropertyName(), new Integer(t)};
        String s = Messages.formatMessage("invalid.string.type", p2);
        return new DOMException(15, s);
    }

    protected DOMException createMalformedLexicalUnitDOMException() {
        Object[] p2 = new Object[]{this.getPropertyName()};
        String s = Messages.formatMessage("malformed.lexical.unit", p2);
        return new DOMException(15, s);
    }

    protected DOMException createDOMException() {
        Object[] p2 = new Object[]{this.getPropertyName()};
        String s = Messages.formatMessage("invalid.access", p2);
        return new DOMException(9, s);
    }
}

