/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.hints;

import com.jidesoft.hints.IntelliHints;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.popup.JidePopupFactory;
import com.jidesoft.swing.DelegateAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public abstract class AbstractIntelliHints
implements IntelliHints {
    private JidePopup _popup;
    private JTextComponent _textComponent;
    private boolean _followCaret = false;
    private boolean _keyTyped = false;
    private boolean _autoPopup = true;
    private DelegateAction acceptAction = new DelegateAction(){

        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            IntelliHints intelliHints = AbstractIntelliHints.getIntelliHints(jComponent);
            if (intelliHints instanceof AbstractIntelliHints) {
                JButton jButton;
                AbstractIntelliHints abstractIntelliHints = (AbstractIntelliHints)intelliHints;
                abstractIntelliHints.hideHintsPopup();
                if (abstractIntelliHints.getSelectedHint() != null) {
                    abstractIntelliHints.setHintsEnabled(false);
                    abstractIntelliHints.acceptHint(intelliHints.getSelectedHint());
                    abstractIntelliHints.setHintsEnabled(true);
                    return true;
                }
                if (AbstractIntelliHints.this.getTextComponent().getRootPane() != null && (jButton = AbstractIntelliHints.this.getTextComponent().getRootPane().getDefaultButton()) != null) {
                    jButton.doClick();
                    return true;
                }
            }
            return false;
        }
    };
    private static DelegateAction showAction = new DelegateAction(){

        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            IntelliHints intelliHints = AbstractIntelliHints.getIntelliHints(jComponent);
            if (intelliHints instanceof AbstractIntelliHints) {
                AbstractIntelliHints abstractIntelliHints = (AbstractIntelliHints)intelliHints;
                if (jComponent.isEnabled() && !abstractIntelliHints.isHintsPopupVisible()) {
                    abstractIntelliHints.showHintsPopup();
                    return true;
                }
            }
            return false;
        }
    };
    private DelegateAction hideAction = new DelegateAction(){

        public boolean isEnabled() {
            return AbstractIntelliHints.this._textComponent.isEnabled() && AbstractIntelliHints.this.isHintsPopupVisible();
        }

        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            if (this.isEnabled()) {
                AbstractIntelliHints.this.hideHintsPopup();
                return true;
            }
            return false;
        }
    };
    private DocumentListener documentListener = new DocumentListener(){
        private Timer timer = new Timer(200, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AbstractIntelliHints.this.isKeyTyped()) {
                    if (AbstractIntelliHints.this.isHintsPopupVisible() || AbstractIntelliHints.this.isAutoPopup()) {
                        AbstractIntelliHints.this.showHintsPopup();
                    }
                    AbstractIntelliHints.this.setKeyTyped(false);
                }
            }
        });

        public void insertUpdate(DocumentEvent documentEvent) {
            this.startTimer();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.startTimer();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        void startTimer() {
            if (this.timer.isRunning()) {
                this.timer.restart();
            } else {
                this.timer.setRepeats(false);
                this.timer.start();
            }
        }
    };

    public AbstractIntelliHints(JTextComponent jTextComponent) {
        KeyStroke[] keyStrokeArray;
        this._textComponent = jTextComponent;
        this.getTextComponent().putClientProperty("INTELLI_HINTS", this);
        this._popup = this.createPopup();
        this.getTextComponent().getDocument().addDocumentListener(this.documentListener);
        this.getTextComponent().addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (27 != keyEvent.getKeyCode()) {
                    AbstractIntelliHints.this.setKeyTyped(true);
                }
            }
        });
        this.getTextComponent().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                Container container = AbstractIntelliHints.this._popup.getTopLevelAncestor();
                if (container == null) {
                    return;
                }
                Component component = focusEvent.getOppositeComponent();
                if (container == component || container.isAncestorOf(component)) {
                    return;
                }
                AbstractIntelliHints.this.hideHintsPopup();
            }
        });
        DelegateAction.replaceAction(this.getTextComponent(), 0, this.getShowHintsKeyStroke(), showAction);
        for (KeyStroke keyStroke : keyStrokeArray = this.getDelegateKeyStrokes()) {
            DelegateAction.replaceAction(this.getTextComponent(), 0, keyStroke, new LazyDelegateAction(keyStroke));
        }
        this.getDelegateComponent().setRequestFocusEnabled(false);
        this.getDelegateComponent().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                AbstractIntelliHints.this.hideHintsPopup();
                AbstractIntelliHints.this.setHintsEnabled(false);
                AbstractIntelliHints.this.acceptHint(AbstractIntelliHints.this.getSelectedHint());
                AbstractIntelliHints.this.setHintsEnabled(true);
            }
        });
    }

    protected JidePopup createPopup() {
        JidePopup jidePopup = JidePopupFactory.getSharedInstance().createPopup();
        jidePopup.setLayout(new BorderLayout());
        jidePopup.setResizable(true);
        jidePopup.setPopupBorder(BorderFactory.createLineBorder(UIDefaultsLookup.getColor("controlDkShadow"), 1));
        jidePopup.setMovable(false);
        jidePopup.add(this.createHintsComponent());
        jidePopup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                DelegateAction.restoreAction((JComponent)AbstractIntelliHints.this.getTextComponent(), 0, KeyStroke.getKeyStroke(27, 0), AbstractIntelliHints.this.hideAction);
                DelegateAction.restoreAction((JComponent)AbstractIntelliHints.this.getTextComponent(), 0, KeyStroke.getKeyStroke(10, 0), AbstractIntelliHints.this.acceptAction);
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        jidePopup.setTransient(true);
        return jidePopup;
    }

    public JTextComponent getTextComponent() {
        return this._textComponent;
    }

    public void acceptHint(Object object) {
        String string;
        int n2;
        String string2;
        if (object == null) {
            return;
        }
        int n3 = this.getTextComponent().getCaretPosition();
        if (this.isMultilineTextComponent()) {
            string2 = this.getTextComponent().getText();
            n2 = string2.lastIndexOf(10, n3 - 1);
            String string3 = n3 == -1 ? "" : string2.substring(n3);
            string2 = string2.substring(0, n2 + 1);
            string2 = string2 + object;
            string = string2 = string2 + string3;
        } else {
            string = object.toString();
        }
        this.getTextComponent().setText(string);
        string2 = this.getTextComponent().getText();
        n2 = string2.indexOf(10, n3);
        this.getTextComponent().setCaretPosition(n2 == -1 ? string2.length() : n2);
    }

    protected boolean isMultilineTextComponent() {
        return this.getTextComponent() instanceof JTextArea || this.getTextComponent() instanceof JEditorPane;
    }

    protected void showHintsPopup() {
        if (!this.getTextComponent().isEnabled() || !this.getTextComponent().hasFocus()) {
            return;
        }
        this.showHints();
    }

    public void showHints() {
        if (this.updateHints(this.getContext())) {
            DelegateAction.replaceAction(this.getTextComponent(), 0, KeyStroke.getKeyStroke(27, 0), this.hideAction);
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 0, KeyStroke.getKeyStroke(10, 0), this.acceptAction, true);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            try {
                int n5 = this.getCaretPositionForPopup();
                Rectangle rectangle = this.getCaretRectangleForPopup(n5);
                n3 = rectangle.y;
                n2 = rectangle.x;
                n4 = rectangle.height;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this._popup.setOwner(this.getTextComponent());
            this._popup.showPopup(new Insets(n3, n2, this.getTextComponent().getHeight() - n4 - n3, 0));
        } else {
            this._popup.hidePopup();
        }
    }

    protected Rectangle getCaretRectangleForPopup(int n2) throws BadLocationException {
        return this.getTextComponent().getUI().modelToView(this.getTextComponent(), n2);
    }

    protected int getCaretPositionForPopup() {
        int n2 = Math.min(this.getTextComponent().getCaret().getDot(), this.getTextComponent().getCaret().getMark());
        if (this.isFollowCaret()) {
            return n2;
        }
        try {
            Rectangle rectangle = this.getTextComponent().getUI().modelToView(this.getTextComponent(), n2);
            rectangle.x = 0;
            return this.getTextComponent().getUI().viewToModel(this.getTextComponent(), rectangle.getLocation());
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    protected Object getContext() {
        if (this.isMultilineTextComponent()) {
            int n2 = this.getTextComponent().getCaretPosition();
            if (n2 == 0) {
                return "";
            }
            String string = this.getTextComponent().getText();
            int n3 = string.lastIndexOf(10, n2 - 1);
            return string.substring(n3 + 1, n2);
        }
        return this.getTextComponent().getText();
    }

    protected void hideHintsPopup() {
        if (this._popup != null) {
            this._popup.hidePopup();
        }
        this.setKeyTyped(false);
    }

    public void setHintsEnabled(boolean bl) {
        if (!bl) {
            this.getTextComponent().getDocument().removeDocumentListener(this.documentListener);
        } else {
            this.getTextComponent().getDocument().addDocumentListener(this.documentListener);
        }
    }

    public boolean isHintsPopupVisible() {
        return this._popup != null && this._popup.isPopupVisible();
    }

    public boolean isFollowCaret() {
        return this._followCaret;
    }

    public void setFollowCaret(boolean bl) {
        this._followCaret = bl;
    }

    public boolean isAutoPopup() {
        return this._autoPopup;
    }

    public void setAutoPopup(boolean bl) {
        this._autoPopup = bl;
    }

    protected abstract KeyStroke[] getDelegateKeyStrokes();

    protected abstract JComponent getDelegateComponent();

    protected KeyStroke getShowHintsKeyStroke() {
        if (this.isMultilineTextComponent()) {
            return KeyStroke.getKeyStroke(32, 2);
        }
        return KeyStroke.getKeyStroke(40, 0);
    }

    private boolean isKeyTyped() {
        return this._keyTyped;
    }

    private void setKeyTyped(boolean bl) {
        this._keyTyped = bl;
    }

    public static IntelliHints getIntelliHints(JComponent jComponent) {
        return (IntelliHints)jComponent.getClientProperty("INTELLI_HINTS");
    }

    private static class LazyDelegateAction
    extends DelegateAction {
        private KeyStroke _keyStroke;

        public LazyDelegateAction(KeyStroke keyStroke) {
            this._keyStroke = keyStroke;
        }

        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            IntelliHints intelliHints = AbstractIntelliHints.getIntelliHints(jComponent);
            if (intelliHints instanceof AbstractIntelliHints) {
                AbstractIntelliHints abstractIntelliHints = (AbstractIntelliHints)intelliHints;
                if (jComponent.isEnabled() && abstractIntelliHints.isHintsPopupVisible()) {
                    Action action;
                    Object object = abstractIntelliHints.getDelegateComponent().getInputMap().get(this._keyStroke);
                    Object object2 = object = object == null ? abstractIntelliHints.getTextComponent().getInputMap(1).get(this._keyStroke) : object;
                    if (object != null && (action = abstractIntelliHints.getDelegateComponent().getActionMap().get(object)) instanceof Action) {
                        action.actionPerformed(new ActionEvent(abstractIntelliHints.getDelegateComponent(), 0, "" + object));
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

