/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.event;

import java.awt.KeyEventDispatcher;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import org.broad.igv.feature.AbstractFeature;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.variant.VariantTrack;
import org.broad.tribble.Feature;

public class GlobalKeyDispatcher
implements KeyEventDispatcher {
    private final InputMap keyStrokes = new InputMap();
    private final ActionMap actions = new ActionMap();

    public GlobalKeyDispatcher() {
        this.init();
    }

    public InputMap getInputMap() {
        return this.keyStrokes;
    }

    public ActionMap getActionMap() {
        return this.actions;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        Action action;
        if (event.getKeyCode() == 27) {
            IGV.getInstance().getTrackManager().clearSelections();
            IGV.getInstance().repaint();
            return true;
        }
        KeyStroke ks = KeyStroke.getKeyStrokeForEvent(event);
        String actionKey = (String)this.keyStrokes.get(ks);
        if (event.getKeyCode() == 17 || event.getKeyCode() == 18 || event.getKeyCode() == 157) {
            boolean flag = !event.isControlDown() && !event.isAltDown() && !event.isMetaDown();
            ToolTipManager.sharedInstance().setEnabled(flag);
        }
        if (actionKey != null && (action = this.actions.get(actionKey)) != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(event.getSource(), event.getID(), actionKey, event.getModifiers()));
            return true;
        }
        return false;
    }

    public void init() {
        KeyStroke nextKey = KeyStroke.getKeyStroke(70, 2, false);
        KeyStroke prevKey = KeyStroke.getKeyStroke(66, 2, false);
        KeyStroke toolsKey = KeyStroke.getKeyStroke(84, 8, false);
        KeyStroke regionKey = KeyStroke.getKeyStroke(82, 2, false);
        KeyStroke nextExonKey = KeyStroke.getKeyStroke(70, 3, false);
        KeyStroke prevExonKey = KeyStroke.getKeyStroke(66, 3, false);
        KeyStroke backKey1 = KeyStroke.getKeyStroke(93, 256, false);
        KeyStroke backKey2 = KeyStroke.getKeyStroke(37, 512, false);
        KeyStroke forwardKey1 = KeyStroke.getKeyStroke(91, 256, false);
        KeyStroke forwardKey2 = KeyStroke.getKeyStroke(39, 512, false);
        KeyStroke refreshKey = KeyStroke.getKeyStroke(116, 0);
        AbstractAction refreshAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                this.setEnabled(false);
                IGV.getInstance().getTrackManager().refreshData();
                IGV.getInstance().repaintDataPanels();
                this.setEnabled(true);
            }
        };
        AbstractAction toolAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                this.setEnabled(false);
                IGV.getInstance().enableExtrasMenu();
                this.setEnabled(true);
            }
        };
        AbstractAction nextAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                this.setEnabled(false);
                GlobalKeyDispatcher.this.nextFeature(true);
                this.setEnabled(true);
            }
        };
        AbstractAction prevAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                this.setEnabled(false);
                GlobalKeyDispatcher.this.nextFeature(false);
                this.setEnabled(true);
            }
        };
        AbstractAction nextExonAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                this.setEnabled(false);
                GlobalKeyDispatcher.this.nextExon(true);
                this.setEnabled(true);
            }
        };
        AbstractAction prevExonAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                this.setEnabled(false);
                GlobalKeyDispatcher.this.nextExon(false);
                this.setEnabled(true);
            }
        };
        AbstractAction regionAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                this.setEnabled(false);
                if (FrameManager.isGeneListMode()) {
                    return;
                }
                ReferenceFrame.Range currentRange = FrameManager.getDefaultFrame().getCurrentRange();
                RegionOfInterest regionOfInterest = new RegionOfInterest(currentRange.getChr(), currentRange.getStart(), currentRange.getEnd(), null);
                IGV.getInstance().addRegionOfInterest(regionOfInterest);
                this.setEnabled(true);
            }
        };
        AbstractAction backAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IGV.getInstance().getSession().getHistory().back();
            }
        };
        AbstractAction forwardAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IGV.getInstance().getSession().getHistory().forward();
            }
        };
        this.getInputMap().put(nextKey, "nextFeature");
        this.getActionMap().put("nextFeature", nextAction);
        this.getInputMap().put(prevKey, "prevFeature");
        this.getActionMap().put("prevFeature", prevAction);
        this.getInputMap().put(nextExonKey, "nextExon");
        this.getActionMap().put("nextExon", nextExonAction);
        this.getInputMap().put(prevExonKey, "prevExon");
        this.getActionMap().put("prevExon", prevExonAction);
        this.getInputMap().put(toolsKey, "tools");
        this.getActionMap().put("tools", toolAction);
        this.getInputMap().put(regionKey, "region");
        this.getActionMap().put("region", regionAction);
        this.getInputMap().put(backKey1, "back");
        this.getInputMap().put(backKey2, "back");
        this.getActionMap().put("back", backAction);
        this.getInputMap().put(forwardKey1, "forward");
        this.getInputMap().put(forwardKey2, "forward");
        this.getActionMap().put("forward", forwardAction);
        this.getInputMap().put(refreshKey, "refresh");
        this.getActionMap().put("refresh", refreshAction);
    }

    private void nextExon(boolean forward) {
        if (FrameManager.isGeneListMode()) {
            return;
        }
        ReferenceFrame vc = FrameManager.getDefaultFrame();
        Collection<Track> tracks = IGV.getInstance().getTrackManager().getSelectedTracks();
        if (tracks.size() == 1) {
            Track t = tracks.iterator().next();
            if (!(t instanceof FeatureTrack)) {
                return;
            }
            AbstractFeature e2 = null;
            if (t instanceof FeatureTrack) {
                int center = (int)vc.getCenter();
                FeatureTrack ft = (FeatureTrack)t;
                if (ft.getDisplayMode() == Track.DisplayMode.COLLAPSED || ft.getSelectedFeatureRowIndex() == -1) {
                    MessageUtils.showMessage("Exon navigation is only allowed when track is expanded and a single feature row is selected.");
                    return;
                }
                Feature feature = ft.getFeatureAtPositionInFeatureRow(vc.getChrName(), center, ft.getSelectedFeatureRowIndex(), vc);
                if (feature == null) {
                    return;
                }
                if (feature instanceof BasicFeature) {
                    BasicFeature bf = (BasicFeature)feature;
                    List<Exon> exons = bf.getExons();
                    if (exons == null || exons.isEmpty()) {
                        MessageUtils.showMessage("At least one centered feature does not have exon structure");
                        return;
                    }
                    if (forward) {
                        for (Exon exon : bf.getExons()) {
                            if (!((double)exon.getStart() > vc.getCenter() + 1.0)) continue;
                            e2 = exon;
                            break;
                        }
                    } else {
                        for (int i2 = exons.size() - 1; i2 >= 0; --i2) {
                            Exon exon = exons.get(i2);
                            if (!((double)exon.getEnd() < vc.getCenter())) continue;
                            e2 = exon;
                            break;
                        }
                    }
                }
                if (e2 != null) {
                    vc.centerOnLocation(forward ? (double)e2.getStart() : (double)e2.getEnd());
                    int i3 = 3;
                }
            }
        } else {
            MessageUtils.showMessage("To use track panning you must first select a single feature track.");
        }
    }

    private void nextFeature(boolean forward) {
        block10: {
            if (FrameManager.isGeneListMode()) {
                return;
            }
            ReferenceFrame vc = FrameManager.getDefaultFrame();
            Collection<Track> tracks = IGV.getInstance().getTrackManager().getSelectedTracks();
            if (tracks.size() == 1) {
                try {
                    Track t = tracks.iterator().next();
                    if (!(t instanceof FeatureTrack) && !(t instanceof VariantTrack)) {
                        return;
                    }
                    Feature f2 = null;
                    ReferenceFrame frame = FrameManager.getDefaultFrame();
                    if (t instanceof FeatureTrack) {
                        f2 = ((FeatureTrack)t).nextFeature(vc.getChrName(), vc.getCenter(), forward, frame);
                    } else if (t instanceof VariantTrack) {
                        f2 = ((VariantTrack)t).nextFeature(vc.getChrName(), vc.getCenter(), forward, frame);
                    }
                    if (f2 == null) break block10;
                    String chr = IGV.getInstance().getGenomeManager().getCurrentGenome().getChromosomeAlias(f2.getChr());
                    double newCenter = f2.getStart();
                    if (!chr.equals(vc.getChrName())) {
                        double range = vc.getEnd() - vc.getOrigin();
                        int newOrigin = (int)Math.max(newCenter - range / 2.0, 0.0);
                        int newEnd = (int)((double)newOrigin + range);
                        vc.jumpTo(chr, newOrigin, newEnd);
                        break block10;
                    }
                    vc.centerOnLocation(newCenter);
                }
                catch (IOException e2) {
                    MessageUtils.showMessage("Error encountered reading features: " + e2.getMessage());
                }
            } else {
                MessageUtils.showMessage("To use track panning you must first select a single feature track.");
            }
        }
    }
}

