/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.SpliceJunctionFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.PairedAlignment;

public class SpliceJunctionHelper {
    static Logger log = Logger.getLogger(SpliceJunctionHelper.class);
    static int minReadFlankingWidth = 0;
    static int minJunctionCoverage = 1;

    public static List<SpliceJunctionFeature> computeFeatures(Iterator<Alignment> iterator) throws IOException {
        ArrayList<SpliceJunctionFeature> spliceJunctionFeatures = new ArrayList<SpliceJunctionFeature>();
        HashMap posStartEndJunctionsMap = new HashMap();
        HashMap negStartEndJunctionsMap = new HashMap();
        while (iterator.hasNext()) {
            Alignment alignmentFromIterator = iterator.next();
            ArrayList<Alignment> alignmentsRepresentedByThisAlignment = new ArrayList<Alignment>();
            if (alignmentFromIterator instanceof PairedAlignment) {
                PairedAlignment alAsPair = (PairedAlignment)alignmentFromIterator;
                if (alAsPair.getFirstAlignment() != null) {
                    alignmentsRepresentedByThisAlignment.add(alAsPair.getFirstAlignment());
                }
                if (alAsPair.getSecondAlignment() != null) {
                    alignmentsRepresentedByThisAlignment.add(alAsPair.getSecondAlignment());
                }
            } else {
                alignmentsRepresentedByThisAlignment.add(alignmentFromIterator);
            }
            for (Alignment alignment : alignmentsRepresentedByThisAlignment) {
                AlignmentBlock[] blocks = alignment.getAlignmentBlocks();
                if (blocks.length < 2) continue;
                boolean isNegativeStrand = false;
                Object strandAttr = alignment.getAttribute("XS");
                if (strandAttr != null) {
                    isNegativeStrand = strandAttr.toString().charAt(0) == '-';
                }
                HashMap startEndJunctionsMapThisStrand = isNegativeStrand ? negStartEndJunctionsMap : posStartEndJunctionsMap;
                int flankingStart = -1;
                int junctionStart = -1;
                int gapCount = -1;
                char[] gapTypes = alignment.getGapTypes();
                for (AlignmentBlock block : blocks) {
                    int flankingEnd = block.getEnd();
                    int junctionEnd = block.getStart();
                    if (junctionStart != -1 && gapCount < gapTypes.length && gapTypes[gapCount] == 'N' && (minReadFlankingWidth == 0 || junctionStart - flankingStart >= minReadFlankingWidth && flankingEnd - junctionEnd >= minReadFlankingWidth)) {
                        SpliceJunctionFeature junction;
                        HashMap<Integer, SpliceJunctionFeature> endJunctionsMap = (HashMap<Integer, SpliceJunctionFeature>)startEndJunctionsMapThisStrand.get(junctionStart);
                        if (endJunctionsMap == null) {
                            endJunctionsMap = new HashMap<Integer, SpliceJunctionFeature>();
                            startEndJunctionsMapThisStrand.put(junctionStart, endJunctionsMap);
                        }
                        if ((junction = (SpliceJunctionFeature)endJunctionsMap.get(junctionEnd)) == null) {
                            junction = new SpliceJunctionFeature(alignment.getChr(), junctionStart, junctionEnd, isNegativeStrand ? Strand.NEGATIVE : Strand.POSITIVE);
                            endJunctionsMap.put(junctionEnd, junction);
                            spliceJunctionFeatures.add(junction);
                        }
                        junction.addRead(flankingStart, flankingEnd);
                    }
                    flankingStart = junctionEnd;
                    junctionStart = flankingEnd;
                    ++gapCount;
                }
            }
        }
        if (minJunctionCoverage > 1) {
            ArrayList<SpliceJunctionFeature> coveredFeatures = new ArrayList<SpliceJunctionFeature>(spliceJunctionFeatures.size());
            for (SpliceJunctionFeature feature : spliceJunctionFeatures) {
                if (feature.getJunctionDepth() < minJunctionCoverage) continue;
                coveredFeatures.add(feature);
            }
            spliceJunctionFeatures = coveredFeatures;
        }
        Collections.sort(spliceJunctionFeatures, new Comparator<IGVFeature>(){

            @Override
            public int compare(IGVFeature o1, IGVFeature o2) {
                return o1.getStart() - o2.getStart();
            }
        });
        return spliceJunctionFeatures;
    }
}

