/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic.tools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.broad.igv.hic.data.Chromosome;
import org.broad.igv.hic.tools.AlignmentsSorter;
import org.broad.igv.hic.tools.Preprocessor;

public class HiCTools {
    public static Chromosome[] chromosomes;
    public static Map<String, Integer> chromosomeOrdinals;
    public static final Chromosome[] dmelChromosomes;
    public static final Chromosome[] hg18Chromosomes;

    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            System.out.println("Usage: hictools <command> <inputFile> <outputFile>");
        }
        if (args[0].equals("sort")) {
            AlignmentsSorter.sort(args[1], args[2], null);
        } else if (args[0].equals("pre")) {
            String genomeId = args[3];
            chromosomes = genomeId.equals("hg18") ? hg18Chromosomes : dmelChromosomes;
            long genomeLength = 0L;
            for (Chromosome c2 : chromosomes) {
                if (c2 == null) continue;
                genomeLength += (long)c2.getSize();
            }
            HiCTools.chromosomes[0] = new Chromosome(0, "All", (int)(genomeLength / 1000L));
            chromosomeOrdinals = new Hashtable<String, Integer>();
            for (int i2 = 0; i2 < chromosomes.length; ++i2) {
                chromosomeOrdinals.put(chromosomes[i2].getName(), i2);
            }
            String[] tokens = args[1].split(",");
            ArrayList<String> files = new ArrayList<String>(tokens.length);
            for (String f2 : tokens) {
                files.add(f2);
            }
            new Preprocessor(new File(args[2])).preprocess(files, genomeId);
        }
    }

    static {
        dmelChromosomes = new Chromosome[]{null, new Chromosome(1, "2L", 22407834), new Chromosome(2, "2R", 20766785), new Chromosome(3, "3L", 23771897), new Chromosome(4, "3R", 27905053), new Chromosome(5, "4", 1281640), new Chromosome(6, "X", 22224390)};
        hg18Chromosomes = new Chromosome[]{null, new Chromosome(1, "1", 247249719), new Chromosome(2, "2", 242951149), new Chromosome(3, "3", 199501827), new Chromosome(4, "4", 191273063), new Chromosome(5, "5", 180857866), new Chromosome(6, "6", 170899992), new Chromosome(7, "7", 158821424), new Chromosome(8, "8", 146274826), new Chromosome(9, "9", 140273252), new Chromosome(10, "10", 135374737), new Chromosome(11, "11", 134452384), new Chromosome(12, "12", 132349534), new Chromosome(13, "13", 114142980), new Chromosome(14, "14", 106368585), new Chromosome(15, "15", 100338915), new Chromosome(16, "16", 88827254), new Chromosome(17, "17", 78774742), new Chromosome(18, "18", 76117153), new Chromosome(19, "19", 63811651), new Chromosome(20, "20", 62435964), new Chromosome(21, "21", 46944323), new Chromosome(22, "22", 49691432), new Chromosome(23, "23", 154913754), new Chromosome(24, "24", 57772954), new Chromosome(25, "0", 16571)};
    }
}

