/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.graph;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.broad.igv.feature.AbstractFeatureParser;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.FeatureParser;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.graph.Graph;
import org.broad.igv.graph.Node;
import org.broad.igv.graph.SubGraph;
import org.broad.igv.util.ColorUtilities;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.tribble.Feature;
import org.broad.tribble.readers.AsciiLineReader;

public class GeneUtils {
    static String file = "hg18_refGene.txt";
    static HashMap<String, List<BasicFeature>> transcripts;

    public static Graph getGraphFor(String gene, Genome genome) throws IOException {
        if (transcripts == null) {
            GeneUtils.loadGenes(genome);
        }
        return GeneUtils.createGraph(transcripts.get(gene));
    }

    private static Graph createGraph(List<BasicFeature> transcripts) {
        Graph graph = new Graph();
        HashSet<String> locusStrings = new HashSet<String>();
        ArrayList<Exon> uniqExons = new ArrayList<Exon>();
        for (BasicFeature t : transcripts) {
            for (Exon exon : t.getExons()) {
                String locus = exon.getLocusString();
                if (locusStrings.contains(locus)) continue;
                uniqExons.add(exon);
                locusStrings.add(locus);
            }
        }
        Collections.sort(uniqExons, new Comparator<Exon>(){

            @Override
            public int compare(Exon exon1, Exon exon2) {
                return exon1.getStart() - exon2.getStart();
            }
        });
        HashMap<String, Node> nodes = new HashMap<String, Node>();
        for (Exon exon : uniqExons) {
            String key = exon.getLocusString();
            nodes.put(key, new Node(exon.getStart()));
        }
        int idx = 1;
        for (BasicFeature t : transcripts) {
            SubGraph sg = new SubGraph();
            Color color = ColorUtilities.randomColor(idx, 0.5f);
            List<Exon> exons = t.getExons();
            for (int i2 = 0; i2 < exons.size() - 1; ++i2) {
                Node n1 = (Node)nodes.get(exons.get(i2).getLocusString());
                Node n2 = (Node)nodes.get(exons.get(i2 + 1).getLocusString());
                sg.addEdge(n1, n2, color);
                graph.addNode(n1);
                graph.addNode(n2);
            }
            ++idx;
            graph.addSubGraph(sg);
        }
        graph.updateLayout();
        return graph;
    }

    private static void loadGenes(Genome genome) throws IOException {
        transcripts = new HashMap();
        FeatureParser fp = AbstractFeatureParser.getInstanceFor(file, genome);
        AsciiLineReader reader = ParsingUtils.openAsciiReader(new ResourceLocator(file));
        List<Feature> features = fp.loadFeatures(reader);
        for (Feature f2 : features) {
            BasicFeature bf = (BasicFeature)f2;
            List<BasicFeature> tlist = transcripts.get(bf.getName().toUpperCase());
            if (tlist == null) {
                tlist = new ArrayList<BasicFeature>();
                transcripts.put(bf.getName().toUpperCase(), tlist);
            }
            tlist.add(bf);
        }
    }
}

