/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.util.HttpURLConnectionUtils;
import org.broad.igv.util.IGVHttpClientUtils;
import org.broad.igv.util.stream.IGVUrlHelper;
import org.broad.tribble.util.SeekableHTTPStream;

public abstract class HttpUtils {
    private static Logger log = Logger.getLogger(HttpUtils.class);
    public static boolean byteRangeTested = false;
    public static boolean useByteRange = true;

    public static HttpUtils getInstance() {
        boolean genomeSpaceEnabled = PreferenceManager.getInstance().getAsBoolean("GENOME_SPACE_ENABLE");
        return genomeSpaceEnabled ? IGVHttpClientUtils.getInstance() : HttpURLConnectionUtils.getInstance();
    }

    public static boolean isURL(String string) {
        String lcString = string.toLowerCase();
        return lcString.startsWith("http://") || lcString.startsWith("https://") || lcString.startsWith("ftp://") || lcString.startsWith("file://");
    }

    public static boolean testByteRange() {
        try {
            String testURL = "http://www.broadinstitute.org/igvdata/byteRangeTest.txt";
            byte[] expectedBytes = new byte[]{107, 108, 109, 110, 111};
            SeekableHTTPStream str = new SeekableHTTPStream(new IGVUrlHelper(new URL(testURL)));
            str.seek(10L);
            byte[] buffer = new byte[5];
            str.read(buffer, 0, 5);
            for (int i2 = 0; i2 < buffer.length; ++i2) {
                if (buffer[i2] == expectedBytes[i2]) continue;
                return false;
            }
            return true;
        }
        catch (IOException e2) {
            log.error("Error while testing byte range ", e2);
            return true;
        }
    }

    public static boolean useByteRange() {
        useByteRange = PreferenceManager.getInstance().getAsBoolean("UseHttpByteRange");
        if (useByteRange && !byteRangeTested) {
            useByteRange = HttpUtils.testByteRange();
            byteRangeTested = true;
        }
        return useByteRange;
    }

    public abstract void shutdown();

    public abstract String getContentsAsString(URL var1) throws IOException;

    public abstract InputStream openConnectionStream(URL var1) throws IOException;

    public abstract InputStream openConnectionStream(URL var1, boolean var2) throws IOException;

    public abstract InputStream openConnectionStream(URL var1, Map<String, String> var2) throws IOException;

    public abstract InputStream openConnectionStream(URL var1, boolean var2, Map<String, String> var3) throws IOException;

    public abstract boolean resourceAvailable(URL var1);

    public abstract String getHeaderField(URL var1, String var2) throws IOException;

    public abstract long getContentLength(URL var1) throws IOException;

    public abstract void updateProxySettings();

    public abstract boolean downloadFile(String var1, File var2) throws IOException;

    public abstract void uploadFile(URI var1, File var2, Map<String, String> var3) throws IOException;

    public abstract String createDirectory(URL var1, String var2) throws IOException;
}

