/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.IGVHttpClientUtils;
import org.broad.igv.util.LoginDialog;
import org.broad.igv.util.Utilities;
import org.broad.igv.util.ftp.FTPClient;
import org.broad.igv.util.ftp.FTPStream;
import org.broad.igv.util.ftp.FTPUtils;
import sun.misc.BASE64Encoder;

public class HttpURLConnectionUtils
extends HttpUtils {
    private static Logger log = Logger.getLogger(IGVHttpClientUtils.class);
    private static ProxySettings proxySettings = null;
    private static HttpURLConnectionUtils instance;
    public static final int MAX_REDIRECTS = 5;

    public static HttpURLConnectionUtils getInstance() {
        return instance;
    }

    private HttpURLConnectionUtils() {
        Authenticator.setDefault(new IGVAuthenticator());
    }

    private void disableCertificateValidation() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getContentsAsString(URL url) throws IOException {
        return HttpURLConnectionUtils.openConnection(url, null).getContent().toString();
    }

    @Override
    public InputStream openConnectionStream(URL url) throws IOException {
        if (url.getProtocol().toUpperCase().equals("FTP")) {
            String userInfo = url.getUserInfo();
            String host = url.getHost();
            String file = url.getPath();
            FTPClient ftp = FTPUtils.connect(host, userInfo);
            ftp.pasv();
            ftp.retr(file);
            return new FTPStream(ftp);
        }
        return this.openConnectionStream(url, null);
    }

    @Override
    public InputStream openConnectionStream(URL url, boolean abortOnClose) throws IOException {
        return HttpURLConnectionUtils.openConnection(url, null).getInputStream();
    }

    @Override
    public InputStream openConnectionStream(URL url, Map<String, String> requestProperties) throws IOException {
        HttpURLConnection conn = HttpURLConnectionUtils.openConnection(url, requestProperties);
        return conn.getInputStream();
    }

    @Override
    public InputStream openConnectionStream(URL url, boolean abortOnClose, Map<String, String> requestProperties) throws IOException {
        HttpURLConnection conn = HttpURLConnectionUtils.openConnection(url, requestProperties);
        return conn.getInputStream();
    }

    @Override
    public boolean resourceAvailable(URL url) {
        try {
            HttpURLConnection conn = HttpURLConnectionUtils.openConnection(url, null, "HEAD");
            int code = conn.getResponseCode();
            return code == 200;
        }
        catch (IOException e2) {
            return false;
        }
    }

    @Override
    public String getHeaderField(URL url, String key) throws IOException {
        HttpURLConnection conn = HttpURLConnectionUtils.openConnection(url, null, "HEAD");
        int code = conn.getResponseCode();
        return conn.getHeaderField(key);
    }

    @Override
    public long getContentLength(URL url) throws IOException {
        String contentLengthString = "";
        contentLengthString = this.getHeaderField(url, "Content-Length");
        if (contentLengthString == null) {
            return -1L;
        }
        return Long.parseLong(contentLengthString);
    }

    @Override
    public void updateProxySettings() {
        int proxyPort = -1;
        boolean auth = false;
        String user = null;
        String pw = null;
        PreferenceManager prefMgr = PreferenceManager.getInstance();
        boolean useProxy = prefMgr.getAsBoolean("PROXY.USE");
        String proxyHost = prefMgr.get("PROXY.HOST", null);
        try {
            proxyPort = Integer.parseInt(prefMgr.get("PROXY.PORT", "-1"));
        }
        catch (NumberFormatException e2) {
            proxyPort = -1;
        }
        auth = prefMgr.getAsBoolean("PROXY.AUTHENTICATE");
        user = prefMgr.get("PROXY.USERNAME", null);
        String pwString = prefMgr.get("PROXY.PW", null);
        if (pwString != null) {
            pw = Utilities.base64Decode(pwString);
        }
        proxySettings = new ProxySettings(useProxy, user, pw, auth, proxyHost, proxyPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean downloadFile(String url, File outputFile) throws IOException {
        log.info("Downloading " + url + " to " + outputFile.getAbsolutePath());
        HttpURLConnection conn = HttpURLConnectionUtils.openConnection(new URL(url), null);
        int code = conn.getResponseCode();
        long contentLength = -1L;
        String contentLengthString = conn.getHeaderField("Content-Length");
        if (contentLengthString != null) {
            contentLength = Long.parseLong(contentLengthString);
        }
        log.info("Content length = " + contentLength);
        InputStream is = null;
        FileOutputStream out = null;
        try {
            is = conn.getInputStream();
            out = new FileOutputStream(outputFile);
            byte[] buf = new byte[65536];
            int downloaded = 0;
            int bytesRead = 0;
            while ((bytesRead = is.read(buf)) != -1) {
                ((OutputStream)out).write(buf, 0, bytesRead);
                downloaded += bytesRead;
            }
            log.info("Download complete.  Total bytes downloaded = " + downloaded);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (out != null) {
                out.flush();
                ((OutputStream)out).close();
            }
        }
        long fileLength = outputFile.length();
        return contentLength <= 0L || contentLength == fileLength;
    }

    @Override
    public void uploadFile(URI uri, File localFile, Map<String, String> headers) {
    }

    @Override
    public String createDirectory(URL url, String body) {
        return null;
    }

    private static HttpURLConnection openConnection(URL url, Map<String, String> requestProperties) throws IOException {
        return HttpURLConnectionUtils.openConnection(url, requestProperties, "GET");
    }

    private static HttpURLConnection openConnection(URL url, Map<String, String> requestProperties, String method) throws IOException {
        return HttpURLConnectionUtils.openConnection(url, requestProperties, method, 0);
    }

    private static HttpURLConnection openConnection(URL url, Map<String, String> requestProperties, String method, int redirectCount) throws IOException {
        int code;
        boolean useProxy = proxySettings != null && HttpURLConnectionUtils.proxySettings.useProxy && HttpURLConnectionUtils.proxySettings.proxyHost != null && HttpURLConnectionUtils.proxySettings.proxyPort > 0;
        HttpURLConnection conn = null;
        if (useProxy) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(HttpURLConnectionUtils.proxySettings.proxyHost, HttpURLConnectionUtils.proxySettings.proxyPort));
            conn = (HttpURLConnection)url.openConnection(proxy);
            if (HttpURLConnectionUtils.proxySettings.auth && HttpURLConnectionUtils.proxySettings.user != null && HttpURLConnectionUtils.proxySettings.pw != null) {
                byte[] bytes = (HttpURLConnectionUtils.proxySettings.user + ":" + HttpURLConnectionUtils.proxySettings.pw).getBytes();
                String encodedUserPwd = new BASE64Encoder().encode(bytes);
                conn.setRequestProperty("Proxy-Authorization", "Basic " + encodedUserPwd);
            }
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(60000);
        conn.setRequestMethod(method);
        conn.setRequestProperty("Connection", "close");
        if (requestProperties != null) {
            for (Map.Entry<String, String> prop : requestProperties.entrySet()) {
                conn.setRequestProperty(prop.getKey(), prop.getValue());
            }
        }
        if ((code = conn.getResponseCode()) > 300 && code < 400) {
            if (redirectCount > 5) {
                throw new IOException("Too many redirects");
            }
            String newLocation = conn.getHeaderField("Location");
            if (newLocation != null) {
                log.debug("Redirecting to " + newLocation);
                return HttpURLConnectionUtils.openConnection(new URL(newLocation), requestProperties, method, redirectCount++);
            }
            throw new IOException("Server indicated redirect but Location header is missing");
        }
        if (code > 400) {
            throw new IOException("Server returned error code " + code);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<HttpURLConnectionUtils> clazz = HttpURLConnectionUtils.class;
        synchronized (HttpURLConnectionUtils.class) {
            instance = new HttpURLConnectionUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static class IGVAuthenticator
    extends Authenticator {
        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            boolean isProxyChallenge;
            Authenticator.RequestorType type = this.getRequestorType();
            URL url = this.getRequestingURL();
            boolean bl = isProxyChallenge = type == Authenticator.RequestorType.PROXY;
            if (isProxyChallenge && proxySettings.auth && proxySettings.user != null && proxySettings.pw != null) {
                return new PasswordAuthentication(proxySettings.user, proxySettings.pw.toCharArray());
            }
            Frame owner = IGV.hasInstance() ? IGV.getMainFrame() : null;
            LoginDialog dlg = new LoginDialog(owner, false, url.toString(), isProxyChallenge);
            dlg.setVisible(true);
            if (dlg.isCanceled()) {
                return null;
            }
            String userString = dlg.getUsername();
            char[] userPass = dlg.getPassword();
            if (isProxyChallenge) {
                proxySettings.user = userString;
                proxySettings.pw = new String(userPass);
            }
            return new PasswordAuthentication(userString, userPass);
        }
    }

    public static class ProxySettings {
        boolean auth = false;
        String user;
        String pw;
        boolean useProxy;
        String proxyHost;
        int proxyPort = -1;

        public ProxySettings(boolean useProxy, String user, String pw, boolean auth, String proxyHost, int proxyPort) {
            this.auth = auth;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.pw = pw;
            this.useProxy = useProxy;
            this.user = user;
        }
    }
}

