/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.batch.BatchRunner;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.LoadFilesMenuAction;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.FileChooserDialog;

public class RunScriptMenuAction
extends MenuAction {
    static Logger log = Logger.getLogger(LoadFilesMenuAction.class);
    IGV mainFrame;

    public RunScriptMenuAction(String label, int mnemonic, IGV mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        this.setToolTipText("Load data, features or sample information");
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        File script;
        if (e2.getActionCommand().equalsIgnoreCase("run batch script...") && (script = this.chooseScriptFile()) != null && script.isFile()) {
            final BatchRunner bRun = new BatchRunner(script.getPath());
            SwingWorker worker = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    bRun.run();
                    return null;
                }
            };
            worker.execute();
        }
    }

    private File chooseScriptFile() {
        File lastDirectoryFile = PreferenceManager.getInstance().getLastTrackDirectory();
        File scriptFile = null;
        FileChooserDialog trackFileDialog = this.mainFrame.getTrackFileChooser();
        RunScriptMenuAction runScriptMenuAction = this;
        trackFileDialog.setLocationRelativeTo(runScriptMenuAction.mainFrame.getMainFrame());
        trackFileDialog.setTitle("Select Script");
        trackFileDialog.setMultiSelectionEnabled(true);
        trackFileDialog.setSelectedFile(null);
        trackFileDialog.setCurrentDirectory(lastDirectoryFile);
        trackFileDialog.setFileSelectionMode(0);
        trackFileDialog.setVisible(true);
        if (!trackFileDialog.isCanceled()) {
            File lastFile = trackFileDialog.getSelectedFile();
            if (lastFile != null && !lastFile.isDirectory()) {
                lastFile = lastFile.getParentFile();
                PreferenceManager.getInstance().setLastTrackDirectory(lastFile);
            }
            scriptFile = trackFileDialog.getSelectedFile();
            trackFileDialog.setSelectedFile(null);
        }
        this.mainFrame.resetStatusMessage();
        return scriptFile;
    }
}

